/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container;

import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import org.exoplatform.container.ComponentTaskContextEntry;
import org.exoplatform.container.ComponentTaskType;
import org.exoplatform.container.ConcurrentContainer;
import org.exoplatform.container.CyclicDependencyException;

public class ComponentTaskContext {
    private final LinkedHashSet<ComponentTaskContextEntry> dependencies;
    private final ComponentTaskContextEntry lastDependency;
    private final ComponentTaskType lastTaskType;
    private Map<Object, ConcurrentContainer.CreationalContextComponentAdapter<?>> depResolutionCtx;

    private ComponentTaskContext(LinkedHashSet<ComponentTaskContextEntry> dependencies, Map<Object, ConcurrentContainer.CreationalContextComponentAdapter<?>> depResolutionCtx, ComponentTaskContextEntry lastDependency, ComponentTaskType lastTaskType) {
        this.dependencies = dependencies;
        this.depResolutionCtx = depResolutionCtx;
        this.lastDependency = lastDependency;
        this.lastTaskType = lastTaskType;
    }

    public ComponentTaskContext(Object componentKey, ComponentTaskType type) {
        LinkedHashSet<ComponentTaskContextEntry> dependencies = new LinkedHashSet<ComponentTaskContextEntry>();
        ComponentTaskContextEntry entry = new ComponentTaskContextEntry(componentKey, type);
        dependencies.add(entry);
        this.dependencies = dependencies;
        this.lastDependency = entry;
        this.lastTaskType = type;
    }

    public ComponentTaskContext setLastTaskType(ComponentTaskType lastTaskType) {
        return new ComponentTaskContext(this.dependencies, this.depResolutionCtx == null ? null : new HashMap(this.depResolutionCtx), this.lastDependency, lastTaskType);
    }

    public ComponentTaskContext addToContext(Object componentKey) throws CyclicDependencyException {
        return this.addToContext(componentKey, this.lastTaskType);
    }

    public ComponentTaskContext addToContext(Object componentKey, ComponentTaskType type) throws CyclicDependencyException {
        ComponentTaskContextEntry entry = new ComponentTaskContextEntry(componentKey, type);
        this.checkDependency(entry);
        LinkedHashSet<ComponentTaskContextEntry> dependencies = new LinkedHashSet<ComponentTaskContextEntry>(this.dependencies);
        dependencies.add(entry);
        return new ComponentTaskContext(dependencies, this.depResolutionCtx == null ? null : new HashMap(this.depResolutionCtx), entry, type);
    }

    public void checkDependency(Object componentKey, ComponentTaskType type) throws CyclicDependencyException {
        ComponentTaskContextEntry entry = new ComponentTaskContextEntry(componentKey, type);
        this.checkDependency(entry);
    }

    public boolean isLast(Object componentKey) {
        ComponentTaskContextEntry entry = new ComponentTaskContextEntry(componentKey, this.lastTaskType);
        return this.lastDependency.equals(entry);
    }

    private void checkDependency(ComponentTaskContextEntry entry) {
        if (entry.getTaskType() == ComponentTaskType.CREATE && this.dependencies.contains(entry) && (this.depResolutionCtx == null || !this.depResolutionCtx.containsKey(entry.getComponentKey()) || this.depResolutionCtx.get(entry.getComponentKey()).get() == null)) {
            boolean startToCheck = false;
            Boolean sameType = null;
            for (ComponentTaskContextEntry e : this.dependencies) {
                if (startToCheck) {
                    if (e.getTaskType() != entry.getTaskType()) {
                        sameType = Boolean.FALSE;
                        break;
                    }
                    sameType = Boolean.TRUE;
                    continue;
                }
                if (!entry.equals(e)) continue;
                startToCheck = true;
            }
            if (sameType != null && sameType.booleanValue()) {
                throw new CyclicDependencyException(entry, sameType);
            }
        }
    }

    public boolean isRoot() {
        return this.dependencies.size() == 1;
    }

    public <T> ConcurrentContainer.CreationalContextComponentAdapter<T> addComponentToContext(Object key, ConcurrentContainer.CreationalContextComponentAdapter<T> ctx) {
        if (this.depResolutionCtx == null) {
            this.depResolutionCtx = new HashMap();
            this.depResolutionCtx.put(key, ctx);
            return ctx;
        }
        ConcurrentContainer.CreationalContextComponentAdapter<?> prevValue = this.depResolutionCtx.get(key);
        if (prevValue == null) {
            this.depResolutionCtx.put(key, ctx);
            return ctx;
        }
        return prevValue;
    }

    public ConcurrentContainer.CreationalContextComponentAdapter<?> removeComponentFromContext(Object key) {
        if (this.depResolutionCtx == null) {
            return null;
        }
        return this.depResolutionCtx.remove(key);
    }

    public <T> T getComponentInstanceFromContext(Object key, Class<T> bindType) {
        if (this.depResolutionCtx == null) {
            return null;
        }
        ConcurrentContainer.CreationalContextComponentAdapter<?> ctx = this.depResolutionCtx.get(key);
        return ctx == null ? null : (T)bindType.cast(ctx.get());
    }

    public ComponentTaskContext resetDependencies(Object key, ComponentTaskType type) {
        LinkedHashSet<ComponentTaskContextEntry> dependencies = new LinkedHashSet<ComponentTaskContextEntry>();
        ComponentTaskContextEntry entry = new ComponentTaskContextEntry(key, type);
        dependencies.add(entry);
        return new ComponentTaskContext(dependencies, this.depResolutionCtx == null ? null : new HashMap(this.depResolutionCtx), entry, type);
    }

    public String toString() {
        return "ComponentTaskContext [dependencies=" + String.valueOf(this.dependencies) + ", depResolutionCtx=" + String.valueOf(this.depResolutionCtx) + "]";
    }
}

