/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.jmx;

import javax.management.MalformedObjectNameException;
import javax.management.ObjectName;
import junit.framework.TestCase;
import org.exoplatform.management.jmx.annotations.NameTemplate;
import org.exoplatform.management.jmx.annotations.Property;
import org.exoplatform.management.jmx.impl.ObjectNameBuilder;

public class TestNameTemplate
extends TestCase {
    public <T> void assertCannotBuild(T o, Class<T> clazz) {
        try {
            ObjectNameBuilder builder = new ObjectNameBuilder("foo", clazz);
            builder.build(o);
            TestNameTemplate.fail();
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public <T> void assertSame(T o, Class<T> clazz, String value) {
        ObjectName expectedValue;
        try {
            expectedValue = new ObjectName(value);
        }
        catch (MalformedObjectNameException e) {
            throw new AssertionError((Object)e);
        }
        ObjectNameBuilder builder = new ObjectNameBuilder("foo", clazz);
        TestNameTemplate.assertEquals((Object)expectedValue, (Object)builder.build(o));
    }

    public void testSame() {
        this.assertSame(new MBean1(), MBean1.class, "foo:a=b");
        this.assertSame(new MBean2(), MBean2.class, "foo:a=something");
        this.assertSame(new MBean3(), MBean3.class, "foo:foo=3");
    }

    public void testCannotBuilder() {
        this.assertCannotBuild(new MBean4(), MBean4.class);
        this.assertCannotBuild(new MBean5(), MBean5.class);
        this.assertCannotBuild(new MBean6(), MBean6.class);
        this.assertCannotBuild(new MBean7(), MBean7.class);
        this.assertCannotBuild(new MBean8(), MBean8.class);
        this.assertCannotBuild(new MBean9(), MBean9.class);
        this.assertCannotBuild(new MBean11(), MBean11.class);
        this.assertCannotBuild(new MBean12(), MBean12.class);
    }

    public void testNoAnnotation() {
        ObjectNameBuilder builder = new ObjectNameBuilder("foo", MBean13.class);
        TestNameTemplate.assertEquals(null, (Object)builder.build((Object)new MBean13()));
    }

    public void testInheritence() {
        this.assertSame(new MBean14(), MBean14.class, "foo:a=b");
        this.assertSame(new MBean15(), MBean15.class, "foo:c=d");
        this.assertSame(new MBean16(), MBean16.class, "foo:e=f");
        this.assertSame(new MBean17(), MBean17.class, "foo:g=h");
        this.assertSame(new MBean18(), MBean18.class, "foo:g=h");
        this.assertSame(new MBean19(), MBean19.class, "foo:i=j");
    }

    @NameTemplate(value={@Property(key="a", value="b")})
    public static class MBean1 {
    }

    @NameTemplate(value={@Property(key="a", value="{B}")})
    public static class MBean2 {
        public String getB() {
            return "something";
        }
    }

    @NameTemplate(value={@Property(key="foo", value="{Foo}")})
    public static class MBean3 {
        public Integer getFoo() {
            return 3;
        }
    }

    @NameTemplate(value={@Property(key="a", value="{b}")})
    public static class MBean4 {
    }

    @NameTemplate(value={@Property(key="a", value="{b}")})
    public static class MBean5 {
        public void getB() {
        }
    }

    @NameTemplate(value={@Property(key="a", value="{b}")})
    public static class MBean6 {
        public String getB(String s) {
            return "Foo";
        }
    }

    @NameTemplate(value={@Property(key="a", value="{b}")})
    public static class MBean7 {
        public String getB() {
            throw new RuntimeException();
        }
    }

    @NameTemplate(value={@Property(key="a", value="{b}")})
    public static class MBean8 {
        public String getB() {
            return null;
        }
    }

    @NameTemplate(value={@Property(key="a", value="{b}")})
    public static class MBean9 {
        public static String getB() {
            return "Foo";
        }
    }

    @NameTemplate(value={@Property(key="a", value="{b}")})
    public static class MBean11 {
        protected String getB() {
            return "Foo";
        }
    }

    @NameTemplate(value={@Property(key="a", value="{b}")})
    public static class MBean12 {
        public String getB() {
            return "=";
        }
    }

    public static class MBean13 {
    }

    public static class MBean14
    implements Interface1 {
    }

    @NameTemplate(value={@Property(key="c", value="d")})
    public static class MBean15
    implements Interface1 {
    }

    public static class MBean16
    implements Interface2 {
    }

    @NameTemplate(value={@Property(key="g", value="h")})
    public static class MBean17 {
    }

    public static class MBean18
    extends MBean17 {
    }

    @NameTemplate(value={@Property(key="i", value="j")})
    public static class MBean19
    extends MBean17 {
    }

    @NameTemplate(value={@Property(key="e", value="f")})
    public static interface Interface2
    extends Interface1 {
    }

    @NameTemplate(value={@Property(key="a", value="b")})
    public static interface Interface1 {
    }
}

