/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.management.spi;

import java.lang.reflect.Method;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.exoplatform.management.spi.ManagedMetaData;
import org.exoplatform.management.spi.ManagedMethodMetaData;
import org.exoplatform.management.spi.ManagedPropertyMetaData;

public class ManagedTypeMetaData
extends ManagedMetaData {
    private final Class type;
    private final Map<String, ManagedPropertyMetaData> properties;
    private final Map<MethodKey, ManagedMethodMetaData> methods;

    public ManagedTypeMetaData(Class type) throws IllegalArgumentException {
        if (type == null) {
            throw new IllegalArgumentException("The type cannot be null");
        }
        this.type = type;
        this.properties = new HashMap<String, ManagedPropertyMetaData>();
        this.methods = new HashMap<MethodKey, ManagedMethodMetaData>();
    }

    public Class getType() {
        return this.type;
    }

    public ManagedPropertyMetaData getProperty(String propertyName) {
        return this.properties.get(propertyName);
    }

    public void addProperty(ManagedPropertyMetaData property) {
        this.properties.put(property.getName(), property);
    }

    public void addMethod(ManagedMethodMetaData method) {
        this.methods.put(new MethodKey(method.getMethod()), method);
    }

    public Collection<ManagedMethodMetaData> getMethods() {
        return this.methods.values();
    }

    public Collection<ManagedPropertyMetaData> getProperties() {
        return this.properties.values();
    }

    private static class MethodKey {
        private final String name;
        private final List<Class<?>> types;

        private MethodKey(Method method) {
            this.name = method.getName();
            this.types = Arrays.asList(method.getParameterTypes());
        }

        public int hashCode() {
            int hashCode = this.name.hashCode();
            for (Class<?> type : this.types) {
                hashCode = hashCode * 41 + type.hashCode();
            }
            return hashCode;
        }

        public boolean equals(Object obj) {
            if (obj == this) {
                return true;
            }
            if (obj instanceof MethodKey) {
                MethodKey that = (MethodKey)obj;
                return this.name.equals(that.name) && this.types.equals(that.types);
            }
            return false;
        }
    }
}

