/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.container.test;

import java.beans.PropertyChangeListener;
import java.beans.PropertyChangeSupport;

public class State {
    private String name = null;
    private String state = null;
    private PropertyChangeSupport changes = new PropertyChangeSupport(this);

    public State(String name) {
        this.name = name;
        this.state = "NOTRUN";
    }

    public String getName() {
        return this.name;
    }

    public String getState() {
        return this.state;
    }

    public void setState(String newState) {
        String oldState = this.state;
        this.state = newState;
        this.changes.firePropertyChange("state", oldState, newState);
    }

    public boolean inState(String aName, String aState) {
        return this.name.equals(aName) && this.state.equals(aState);
    }

    public String toString() {
        return this.name + "[" + this.state + "]";
    }

    public void addPropertyChangeListener(PropertyChangeListener l) {
        this.changes.addPropertyChangeListener(l);
    }

    public void removePropertyChangeListener(PropertyChangeListener l) {
        this.changes.removePropertyChangeListener(l);
    }
}

