/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.xml.test;

import java.io.InputStream;
import java.net.URL;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import junit.framework.TestCase;
import org.exoplatform.container.xml.Component;
import org.exoplatform.container.xml.ComponentLifecyclePlugin;
import org.exoplatform.container.xml.ComponentPlugin;
import org.exoplatform.container.xml.Configuration;
import org.exoplatform.container.xml.ContainerLifecyclePlugin;
import org.exoplatform.container.xml.ExternalComponentPlugins;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.container.xml.ManageableComponents;
import org.exoplatform.container.xml.ObjectParameter;
import org.exoplatform.container.xml.PropertiesParam;
import org.exoplatform.container.xml.ValueParam;
import org.exoplatform.container.xml.ValuesParam;
import org.exoplatform.xml.object.XMLObject;
import org.exoplatform.xml.test.Person;
import org.jibx.runtime.BindingDirectory;
import org.jibx.runtime.IBindingFactory;
import org.jibx.runtime.IUnmarshallingContext;

public class TestConfigurationXML
extends TestCase {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void testTrimValue() throws Exception {
        InputStream is = Thread.currentThread().getContextClassLoader().getResourceAsStream("test-trim-value.xml");
        TestConfigurationXML.assertNotNull((Object)is);
        try {
            IBindingFactory bfact = BindingDirectory.getFactory(XMLObject.class);
            IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
            Configuration conf = (Configuration)uctx.unmarshalDocument(is, null);
            TestConfigurationXML.assertNotNull((Object)conf);
            Iterator it = conf.getContainerLifecyclePluginIterator();
            TestConfigurationXML.assertNotNull((Object)it);
            TestConfigurationXML.assertTrue((boolean)it.hasNext());
            ContainerLifecyclePlugin conlp = (ContainerLifecyclePlugin)it.next();
            TestConfigurationXML.assertEquals((String)"container-lifecycle-plugin-type", (String)conlp.getType());
            TestConfigurationXML.assertNotNull((Object)conlp.getInitParams());
            TestConfigurationXML.assertEquals((String)"container-lifecycle-plugin-value-param-value", (String)conlp.getInitParams().getValueParam("container-lifecycle-plugin-value-param-name").getValue());
            it = conf.getComponentLifecyclePluginIterator();
            TestConfigurationXML.assertNotNull((Object)it);
            TestConfigurationXML.assertTrue((boolean)it.hasNext());
            ComponentLifecyclePlugin comlp = (ComponentLifecyclePlugin)it.next();
            TestConfigurationXML.assertEquals((String)"component-lifecycle-plugin", (String)comlp.getType());
            ManageableComponents mc = comlp.getManageableComponents();
            TestConfigurationXML.assertNotNull((Object)mc);
            TestConfigurationXML.assertEquals((String)"manageable-components-component-type", (String)((String)mc.getComponentsType().get(0)));
            ValuesParam valuesParam = comlp.getInitParams().getValuesParam("component-lifecycle-plugin-values-param-name");
            TestConfigurationXML.assertNotNull((Object)valuesParam);
            TestConfigurationXML.assertNotNull((Object)valuesParam.getValues());
            TestConfigurationXML.assertTrue((boolean)valuesParam.getValues().contains("component-lifecycle-plugin-values-param-value1"));
            TestConfigurationXML.assertTrue((boolean)valuesParam.getValues().contains("component-lifecycle-plugin-values-param-value2"));
            Component c = conf.getComponent("component-key1");
            TestConfigurationXML.assertNotNull((Object)c);
            TestConfigurationXML.assertEquals((String)"component-type1", (String)c.getType());
            PropertiesParam propertiesParam = c.getInitParams().getPropertiesParam("component-key1-properties-param-name");
            TestConfigurationXML.assertNotNull((Object)propertiesParam);
            TestConfigurationXML.assertEquals((String)"component-key1-properties-param-prop-value", (String)propertiesParam.getProperty("component-key1-properties-param-prop-name"));
            c = conf.getComponent("component-type2");
            TestConfigurationXML.assertNotNull((Object)c);
            ObjectParameter objectParameter = c.getInitParams().getObjectParam("component-key2-object-param-name");
            TestConfigurationXML.assertNotNull((Object)objectParameter);
            MyObject o = (MyObject)objectParameter.getObject();
            TestConfigurationXML.assertNotNull((Object)o);
            TestConfigurationXML.assertEquals((String)"string-value", (String)o.field1);
            TestConfigurationXML.assertEquals((int)1, (int)o.field2);
            TestConfigurationXML.assertEquals((long)1L, (long)o.field3);
            TestConfigurationXML.assertEquals((Object)1.0, (Object)o.field4);
            TestConfigurationXML.assertEquals((boolean)true, (boolean)o.field5);
            TestConfigurationXML.assertNotNull((Object)o.field6);
            TestConfigurationXML.assertEquals((Object)"entry-value", o.field6.get("entry-name"));
            TestConfigurationXML.assertNotNull((Object)o.field7);
            TestConfigurationXML.assertTrue((boolean)o.field7.contains("string-value"));
            TestConfigurationXML.assertNotNull((Object)o.field8);
            TestConfigurationXML.assertEquals((int)1, (int)o.field8[0]);
            List list = c.getComponentPlugins();
            TestConfigurationXML.assertNotNull((Object)list);
            TestConfigurationXML.assertFalse((boolean)list.isEmpty());
            ComponentPlugin cp = (ComponentPlugin)list.get(0);
            TestConfigurationXML.assertEquals((String)"component-plugins-name", (String)cp.getName());
            TestConfigurationXML.assertEquals((String)"set-method-name", (String)cp.getSetMethod());
            TestConfigurationXML.assertEquals((String)"component-plugins-type", (String)cp.getType());
            TestConfigurationXML.assertEquals((int)1, (int)cp.getPriority());
            it = conf.getExternalComponentPluginsIterator();
            TestConfigurationXML.assertNotNull((Object)it);
            TestConfigurationXML.assertTrue((boolean)it.hasNext());
            ExternalComponentPlugins ecps = (ExternalComponentPlugins)it.next();
            TestConfigurationXML.assertEquals((String)"target-component-name", (String)ecps.getTargetComponent());
            list = ecps.getComponentPlugins();
            TestConfigurationXML.assertNotNull((Object)list);
            TestConfigurationXML.assertFalse((boolean)list.isEmpty());
            cp = (ComponentPlugin)list.get(0);
            TestConfigurationXML.assertEquals((String)"component-plugins-name", (String)cp.getName());
            TestConfigurationXML.assertEquals((String)"set-method-name", (String)cp.getSetMethod());
            TestConfigurationXML.assertEquals((String)"component-plugins-type", (String)cp.getType());
            TestConfigurationXML.assertEquals((int)1, (int)cp.getPriority());
            list = conf.getImports();
            TestConfigurationXML.assertNotNull((Object)list);
            TestConfigurationXML.assertFalse((boolean)list.isEmpty());
            TestConfigurationXML.assertEquals((Object)"import-value", list.get(0));
            list = conf.getRemoveConfiguration();
            TestConfigurationXML.assertNotNull((Object)list);
            TestConfigurationXML.assertFalse((boolean)list.isEmpty());
            TestConfigurationXML.assertEquals((Object)"remove-configuration-value", list.get(0));
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    public void testSystemPropertyResolving() throws Exception {
        System.setProperty("c_value", "c_external_value");
        System.setProperty("d_value", "d_external_value");
        System.setProperty("false_value", "false");
        System.setProperty("true_value", "true");
        System.setProperty("FALSE_value", "FALSE");
        System.setProperty("TRUE_value", "TRUE");
        System.setProperty("integer_value", "5");
        System.setProperty("long_value", "41");
        System.setProperty("double_value", "172.5");
        IBindingFactory bfact = BindingDirectory.getFactory(XMLObject.class);
        IUnmarshallingContext uctx = bfact.createUnmarshallingContext();
        URL url = TestConfigurationXML.class.getResource("../../../../test-resolved-property.xml");
        Configuration conf = (Configuration)uctx.unmarshalDocument(url.openStream(), null);
        TestConfigurationXML.assertNotNull((Object)conf);
        Component component = conf.getComponent("component");
        TestConfigurationXML.assertNotNull((Object)component);
        this.assertValueParam("a_value", component, "a");
        this.assertValueParam("${b_value}", component, "b");
        this.assertValueParam("c_external_value", component, "c");
        this.assertValueParam("_d_external_value_", component, "d");
        this.assertPropertyParam("a_value", component, "e", "e_a");
        this.assertPropertyParam("${b_value}", component, "e", "e_b");
        this.assertPropertyParam("c_external_value", component, "e", "e_c");
        this.assertPropertyParam("_d_external_value_", component, "e", "e_d");
        ObjectParameter o = component.getInitParams().getObjectParam("f");
        TestConfigurationXML.assertNotNull((Object)o);
        Person p = (Person)o.getObject();
        TestConfigurationXML.assertNotNull((Object)p);
        TestConfigurationXML.assertEquals((String)"a_value", (String)p.address_a);
        TestConfigurationXML.assertEquals((String)"${b_value}", (String)p.address_b);
        TestConfigurationXML.assertEquals((String)"c_external_value", (String)p.address_c);
        TestConfigurationXML.assertEquals((String)"_d_external_value_", (String)p.address_d);
        TestConfigurationXML.assertEquals((boolean)true, (boolean)p.male_a);
        TestConfigurationXML.assertEquals((boolean)false, (boolean)p.male_b);
        TestConfigurationXML.assertEquals((boolean)true, (boolean)p.male_c);
        TestConfigurationXML.assertEquals((boolean)false, (boolean)p.male_d);
        TestConfigurationXML.assertEquals((boolean)true, (boolean)p.male_e);
        TestConfigurationXML.assertEquals((boolean)false, (boolean)p.male_f);
        TestConfigurationXML.assertEquals((int)4, (int)p.age_a);
        TestConfigurationXML.assertEquals((int)5, (int)p.age_b);
        TestConfigurationXML.assertEquals((long)40L, (long)p.weight_a);
        TestConfigurationXML.assertEquals((long)41L, (long)p.weight_b);
        TestConfigurationXML.assertEquals((Object)172.4, (Object)p.size_a);
        TestConfigurationXML.assertEquals((Object)172.5, (Object)p.size_b);
    }

    private void assertPropertyParam(String expectedValue, Component component, String paramName, String propertyName) {
        InitParams initParams = component.getInitParams();
        TestConfigurationXML.assertNotNull((Object)initParams);
        PropertiesParam propertiesParam = initParams.getPropertiesParam(paramName);
        TestConfigurationXML.assertNotNull((Object)paramName);
        TestConfigurationXML.assertEquals((String)expectedValue, (String)propertiesParam.getProperty(propertyName));
    }

    private void assertValueParam(String expectedValue, Component component, String paramName) {
        InitParams initParams = component.getInitParams();
        TestConfigurationXML.assertNotNull((Object)initParams);
        ValueParam valueParam = initParams.getValueParam(paramName);
        TestConfigurationXML.assertNotNull((Object)paramName);
        TestConfigurationXML.assertEquals((String)expectedValue, (String)valueParam.getValue());
    }

    public static class MyObject {
        public String field1;
        public int field2;
        public long field3;
        public double field4;
        public boolean field5;
        public Map field6;
        public Collection field7;
        public int[] field8;
    }
}

