/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.commons.utils.io;

import java.io.File;
import java.io.FileFilter;
import java.util.HashSet;

public class FileFilterByExtension implements FileFilter
{
   private boolean acceptDir_;

   private HashSet knownExt_;

   public FileFilterByExtension(String[] ext, boolean acceptDir)
   {
      acceptDir_ = acceptDir;
      knownExt_ = new HashSet();
      for (int i = 0; i < ext.length; i++)
      {
         knownExt_.add(ext[i].trim().toLowerCase());
      }
   }

   public boolean accept(File file)
   {
      if (file.isDirectory())
      {
         if (acceptDir_)
            return true;
         return false;
      }
      String temp = file.getName();
      int idx = temp.lastIndexOf(".");
      if (idx > 0)
         temp = temp.substring(idx + 1, temp.length());
      else
         return false;
      return knownExt_.contains(temp.toLowerCase());
   }
}
