/**
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package org.exoplatform.services.scheduler;

import org.exoplatform.commons.utils.ClassLoading;
import org.exoplatform.commons.utils.ExoProperties;
import org.exoplatform.container.component.BaseComponentPlugin;
import org.exoplatform.container.xml.InitParams;
import org.quartz.JobDataMap;

/**
 * Created by The eXo Platform SAS Author : Hoa Pham
 * hoapham@exoplatform.com,phamvuxuanhoa@yahoo.com Oct 10, 2005
 */
public class CronJob extends BaseComponentPlugin
{
   private String expression_;

   private JobInfo jinfo_;

   public CronJob(InitParams params) throws Exception
   {
      ExoProperties props = params.getPropertiesParam("cronjob.info").getProperties();

      String jobName = props.getProperty("jobName");
      String jobGroup = props.getProperty("groupName");
      String jobClass = props.getProperty("job");
      String shouldRecover = props.getProperty("shouldRecover");
      Class<?> clazz = ClassLoading.forName(jobClass, this);
      jinfo_ = new JobInfo(jobName, jobGroup, clazz, shouldRecover);

      expression_ = props.getProperty("expression");
   }

   public JobInfo getJobInfo()
   {
      return jinfo_;
   }

   public String getExpression()
   {
      return expression_;
   }
   
   public JobDataMap getJobDataMap()
   {
      return null;
   }

}
