/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.kudos.service;

import io.meeds.kudos.model.AccountSettings;
import io.meeds.kudos.model.GlobalSettings;
import io.meeds.kudos.model.Kudos;
import io.meeds.kudos.model.KudosEntityType;
import io.meeds.kudos.model.KudosPeriod;
import io.meeds.kudos.model.KudosPeriodType;
import io.meeds.kudos.model.exception.KudosAlreadyLinkedException;
import io.meeds.kudos.service.utils.Utils;
import io.meeds.kudos.storage.KudosStorage;
import java.time.LocalDateTime;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.listener.ListenerService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.activity.model.ExoSocialActivity;
import org.exoplatform.social.core.manager.ActivityManager;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.cache.annotation.CacheEvict;
import org.springframework.cache.annotation.Cacheable;
import org.springframework.stereotype.Service;

@Service
public class KudosService {
    @Autowired
    private ActivityManager activityManager;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private ListenerService listenerService;
    @Autowired
    private KudosStorage kudosStorage;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private SettingService settingService;
    @Value(value="${kudos.defaultAccessPermission:}")
    private String defaultAccessPermission;
    @Value(value="${kudos.defaultKudosPerPeriod:3}")
    private long defaultKudosPerPeriod;

    @Cacheable(value={"Kudos.globalSettings"})
    public GlobalSettings getGlobalSettings() {
        SettingValue globalSettingsValue = this.settingService.get(Utils.KUDOS_CONTEXT, Utils.KUDOS_SCOPE, "ADDONS_KUDOS_SETTINGS");
        if (globalSettingsValue == null || StringUtils.isBlank((CharSequence)globalSettingsValue.getValue().toString())) {
            return new GlobalSettings(this.defaultKudosPerPeriod, KudosPeriodType.DEFAULT, 0L, 0L);
        }
        return GlobalSettings.parseStringToObject(globalSettingsValue.getValue().toString());
    }

    @CacheEvict(cacheNames={"Kudos.globalSettings"}, allEntries=true)
    public void saveGlobalSettings(GlobalSettings settings) {
        this.settingService.set(Utils.KUDOS_CONTEXT, Utils.KUDOS_SCOPE, "ADDONS_KUDOS_SETTINGS", SettingValue.create((String)settings.toStringToPersist()));
    }

    public AccountSettings getAccountSettings(String username) {
        AccountSettings accountSettings = new AccountSettings();
        org.exoplatform.social.core.identity.model.Identity senderIdentity = (org.exoplatform.social.core.identity.model.Identity)this.checkStatusAndGetReceiver("organization", username);
        long senderIdentityId = Long.parseLong(senderIdentity.getId());
        long sentKudos = this.kudosStorage.countKudosByPeriodAndSender(this.getCurrentKudosPeriod(), senderIdentityId);
        accountSettings.setRemainingKudos(this.getAllowedKudosPerPeriod() - sentKudos);
        return accountSettings;
    }

    public Kudos createKudos(Kudos kudos, String currentUser) throws IllegalAccessException {
        org.exoplatform.social.core.identity.model.Identity senderIdentity;
        long senderIdentityId;
        KudosPeriod currentPeriod;
        if (!StringUtils.equals((CharSequence)currentUser, (CharSequence)kudos.getSenderId())) {
            throw new IllegalAccessException("User with id '" + currentUser + "' is not authorized to send kudos on behalf of " + kudos.getSenderId());
        }
        if (StringUtils.equals((CharSequence)currentUser, (CharSequence)kudos.getReceiverId())) {
            throw new IllegalAccessException("User with username '" + currentUser + "' is not authorized to send kudos to himseld!");
        }
        if (StringUtils.isNotBlank((CharSequence)kudos.getSpacePrettyName())) {
            Space space = Utils.getSpace(kudos.getSpacePrettyName());
            if (space == null) {
                throw new ObjectNotFoundException("Space not found");
            }
            if (!this.canSendKudosInSpace(kudos, space, currentUser)) {
                throw new IllegalAccessException("User cannot redact on space");
            }
            if (!this.isActivityComment(kudos) && "space".equals(kudos.getReceiverType()) && !this.isReceiverSpaceTargetAudience(kudos, space)) {
                throw new IllegalAccessException("Target space isn't the space receiving the kudos");
            }
        } else if (!this.isActivityComment(kudos) && "space".equals(kudos.getReceiverType())) {
            throw new IllegalAccessException("Target space isn't the space receiving the kudos");
        }
        if (this.kudosStorage.countKudosByPeriodAndSender(currentPeriod = this.getCurrentKudosPeriod(), senderIdentityId = Long.parseLong((senderIdentity = (org.exoplatform.social.core.identity.model.Identity)this.checkStatusAndGetReceiver("organization", currentUser)).getId())) >= this.getAllowedKudosPerPeriod()) {
            throw new IllegalAccessException("User having username'" + currentUser + "' is not authorized to send more kudos");
        }
        kudos.setSenderId(senderIdentity.getRemoteId());
        kudos.setSenderIdentityId(senderIdentity.getId());
        Object receiverObject = this.checkStatusAndGetReceiver(kudos.getReceiverType(), kudos.getReceiverId());
        if (kudos.getReceiverIdentityId() == null) {
            org.exoplatform.social.core.identity.model.Identity identity;
            org.exoplatform.social.core.identity.model.Identity identity2;
            if (receiverObject instanceof org.exoplatform.social.core.identity.model.Identity && (identity2 = (org.exoplatform.social.core.identity.model.Identity)receiverObject).isUser()) {
                kudos.setReceiverId(identity2.getRemoteId());
                kudos.setReceiverType("user");
                kudos.setReceiverIdentityId(identity2.getId());
            } else if (receiverObject instanceof org.exoplatform.social.core.identity.model.Identity && (identity = (org.exoplatform.social.core.identity.model.Identity)receiverObject).isSpace()) {
                Space space = Utils.getSpace(identity.getRemoteId());
                kudos.setReceiverIdentityId(space.getId());
                kudos.setReceiverId(space.getPrettyName());
                kudos.setReceiverType("space");
            } else if (receiverObject instanceof Space) {
                Space space = (Space)receiverObject;
                if (this.canSendKudosInSpace(kudos, space, currentUser)) {
                    kudos.setReceiverId(space.getPrettyName());
                    kudos.setReceiverIdentityId(space.getId());
                    kudos.setReceiverType("space");
                } else {
                    throw new IllegalAccessException("User cannot redact on space");
                }
            }
        }
        kudos.setTimeInSeconds(Utils.timeToSeconds(LocalDateTime.now()));
        Kudos createdKudos = this.kudosStorage.createKudos(kudos);
        createdKudos.setSpacePrettyName(kudos.getSpacePrettyName());
        this.listenerService.broadcast("exo.kudos.sent", (Object)this, (Object)createdKudos);
        return this.kudosStorage.getKudoById(createdKudos.getTechnicalId());
    }

    public boolean canSendKudosInSpace(Kudos kudos, Space space, String username) {
        return this.spaceService.canRedactOnSpace(space, username) || this.isActivityComment(kudos) && this.spaceService.canViewSpace(space, username);
    }

    public void deleteKudosById(long kudosId, String username) throws IllegalAccessException, ObjectNotFoundException, KudosAlreadyLinkedException {
        if (username == null) {
            throw new IllegalArgumentException("Username is mandatory");
        }
        if (kudosId <= 0L) {
            throw new IllegalArgumentException("Kudos id has to be positive integer");
        }
        Kudos kudos = this.kudosStorage.getKudoById(kudosId);
        if (kudos == null) {
            throw new ObjectNotFoundException("Kudos with id " + kudosId + " wasn't found");
        }
        if (!kudos.getSenderId().equals(username)) {
            throw new IllegalAccessException("user " + username + " is not allowed to delete kudos with id " + kudosId);
        }
        long kudosOfActivityCount = this.kudosStorage.countKudosOfActivity(kudos.getActivityId());
        if (kudosOfActivityCount > 1L) {
            throw new KudosAlreadyLinkedException("kudos with id " + kudosId + "already linked to kudos entities");
        }
        this.deleteKudosById(kudosId);
        this.listenerService.broadcast("kudos.cancel.activity", (Object)this, (Object)kudos);
    }

    public void deleteKudosById(long kudosId) throws ObjectNotFoundException {
        if (kudosId <= 0L) {
            throw new IllegalArgumentException("Kudos id has to be positive integer");
        }
        Kudos kudos = this.kudosStorage.getKudoById(kudosId);
        if (kudos == null) {
            throw new ObjectNotFoundException("Kudos with id " + kudosId + " wasn't found");
        }
        this.kudosStorage.deleteKudosById(kudosId);
    }

    public boolean isActivityComment(Kudos kudos) {
        return KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.ACTIVITY || KudosEntityType.valueOf(kudos.getEntityType()) == KudosEntityType.COMMENT;
    }

    public void updateKudosGeneratedActivityId(long kudosId, long activityId) {
        this.kudosStorage.saveKudosActivityId(kudosId, activityId);
        Kudos kudos = this.kudosStorage.getKudoById(kudosId);
        this.listenerService.broadcast("exo.kudos.activity", (Object)this, (Object)kudos);
    }

    public Kudos getKudosByActivityId(Long activityId, Identity currentUser) throws IllegalAccessException {
        Kudos kudos = this.kudosStorage.getKudosByActivityId(activityId);
        if (kudos == null) {
            return null;
        }
        if (StringUtils.equals((CharSequence)kudos.getSenderId(), (CharSequence)currentUser.getUserId()) || StringUtils.equals((CharSequence)kudos.getReceiverId(), (CharSequence)currentUser.getUserId())) {
            return kudos;
        }
        ExoSocialActivity activity = this.activityManager.getActivity(String.valueOf(activityId));
        if (activity == null) {
            return null;
        }
        if (!this.activityManager.isActivityViewable(activity, currentUser)) {
            throw new IllegalAccessException("User " + currentUser.getUserId() + " isn't allowed to access kudos of activity with id " + activityId);
        }
        return kudos;
    }

    public Kudos getKudosByActivityId(Long activityId) {
        return this.kudosStorage.getKudosByActivityId(activityId);
    }

    public Kudos updateKudos(Kudos kudos) {
        return this.kudosStorage.updateKudos(kudos);
    }

    public List<Kudos> getKudosByPeriod(long startDateInSeconds, long endDateInSeconds, int limit) {
        KudosPeriod period = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.getKudosByPeriod(period, limit);
    }

    public List<Kudos> getKudosByPeriod(long dateInSeconds, KudosPeriodType periodType, int limit) {
        if (periodType == null) {
            throw new IllegalArgumentException("'periodType' is mandatory");
        }
        KudosPeriod period = periodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
        return this.kudosStorage.getKudosByPeriod(period, limit);
    }

    public List<Kudos> getKudosByPeriodOfDate(long dateInSeconds, int limit) {
        KudosPeriod period = this.getKudosPeriodOfTime(dateInSeconds);
        return this.kudosStorage.getKudosByPeriod(period, limit);
    }

    public List<Kudos> getKudosByEntity(String entityType, String entityId, int limit) {
        return this.kudosStorage.getKudosByEntity(entityType, entityId, limit);
    }

    public long countKudosByEntity(String entityType, String entityId) {
        return this.kudosStorage.countKudosByEntity(entityType, entityId);
    }

    public long countKudosByEntityAndSender(String entityType, String entityId, String senderIdentityId) {
        return this.kudosStorage.countKudosByEntityAndSender(entityType, entityId, senderIdentityId);
    }

    public long countKudosByPeriodAndSender(long senderIdentityId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.countKudosByPeriodAndSender(kudosPeriod, senderIdentityId);
    }

    public List<Kudos> getKudosByPeriodAndSender(long senderIdentityId, long startDateInSeconds, long endDateInSeconds, int limit) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.getKudosByPeriodAndSender(kudosPeriod, senderIdentityId, limit);
    }

    public long countKudosByPeriodAndReceiver(long identityId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(identityId);
        if (identity == null) {
            return 0L;
        }
        return this.kudosStorage.countKudosByPeriodAndReceiver(kudosPeriod, identity.getProviderId(), identity.getRemoteId());
    }

    public Map<Long, Long> countKudosByPeriodAndReceivers(List<Long> identitiesId, long startDateInSeconds, long endDateInSeconds) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        return this.kudosStorage.countKudosByPeriodAndReceivers(kudosPeriod, identitiesId);
    }

    public List<Kudos> getKudosByPeriodAndReceiver(long identityId, long startDateInSeconds, long endDateInSeconds, int limit) {
        KudosPeriod kudosPeriod = new KudosPeriod(startDateInSeconds, endDateInSeconds);
        org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getIdentity(identityId);
        if (identity == null) {
            return Collections.emptyList();
        }
        return this.kudosStorage.getKudosByPeriodAndReceiver(kudosPeriod, identity.getProviderId(), identity.getRemoteId(), limit);
    }

    public List<Kudos> getKudosListOfActivity(String activityId, Identity currentUser) throws IllegalAccessException {
        if (currentUser == null) {
            throw new IllegalArgumentException("User is mandatory");
        }
        ExoSocialActivity activity = this.activityManager.getActivity(activityId);
        if (activity == null) {
            return Collections.emptyList();
        }
        if (!this.activityManager.isActivityViewable(activity, currentUser)) {
            throw new IllegalAccessException("User " + currentUser.getUserId() + " isn't allowed to access kudos of activity with id " + activityId);
        }
        return this.getKudosListOfActivity(activityId);
    }

    public List<Kudos> getKudosListOfActivity(String activityId) {
        return this.kudosStorage.getKudosListOfActivity(Utils.getActivityId(activityId));
    }

    public KudosPeriodType getDefaultKudosPeriodType() {
        return Utils.getPeriodType(this.getGlobalSettings());
    }

    public KudosPeriod getCurrentKudosPeriod() {
        return Utils.getCurrentPeriod(this.getGlobalSettings());
    }

    public KudosPeriod getKudosPeriodOfTime(long dateInSeconds) {
        return Utils.getPeriodOfTime(this.getGlobalSettings(), Utils.timeFromSeconds(dateInSeconds));
    }

    public KudosPeriod getKudosPeriodOfTime(KudosPeriodType periodType, long dateInSeconds) {
        return periodType.getPeriodOfTime(Utils.timeFromSeconds(dateInSeconds));
    }

    private boolean isReceiverSpaceTargetAudience(Kudos kudos, Space space) {
        String receiverId = kudos.getReceiverId();
        Space targetSpaceAudience = Utils.getSpace(receiverId);
        return targetSpaceAudience != null && StringUtils.equals((CharSequence)space.getId(), (CharSequence)targetSpaceAudience.getId());
    }

    private Object checkStatusAndGetReceiver(String type, String id) {
        if ("user".equals(type) || "organization".equals(type)) {
            org.exoplatform.social.core.identity.model.Identity identity = this.identityManager.getOrCreateIdentity("organization", id);
            if (identity == null || !identity.isEnable() || identity.isDeleted()) {
                throw new IllegalStateException("User with identity id '" + id + "' doesn't have a valid and enabled social identity");
            }
            return identity;
        }
        Space space = Utils.getSpace(id);
        if (space == null) {
            throw new IllegalStateException("Space with id '" + id + "' wasn't found, thus it can't receive/send kudos");
        }
        return space;
    }

    private long getAllowedKudosPerPeriod() {
        GlobalSettings storedGlobalSettings = this.getGlobalSettings();
        return storedGlobalSettings == null ? 0L : storedGlobalSettings.getKudosPerPeriod();
    }
}

