/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.dao.PortletInstanceCategoryDAO;
import io.meeds.layout.entity.PortletInstanceCategoryEntity;
import io.meeds.layout.model.PortletInstanceCategory;
import io.meeds.layout.util.EntityMapper;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PortletInstanceCategoryStorage {
    @Autowired
    private PortletInstanceCategoryDAO portletInstanceCategoryDAO;

    public List<PortletInstanceCategory> getPortletInstanceCategories() {
        List entities = this.portletInstanceCategoryDAO.findAll();
        return entities.stream().map(EntityMapper::fromEntity).toList();
    }

    public PortletInstanceCategory getPortletInstanceCategory(long id) {
        return this.portletInstanceCategoryDAO.findById(id).map(EntityMapper::fromEntity).orElse(null);
    }

    public PortletInstanceCategory createPortletInstanceCategory(PortletInstanceCategory portletInstanceCategory) {
        return this.save(portletInstanceCategory);
    }

    public PortletInstanceCategory updatePortletInstanceCategory(PortletInstanceCategory portletInstanceCategory) throws ObjectNotFoundException {
        if (!this.portletInstanceCategoryDAO.existsById(portletInstanceCategory.getId())) {
            throw new ObjectNotFoundException("Entity doesn't exist");
        }
        return this.save(portletInstanceCategory);
    }

    public void deletePortletInstanceCategory(long id) throws ObjectNotFoundException {
        if (!this.portletInstanceCategoryDAO.existsById(id)) {
            throw new ObjectNotFoundException(String.format("Entity with id %s doesn't exist", id));
        }
        this.portletInstanceCategoryDAO.deleteById(id);
    }

    private PortletInstanceCategory save(PortletInstanceCategory portletInstanceCategory) {
        PortletInstanceCategoryEntity entity = EntityMapper.toEntity(portletInstanceCategory);
        entity = (PortletInstanceCategoryEntity)this.portletInstanceCategoryDAO.save(entity);
        return EntityMapper.fromEntity(entity);
    }
}

