/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.CoeditionObjectDraft;
import io.meeds.layout.model.CoeditionObjectKey;
import io.meeds.layout.model.CoeditionObjectLock;
import io.meeds.social.util.JsonUtils;
import jakarta.annotation.PostConstruct;
import java.io.Serializable;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Service;

@Service
public class CoeditingService {
    private static final Scope COEDITION_SCOPE = Scope.APPLICATION.id("Coedition");
    @Autowired
    private SettingService settingService;
    @Autowired
    private CacheService cacheService;
    @Value(value="${meeds.coediting.lockPeriod:20}")
    private long lockPeriod;
    private ExoCache<CoeditionObjectKey, CoeditionObjectLock> lockCache;

    @PostConstruct
    public void init() {
        this.lockCache = this.cacheService.getCacheInstance("portal.coediting");
        if (this.lockCache != null) {
            this.lockCache.setLiveTime(this.lockPeriod);
        }
    }

    public List<String> getLockHolders(CoeditionObjectKey key) {
        CoeditionObjectLock lock = (CoeditionObjectLock)this.lockCache.get((Serializable)key);
        return lock == null ? Collections.emptyList() : lock.getUsers().entrySet().stream().map(e -> {
            if (this.isLockTimeValid((Long)e.getValue())) {
                return (String)e.getKey();
            }
            return null;
        }).filter(Objects::nonNull).toList();
    }

    public CoeditionObjectDraft setLock(String username, CoeditionObjectKey key, String revision) {
        CoeditionObjectLock lock = (CoeditionObjectLock)this.lockCache.get((Serializable)key);
        if (lock == null) {
            lock = new CoeditionObjectLock();
        } else {
            this.cleanOutdatedLocks(lock);
        }
        lock.getUsers().put(username, System.currentTimeMillis());
        this.lockCache.put((Serializable)key, (Object)lock);
        CoeditionObjectDraft draft = this.getRevision(username, key);
        if (draft != null && StringUtils.equals((CharSequence)draft.getRevision(), (CharSequence)revision)) {
            return null;
        }
        this.setRevision(username, key, revision);
        return draft;
    }

    public CoeditionObjectDraft getRevision(String username, CoeditionObjectKey key) {
        SettingValue value = this.settingService.get(Context.USER.id(username), COEDITION_SCOPE, String.valueOf(key.hashCode()));
        return value == null || value.getValue() == null ? null : (CoeditionObjectDraft)JsonUtils.fromJsonString((String)value.getValue().toString(), CoeditionObjectDraft.class);
    }

    public void setRevision(String username, CoeditionObjectKey key, String versionReference) {
        this.settingService.set(Context.USER.id(username), COEDITION_SCOPE, String.valueOf(key.hashCode()), SettingValue.create((String)JsonUtils.toJsonString((Object)new CoeditionObjectDraft(versionReference, System.currentTimeMillis()))));
    }

    public void removeRevision(String username, CoeditionObjectKey key) {
        this.settingService.remove(Context.USER.id(username), COEDITION_SCOPE, String.valueOf(key.hashCode()));
    }

    private boolean isLockTimeValid(long lockTime) {
        return lockTime + this.lockPeriod * 1000L > System.currentTimeMillis();
    }

    private void cleanOutdatedLocks(CoeditionObjectLock lock) {
        Iterator<Map.Entry<String, Long>> userLockIterator = lock.getUsers().entrySet().iterator();
        while (userLockIterator.hasNext()) {
            Map.Entry<String, Long> e = userLockIterator.next();
            if (this.isLockTimeValid(e.getValue())) continue;
            userLockIterator.remove();
        }
    }

    @Generated
    public void setLockCache(ExoCache<CoeditionObjectKey, CoeditionObjectLock> lockCache) {
        this.lockCache = lockCache;
    }
}

