/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest.util;

import io.meeds.layout.rest.model.LayoutModel;
import io.meeds.layout.rest.model.SiteRestEntity;
import io.meeds.layout.service.PageLayoutService;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.rest.model.UserNodeRestEntity;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.entity.SiteEntity;

public class RestEntityBuilder {
    private RestEntityBuilder() {
    }

    public static SiteRestEntity toSiteEntity(PageLayoutService pageLayoutService, PortalConfig site, HttpServletRequest request, Locale locale) throws Exception {
        SiteEntity siteEntity = EntityBuilder.buildSiteEntity((PortalConfig)site, (HttpServletRequest)request, (boolean)true, null, (boolean)true, (boolean)false, (boolean)false, (Locale)locale);
        SiteRestEntity siteRestEntity = new SiteRestEntity(siteEntity);
        List siteNavigations = siteEntity.getSiteNavigations();
        RestEntityBuilder.computeCompatibilityWithEditor(pageLayoutService, siteRestEntity, siteNavigations);
        return siteRestEntity;
    }

    private static void computeCompatibilityWithEditor(PageLayoutService pageLayoutService, SiteRestEntity siteRestEntity, List<UserNodeRestEntity> siteNavigations) {
        if (CollectionUtils.isNotEmpty(siteNavigations)) {
            siteNavigations.forEach(n -> {
                PageKey pageKey = n.getPageKey();
                if (n.isCanEditPage()) {
                    Page page = pageLayoutService.getPageLayout(pageKey);
                    siteRestEntity.getPagesCompatibility().put(pageKey.format(), page != null && RestEntityBuilder.isCompatibleWithEditor(page));
                } else if (pageKey != null) {
                    siteRestEntity.getPagesCompatibility().put(pageKey.format(), false);
                }
                RestEntityBuilder.computeCompatibilityWithEditor(pageLayoutService, siteRestEntity, n.getChildren());
            });
        }
    }

    public static LayoutModel toLayoutModel(Page page, LayoutService layoutService, String expand) {
        LayoutModel layoutModel = new LayoutModel((ModelObject)page);
        if (StringUtils.contains((CharSequence)expand, (CharSequence)"contentId")) {
            HashMap<String, String> contentIds = new HashMap<String, String>();
            RestEntityBuilder.computeApplicationContentId(layoutService, page.getChildren(), contentIds);
            RestEntityBuilder.applyApplicationContentId(layoutModel.getChildren(), contentIds);
        }
        return layoutModel;
    }

    private static void computeApplicationContentId(LayoutService layoutService, ArrayList<ModelObject> children, Map<String, String> contentIds) {
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        for (ModelObject layoutModel : children) {
            Application application;
            String storageId;
            if (layoutModel instanceof Container) {
                Container container = (Container)layoutModel;
                RestEntityBuilder.computeApplicationContentId(layoutService, container.getChildren(), contentIds);
                continue;
            }
            if (!(layoutModel instanceof Application) || !StringUtils.isNotBlank((CharSequence)(storageId = (application = (Application)layoutModel).getStorageId()))) continue;
            String contentId = layoutService.getId(application.getState());
            contentIds.put(storageId, contentId);
        }
    }

    private static void applyApplicationContentId(List<LayoutModel> children, Map<String, String> contentIds) {
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        for (LayoutModel layoutModel : children) {
            if (contentIds.containsKey(layoutModel.getStorageId())) {
                layoutModel.setContentId(contentIds.get(layoutModel.getStorageId()));
                continue;
            }
            if (!CollectionUtils.isNotEmpty(layoutModel.getChildren())) continue;
            RestEntityBuilder.applyApplicationContentId(layoutModel.getChildren(), contentIds);
        }
    }

    public static Page fromLayoutModel(LayoutModel layoutModel) {
        return layoutModel.toPage();
    }

    private static boolean isCompatibleWithEditor(Page page) {
        Container appContainer;
        Container vAppContainer;
        Container appContainer2;
        ArrayList children = page.getChildren();
        if (CollectionUtils.isEmpty((Collection)children)) {
            return true;
        }
        if (children.size() != 1) {
            return false;
        }
        ModelObject parentContainer = (ModelObject)children.get(0);
        if (parentContainer != null && parentContainer instanceof Container && StringUtils.contains((CharSequence)(appContainer2 = (Container)parentContainer).getTemplate(), (CharSequence)"UIPageLayout.gtmpl")) {
            return RestEntityBuilder.isChildrenOfTypeSection(appContainer2);
        }
        if (parentContainer == null || !(parentContainer instanceof Container) || !StringUtils.contains((CharSequence)(vAppContainer = (Container)parentContainer).getCssClass(), (CharSequence)"VuetifyApp")) {
            return false;
        }
        if (CollectionUtils.isEmpty((Collection)vAppContainer.getChildren())) {
            return true;
        }
        parentContainer = (ModelObject)vAppContainer.getChildren().get(0);
        if (parentContainer == null || !(parentContainer instanceof Container) || !StringUtils.contains((CharSequence)(appContainer = (Container)parentContainer).getCssClass(), (CharSequence)"v-application")) {
            return false;
        }
        return RestEntityBuilder.isChildrenOfTypeSection(appContainer);
    }

    private static boolean isChildrenOfTypeSection(Container appContainer) {
        return appContainer.getChildren().stream().allMatch(c -> {
            Container container;
            return c instanceof Container && (StringUtils.equals((CharSequence)"GridContainer", (CharSequence)(container = (Container)c).getTemplate()) || StringUtils.equals((CharSequence)"FlexContainer", (CharSequence)container.getTemplate()));
        });
    }
}

