/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest.util;

import io.meeds.layout.rest.model.LayoutModel;
import jakarta.servlet.http.HttpServletRequest;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.social.rest.api.EntityBuilder;
import org.exoplatform.social.rest.entity.SiteEntity;

public class RestEntityBuilder {
    private RestEntityBuilder() {
    }

    public static SiteEntity toSiteEntity(PortalConfig site, HttpServletRequest request, Locale locale) throws Exception {
        return EntityBuilder.buildSiteEntity((PortalConfig)site, (HttpServletRequest)request, (boolean)true, null, (boolean)true, (boolean)false, (boolean)false, (Locale)locale);
    }

    public static LayoutModel toLayoutModel(Page page, LayoutService layoutService, String expand) {
        LayoutModel layoutModel = new LayoutModel((ModelObject)page);
        if (StringUtils.contains((CharSequence)expand, (CharSequence)"contentId")) {
            HashMap<String, String> contentIds = new HashMap<String, String>();
            RestEntityBuilder.computeApplicationContentId(layoutService, page.getChildren(), contentIds);
            RestEntityBuilder.applyApplicationContentId(layoutModel.getChildren(), contentIds);
        }
        return layoutModel;
    }

    private static void computeApplicationContentId(LayoutService layoutService, ArrayList<ModelObject> children, Map<String, String> contentIds) {
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        for (ModelObject layoutModel : children) {
            Application application;
            String portletId;
            if (layoutModel instanceof Container) {
                Container container = (Container)layoutModel;
                RestEntityBuilder.computeApplicationContentId(layoutService, container.getChildren(), contentIds);
                continue;
            }
            if (!(layoutModel instanceof Application) || !StringUtils.isNotBlank((CharSequence)(portletId = (application = (Application)layoutModel).getStorageId() == null ? application.getId() : application.getStorageId()))) continue;
            String contentId = layoutService.getId(application.getState());
            contentIds.put(portletId, contentId);
        }
    }

    private static void applyApplicationContentId(List<LayoutModel> children, Map<String, String> contentIds) {
        if (CollectionUtils.isEmpty(children)) {
            return;
        }
        for (LayoutModel layoutModel : children) {
            if (contentIds.containsKey(layoutModel.getStorageId())) {
                layoutModel.setContentId(contentIds.get(layoutModel.getStorageId()));
                continue;
            }
            if (!CollectionUtils.isNotEmpty(layoutModel.getChildren())) continue;
            RestEntityBuilder.applyApplicationContentId(layoutModel.getChildren(), contentIds);
        }
    }

    public static Page fromLayoutModel(LayoutModel layoutModel) {
        return layoutModel.toPage();
    }
}

