/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.dao.PortletInstanceDAO;
import io.meeds.layout.entity.PortletInstanceEntity;
import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.storage.PortletInstanceStorage;
import io.meeds.layout.storage.PortletStorage;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PortletInstanceStorage.class})
@ExtendWith(value={MockitoExtension.class})
public class PortletInstanceStorageTest {
    private static final String CONTENT_ID = "test/portlet";
    @MockBean
    private PortletInstanceDAO portletInstanceDAO;
    @MockBean
    private PortletStorage portletStorage;
    @Mock
    private PortletInstanceEntity portletInstanceEntity;
    @Mock
    private PortletInstance portletInstance;
    @Autowired
    private PortletInstanceStorage portletInstanceStorage;
    String username = "test";

    @Test
    public void getPortletInstances() {
        Mockito.when((Object)this.portletInstanceDAO.findAll()).thenReturn(Collections.singletonList(this.portletInstanceEntity));
        Mockito.when((Object)this.portletInstanceEntity.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.portletInstanceEntity.getContentId()).thenReturn((Object)CONTENT_ID);
        Mockito.when((Object)this.portletInstanceEntity.isSystem()).thenReturn((Object)true);
        Mockito.when((Object)this.portletInstanceEntity.getPermissions()).thenReturn(Collections.singletonList("permissions"));
        List portletInstances = this.portletInstanceStorage.getPortletInstances();
        Assertions.assertNotNull((Object)portletInstances);
        Assertions.assertEquals((int)1, (int)portletInstances.size());
        Assertions.assertEquals((Long)this.portletInstanceEntity.getId(), (long)((PortletInstance)portletInstances.get(0)).getId());
        Assertions.assertEquals((Object)this.portletInstanceEntity.getContentId(), (Object)((PortletInstance)portletInstances.get(0)).getContentId());
        Assertions.assertEquals((Object)this.portletInstanceEntity.getPermissions(), (Object)((PortletInstance)portletInstances.get(0)).getPermissions());
        Assertions.assertEquals((Object)this.portletInstanceEntity.isSystem(), (Object)((PortletInstance)portletInstances.get(0)).isSystem());
    }

    @Test
    public void getPortletInstance() {
        Mockito.when((Object)this.portletInstanceDAO.findById((Object)2L)).thenReturn(Optional.of(this.portletInstanceEntity));
        Mockito.when((Object)this.portletInstanceEntity.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.portletInstanceEntity.getContentId()).thenReturn((Object)CONTENT_ID);
        PortletInstance retrievedPortletInstance = this.portletInstanceStorage.getPortletInstance(2L);
        Assertions.assertEquals((Long)this.portletInstanceEntity.getId(), (long)retrievedPortletInstance.getId());
        Assertions.assertEquals((Object)this.portletInstanceEntity.getContentId(), (Object)retrievedPortletInstance.getContentId());
    }

    @Test
    public void createPortletInstance() {
        Mockito.when((Object)this.portletInstance.getContentId()).thenReturn((Object)CONTENT_ID);
        Mockito.when((Object)((PortletInstanceEntity)this.portletInstanceDAO.save((Object)((PortletInstanceEntity)ArgumentMatchers.any(PortletInstanceEntity.class))))).thenAnswer(invocation -> {
            PortletInstanceEntity entity = (PortletInstanceEntity)invocation.getArgument(0);
            entity.setId(Long.valueOf(2L));
            return entity;
        });
        PortletInstance createdPortletInstance = this.portletInstanceStorage.createPortletInstance(this.portletInstance);
        Assertions.assertNotNull((Object)createdPortletInstance);
        Assertions.assertEquals((long)2L, (long)createdPortletInstance.getId());
        Assertions.assertEquals((Object)this.portletInstance.getContentId(), (Object)createdPortletInstance.getContentId());
    }

    @Test
    public void updatePortletInstance() throws ObjectNotFoundException {
        Mockito.when((Object)this.portletInstance.getContentId()).thenReturn((Object)CONTENT_ID);
        Mockito.when((Object)((PortletInstanceEntity)this.portletInstanceDAO.save((Object)((PortletInstanceEntity)ArgumentMatchers.any(PortletInstanceEntity.class))))).thenAnswer(invocation -> invocation.getArgument(0));
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.portletInstanceStorage.updatePortletInstance(this.portletInstance));
        Mockito.when((Object)this.portletInstance.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.portletInstance.getContentId()).thenReturn((Object)CONTENT_ID);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.portletInstanceStorage.updatePortletInstance(this.portletInstance));
        Mockito.when((Object)this.portletInstanceDAO.existsById((Object)this.portletInstance.getId())).thenReturn((Object)true);
        PortletInstance updatedPortletInstance = this.portletInstanceStorage.updatePortletInstance(this.portletInstance);
        Assertions.assertNotNull((Object)updatedPortletInstance);
        Assertions.assertEquals((long)this.portletInstance.getId(), (long)updatedPortletInstance.getId());
        Assertions.assertEquals((Object)this.portletInstance.getContentId(), (Object)updatedPortletInstance.getContentId());
    }

    @Test
    public void deletePortletInstance() throws ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.portletInstanceStorage.deletePortletInstance(2L));
        Mockito.when((Object)this.portletInstanceDAO.existsById((Object)2L)).thenReturn((Object)true);
        this.portletInstanceStorage.deletePortletInstance(2L);
        ((PortletInstanceDAO)Mockito.verify((Object)this.portletInstanceDAO, (VerificationMode)Mockito.times((int)1))).deleteById((Object)2L);
    }
}

