/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.rest;

import io.meeds.layout.model.PortletInstanceCategory;
import io.meeds.layout.rest.PortletInstanceCategoryRest;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.util.JsonUtils;
import io.meeds.spring.web.security.PortalAuthenticationManager;
import io.meeds.spring.web.security.WebSecurityConfiguration;
import jakarta.servlet.Filter;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureWebMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.http.MediaType;
import org.springframework.security.core.GrantedAuthority;
import org.springframework.security.core.authority.SimpleGrantedAuthority;
import org.springframework.security.test.web.servlet.request.SecurityMockMvcRequestPostProcessors;
import org.springframework.security.web.SecurityFilterChain;
import org.springframework.test.context.ContextConfiguration;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.RequestBuilder;
import org.springframework.test.web.servlet.ResultActions;
import org.springframework.test.web.servlet.request.MockMvcRequestBuilders;
import org.springframework.test.web.servlet.request.RequestPostProcessor;
import org.springframework.test.web.servlet.result.MockMvcResultMatchers;
import org.springframework.test.web.servlet.setup.DefaultMockMvcBuilder;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;
import org.springframework.web.context.WebApplicationContext;

@SpringBootTest(classes={PortletInstanceCategoryRest.class, PortalAuthenticationManager.class})
@ContextConfiguration(classes={WebSecurityConfiguration.class})
@AutoConfigureWebMvc
@AutoConfigureMockMvc(addFilters=false)
@ExtendWith(value={MockitoExtension.class})
public class PortletInstanceCategoryRestTest {
    private static final String REST_PATH = "/portlet/instance/categories";
    private static final String SIMPLE_USER = "simple";
    private static final String TEST_PASSWORD = "testPassword";
    @MockBean
    private PortletInstanceService portletInstanceService;
    @Autowired
    private SecurityFilterChain filterChain;
    @Autowired
    private WebApplicationContext context;
    private MockMvc mockMvc;

    @BeforeEach
    void setup() {
        this.mockMvc = ((DefaultMockMvcBuilder)MockMvcBuilders.webAppContextSetup((WebApplicationContext)this.context).addFilters(this.filterChain.getFilters().toArray(new Filter[0]))).build();
    }

    @Test
    void getPortletInstanceCategorysAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.portletInstanceService});
    }

    @Test
    void getPortletInstanceCategorysWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService)).getPortletInstanceCategories((String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), ArgumentMatchers.anyBoolean());
    }

    @Test
    void getPortletInstanceCategoryAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/portlet/instance/categories/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.portletInstanceService});
    }

    @Test
    void getPortletInstanceCategoryWithUser() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.get((String)"/portlet/instance/categories/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService)).getPortletInstanceCategory(ArgumentMatchers.eq((long)1L), (String)ArgumentMatchers.any(), (Locale)ArgumentMatchers.any(), ArgumentMatchers.eq((boolean)true));
    }

    @Test
    void createPortletInstanceCategoryAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)new PortletInstanceCategory())).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.portletInstanceService});
    }

    @Test
    void createPortletInstanceCategoryWithUser() throws Exception {
        PortletInstanceCategory portletInstanceCategory = new PortletInstanceCategory();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)portletInstanceCategory)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService)).createPortletInstanceCategory(portletInstanceCategory, SIMPLE_USER);
    }

    @Test
    void createPortletInstanceCategoryWithUserForbidden() throws Exception {
        PortletInstanceCategory portletInstanceCategory = new PortletInstanceCategory();
        Mockito.when((Object)this.portletInstanceService.createPortletInstanceCategory(portletInstanceCategory, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.post((String)REST_PATH, (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)portletInstanceCategory)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updatePortletInstanceCategoryAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/portlet/instance/categories/1", (Object[])new Object[0]).content(JsonUtils.toJsonString((Object)new PortletInstanceCategory())).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.portletInstanceService});
    }

    @Test
    void updatePortletInstanceCategoryWithUser() throws Exception {
        PortletInstanceCategory portletInstanceCategory = new PortletInstanceCategory();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/portlet/instance/categories/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)portletInstanceCategory)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        portletInstanceCategory.setId(1L);
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService)).updatePortletInstanceCategory(portletInstanceCategory, SIMPLE_USER);
    }

    @Test
    void updatePortletInstanceCategoryWithUserForbidden() throws Exception {
        PortletInstanceCategory portletInstanceCategory = new PortletInstanceCategory();
        portletInstanceCategory.setId(1L);
        Mockito.when((Object)this.portletInstanceService.updatePortletInstanceCategory(portletInstanceCategory, SIMPLE_USER)).thenThrow(IllegalAccessException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/portlet/instance/categories/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)portletInstanceCategory)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void updatePortletInstanceCategoryWithUserNotFound() throws Exception {
        PortletInstanceCategory portletInstanceCategory = new PortletInstanceCategory();
        portletInstanceCategory.setId(1L);
        Mockito.when((Object)this.portletInstanceService.updatePortletInstanceCategory(portletInstanceCategory, SIMPLE_USER)).thenThrow(ObjectNotFoundException.class);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.put((String)"/portlet/instance/categories/1", (Object[])new Object[0]).with(this.testSimpleUser()).content(JsonUtils.toJsonString((Object)portletInstanceCategory)).contentType(MediaType.APPLICATION_JSON));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    @Test
    void deletePortletInstanceCategoryAnonymously() throws Exception {
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/portlet/instance/categories/1", (Object[])new Object[0]));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
        Mockito.verifyNoInteractions((Object[])new Object[]{this.portletInstanceService});
    }

    @Test
    void deletePortletInstanceCategoryWithUser() throws Exception {
        PortletInstanceCategory portletInstanceCategory = new PortletInstanceCategory();
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/portlet/instance/categories/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isOk());
        portletInstanceCategory.setId(1L);
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService)).deletePortletInstanceCategory(1L, SIMPLE_USER);
    }

    @Test
    void deletePortletInstanceCategoryWithUserForbidden() throws Exception {
        PortletInstanceCategory portletInstanceCategory = new PortletInstanceCategory();
        portletInstanceCategory.setId(1L);
        ((PortletInstanceService)Mockito.doThrow(IllegalAccessException.class).when((Object)this.portletInstanceService)).deletePortletInstanceCategory(1L, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/portlet/instance/categories/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isForbidden());
    }

    @Test
    void deletePortletInstanceCategoryWithUserNotFound() throws Exception {
        PortletInstanceCategory portletInstanceCategory = new PortletInstanceCategory();
        portletInstanceCategory.setId(1L);
        ((PortletInstanceService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.portletInstanceService)).deletePortletInstanceCategory(1L, SIMPLE_USER);
        ResultActions response = this.mockMvc.perform((RequestBuilder)MockMvcRequestBuilders.delete((String)"/portlet/instance/categories/1", (Object[])new Object[0]).with(this.testSimpleUser()));
        response.andExpect(MockMvcResultMatchers.status().isNotFound());
    }

    private RequestPostProcessor testSimpleUser() {
        return SecurityMockMvcRequestPostProcessors.user((String)SIMPLE_USER).password(TEST_PASSWORD).authorities(new GrantedAuthority[]{new SimpleGrantedAuthority("users")});
    }
}

