/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.dao.SectionTemplateDAO;
import io.meeds.layout.entity.SectionTemplateEntity;
import io.meeds.layout.model.SectionTemplate;
import io.meeds.layout.util.EntityMapper;
import java.util.List;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class SectionTemplateStorage {
    @Autowired
    private SectionTemplateDAO sectionTemplateDAO;

    public List<SectionTemplate> getSectionTemplates() {
        List entities = this.sectionTemplateDAO.findAll();
        return entities.stream().map(EntityMapper::fromEntity).toList();
    }

    public SectionTemplate getSectionTemplate(long id) {
        return this.sectionTemplateDAO.findById(id).map(EntityMapper::fromEntity).orElse(null);
    }

    public SectionTemplate createSectionTemplate(SectionTemplate sectionTemplate) {
        return this.save(sectionTemplate);
    }

    public SectionTemplate updateSectionTemplate(SectionTemplate sectionTemplate) throws ObjectNotFoundException {
        if (!this.sectionTemplateDAO.existsById(sectionTemplate.getId())) {
            throw new ObjectNotFoundException("Entity doesn't exist");
        }
        return this.save(sectionTemplate);
    }

    public void deleteSectionTemplate(long id) throws ObjectNotFoundException {
        if (!this.sectionTemplateDAO.existsById(id)) {
            throw new ObjectNotFoundException(String.format("Entity with id %s doesn't exist", id));
        }
        this.sectionTemplateDAO.deleteById(id);
    }

    private SectionTemplate save(SectionTemplate sectionTemplate) {
        SectionTemplateEntity entity = EntityMapper.toEntity(sectionTemplate);
        entity = (SectionTemplateEntity)this.sectionTemplateDAO.save(entity);
        return EntityMapper.fromEntity(entity);
    }
}

