/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin;

import io.meeds.layout.plugin.PageTemplateAttachmentPlugin;
import io.meeds.layout.service.LayoutAclService;
import org.exoplatform.services.security.Identity;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PageTemplateAttachmentPlugin.class})
@ExtendWith(value={MockitoExtension.class})
public class PageTemplateAttachmentPluginTest {
    @Mock
    private Identity userIdentity;
    @MockBean
    private LayoutAclService layoutAclService;
    @Autowired
    private PageTemplateAttachmentPlugin attachmentPlugin;

    @Test
    public void getObjectType() {
        Assertions.assertEquals((Object)"pageTemplate", (Object)this.attachmentPlugin.getObjectType());
        Assertions.assertEquals((Object)"pageTemplate", (Object)this.attachmentPlugin.getObjectType());
    }

    @Test
    public void hasEditPermission() {
        Assert.assertFalse((boolean)this.attachmentPlugin.hasEditPermission(null, null));
        Assert.assertFalse((boolean)this.attachmentPlugin.hasEditPermission(this.userIdentity, null));
        Mockito.when((Object)this.userIdentity.getUserId()).thenReturn((Object)"test");
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.userIdentity.getUserId())).thenReturn((Object)true);
        Assert.assertTrue((boolean)this.attachmentPlugin.hasEditPermission(this.userIdentity, null));
    }

    @Test
    public void hasAccessPermission() {
        Assert.assertTrue((boolean)this.attachmentPlugin.hasAccessPermission(null, null));
    }

    @Test
    public void getAudienceId() {
        Assertions.assertEquals((long)0L, (long)this.attachmentPlugin.getAudienceId(null));
    }

    @Test
    public void getSpaceId() {
        Assertions.assertEquals((long)0L, (long)this.attachmentPlugin.getSpaceId(""));
    }
}

