/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.PermissionUpdateModel;
import io.meeds.layout.model.SiteCreateModel;
import io.meeds.layout.model.SiteUpdateModel;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.SiteLayoutService;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={SiteLayoutService.class})
@ExtendWith(value={MockitoExtension.class})
public class SiteLayoutServiceTest {
    private static final String TEST_USER = "testuser";
    private static final SiteKey SITE_KEY = SiteKey.portal((String)"test");
    @MockBean
    private LayoutService layoutService;
    @MockBean
    private UserPortalConfigService portalConfigService;
    @MockBean
    private LayoutAclService aclService;
    @Autowired
    private SiteLayoutService siteLayoutService;
    @Mock
    private PortalConfig portalConfig;

    @Test
    public void getSiteById() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.siteLayoutService.getSite(2L, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(2L)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.portalConfig.getType()).thenReturn((Object)SITE_KEY.getTypeName());
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)SITE_KEY.getName());
        Assertions.assertThrows(IllegalAccessException.class, () -> this.siteLayoutService.getSite(2L, TEST_USER));
        Mockito.when((Object)this.aclService.canViewSite(SITE_KEY, TEST_USER)).thenReturn((Object)true);
        Assertions.assertEquals((Object)this.portalConfig, (Object)this.siteLayoutService.getSite(2L, TEST_USER));
    }

    @Test
    public void getSiteByKey() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.siteLayoutService.getSite(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.siteLayoutService.getSite(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.aclService.canViewSite(SITE_KEY, TEST_USER)).thenReturn((Object)true);
        Assertions.assertEquals((Object)this.portalConfig, (Object)this.siteLayoutService.getSite(SITE_KEY, TEST_USER));
    }

    @Test
    public void createSite() {
        SiteCreateModel createModel = (SiteCreateModel)Mockito.mock(SiteCreateModel.class);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.siteLayoutService.createSite(createModel, TEST_USER));
        Mockito.when((Object)this.aclService.canAddSite(TEST_USER)).thenReturn((Object)true);
        String siteTemplate = "siteTemplate";
        Mockito.when((Object)createModel.getSiteTemplate()).thenReturn((Object)siteTemplate);
        Mockito.when((Object)createModel.getPortalConfig()).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.portalConfig.getName()).thenReturn((Object)SITE_KEY.getName());
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY.getName())).thenReturn((Object)this.portalConfig);
        Assertions.assertThrows(ObjectAlreadyExistsException.class, () -> this.siteLayoutService.createSite(createModel, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY.getName())).thenReturn(null);
        String description = "description";
        String uploadId = "56632";
        Mockito.when((Object)this.portalConfig.getLabel()).thenReturn((Object)SITE_KEY.getTypeName());
        Mockito.when((Object)this.portalConfig.getDescription()).thenReturn((Object)description);
        Mockito.when((Object)this.portalConfig.isDisplayed()).thenReturn((Object)true);
        Mockito.when((Object)this.portalConfig.getDisplayOrder()).thenReturn((Object)22);
        Mockito.when((Object)this.portalConfig.getBannerUploadId()).thenReturn((Object)uploadId);
        Mockito.when((Object)this.aclService.getAdministratorsGroup()).thenReturn((Object)"administrators");
        ((UserPortalConfigService)Mockito.doAnswer(invocation -> {
            Mockito.when((Object)this.layoutService.getPortalConfig((String)invocation.getArgument(1, String.class))).thenReturn((Object)this.portalConfig);
            return null;
        }).when((Object)this.portalConfigService)).createUserPortalConfig(PortalConfig.PORTAL_TYPE, SITE_KEY.getName(), siteTemplate);
        this.siteLayoutService.createSite(createModel, TEST_USER);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save(this.portalConfig);
        ((PortalConfig)Mockito.verify((Object)this.portalConfig)).setDescription(description);
        ((PortalConfig)Mockito.verify((Object)this.portalConfig)).setDisplayed(true);
        ((PortalConfig)Mockito.verify((Object)this.portalConfig)).setDisplayOrder(22);
        ((PortalConfig)Mockito.verify((Object)this.portalConfig)).setBannerUploadId(uploadId);
        ((PortalConfig)Mockito.verify((Object)this.portalConfig)).setEditPermission("*:administrators");
        ((PortalConfig)Mockito.verify((Object)this.portalConfig)).setAccessPermissions((String[])ArgumentMatchers.argThat(p -> p[0].equals("*:administrators")));
        Mockito.when((Object)this.portalConfig.isDisplayed()).thenReturn((Object)false);
        Mockito.when((Object)this.portalConfig.getBannerUploadId()).thenReturn(null);
        Mockito.when((Object)this.portalConfig.getAccessPermissions()).thenReturn((Object)new String[]{"accessPermission"});
        Mockito.when((Object)this.portalConfig.getEditPermission()).thenReturn((Object)"editPermission");
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY.getName())).thenReturn(null);
        ((UserPortalConfigService)Mockito.doAnswer(invocation -> {
            Mockito.when((Object)this.layoutService.getPortalConfig((String)invocation.getArgument(1, String.class))).thenReturn((Object)this.portalConfig);
            return null;
        }).when((Object)this.portalConfigService)).createUserPortalConfig(PortalConfig.PORTAL_TYPE, SITE_KEY.getName(), siteTemplate);
        this.siteLayoutService.createSite(createModel, TEST_USER);
        ((PortalConfig)Mockito.verify((Object)this.portalConfig)).setAccessPermissions((String[])ArgumentMatchers.argThat(p -> p[0].equals("accessPermission")));
        ((PortalConfig)Mockito.verify((Object)this.portalConfig)).setEditPermission("editPermission");
        ((PortalConfig)Mockito.verify((Object)this.portalConfig)).setDisplayed(false);
        ((PortalConfig)Mockito.verify((Object)this.portalConfig)).setDisplayOrder(0);
    }

    @Test
    public void updateSite() {
        SiteUpdateModel updateModel = (SiteUpdateModel)Mockito.mock(SiteUpdateModel.class);
        Mockito.when((Object)updateModel.getSiteType()).thenReturn((Object)SITE_KEY.getTypeName());
        Mockito.when((Object)updateModel.getSiteName()).thenReturn((Object)SITE_KEY.getName());
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.siteLayoutService.updateSite(updateModel, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.siteLayoutService.updateSite(updateModel, TEST_USER));
        Mockito.when((Object)this.aclService.canEditSite(SITE_KEY, TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)updateModel.getSiteLabel()).thenReturn((Object)"label");
        Mockito.when((Object)updateModel.getSiteDescription()).thenReturn((Object)"description");
        Mockito.when((Object)updateModel.isDisplayed()).thenReturn((Object)true);
        Mockito.when((Object)updateModel.getDisplayOrder()).thenReturn((Object)22);
        Mockito.when((Object)updateModel.getBannerUploadId()).thenReturn((Object)"56632");
        this.siteLayoutService.updateSite(updateModel, TEST_USER);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save(this.portalConfig);
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.never())).removeSiteBanner((String)ArgumentMatchers.any());
        ((PortalConfig)Mockito.verify((Object)this.portalConfig)).setDisplayOrder(22);
        Mockito.when((Object)updateModel.isDisplayed()).thenReturn((Object)false);
        Mockito.when((Object)updateModel.isBannerRemoved()).thenReturn((Object)true);
        Mockito.when((Object)this.portalConfig.getBannerFileId()).thenReturn((Object)336L);
        this.siteLayoutService.updateSite(updateModel, TEST_USER);
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.times((int)2))).save(this.portalConfig);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).removeSiteBanner(SITE_KEY.getName());
        ((PortalConfig)Mockito.verify((Object)this.portalConfig)).setDisplayOrder(0);
    }

    @Test
    public void deleteSite() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.siteLayoutService.deleteSite(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.siteLayoutService.deleteSite(SITE_KEY, TEST_USER));
        Mockito.when((Object)this.aclService.canEditSite(SITE_KEY, TEST_USER)).thenReturn((Object)true);
        this.siteLayoutService.deleteSite(SITE_KEY, TEST_USER);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).remove(this.portalConfig);
    }

    @Test
    public void updateSitePermissions() {
        List<String> accessPermissions = Arrays.asList("access", "permissions");
        String editPermission = "edit permission";
        PermissionUpdateModel permissionModel = new PermissionUpdateModel(SITE_KEY.getTypeName(), SITE_KEY.getName(), accessPermissions, editPermission);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.siteLayoutService.updateSitePermissions(permissionModel, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.siteLayoutService.updateSitePermissions(permissionModel, TEST_USER));
        Mockito.when((Object)this.aclService.canEditSite(SITE_KEY, TEST_USER)).thenReturn((Object)true);
        this.siteLayoutService.updateSitePermissions(permissionModel, TEST_USER);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save(this.portalConfig);
        this.portalConfig.setAccessPermissions((String[])ArgumentMatchers.argThat(p -> Arrays.asList("access", "permissions").equals(Arrays.asList(p))));
        this.portalConfig.setEditPermission((String)ArgumentMatchers.argThat(editPermission::equals));
    }
}

