/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.NodeLabel;
import io.meeds.layout.model.PermissionUpdateModel;
import io.meeds.layout.model.SiteCreateModel;
import io.meeds.layout.model.SiteUpdateModel;
import io.meeds.layout.service.LayoutAclService;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import java.util.stream.Collectors;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfig;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.SiteType;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.user.UserPortal;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.services.resources.LocaleContextInfo;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class SiteLayoutService {
    @Autowired
    private LayoutService layoutService;
    @Autowired
    private LocaleConfigService localeConfigService;
    @Autowired
    private UserPortalConfigService portalConfigService;
    @Autowired
    private LayoutAclService aclService;
    private Map<String, String> supportedLanguages;
    private Locale defaultConfiguredLocale;

    public PortalConfig getSite(long siteId, String username) throws ObjectNotFoundException, IllegalAccessException {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteId);
        if (portalConfig == null) {
            throw new ObjectNotFoundException(String.format("Site with id %s doesn't exists", siteId));
        }
        if (!this.aclService.canViewSite(new SiteKey(portalConfig.getType(), portalConfig.getName()), username)) {
            throw new IllegalAccessException();
        }
        return portalConfig;
    }

    public PortalConfig getSite(SiteKey siteKey, String username) throws ObjectNotFoundException, IllegalAccessException {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            throw new ObjectNotFoundException(String.format("Site with key %s doesn't exists", siteKey));
        }
        if (!this.aclService.canViewSite(siteKey, username)) {
            throw new IllegalAccessException();
        }
        return portalConfig;
    }

    public PortalConfig createSite(SiteCreateModel createModel, String username) throws IllegalAccessException, ObjectAlreadyExistsException {
        String[] stringArray;
        if (!this.aclService.canAddSite(username)) {
            throw new IllegalAccessException();
        }
        if (this.layoutService.getPortalConfig(createModel.getPortalConfig().getName()) != null) {
            throw new ObjectAlreadyExistsException((Object)String.format("Site with name %s already exists", createModel.getPortalConfig().getName()));
        }
        PortalConfig portalConfigToCreate = createModel.getPortalConfig();
        String siteTemplate = createModel.getSiteTemplate();
        this.portalConfigService.createUserPortalConfig(PortalConfig.PORTAL_TYPE, portalConfigToCreate.getName(), siteTemplate);
        if (portalConfigToCreate.getAccessPermissions() == null) {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = this.getAdministratorsPermission();
        } else {
            stringArray = portalConfigToCreate.getAccessPermissions();
        }
        String[] accessPermissions = stringArray;
        String editPermission = portalConfigToCreate.getEditPermission() == null ? this.getAdministratorsPermission() : portalConfigToCreate.getEditPermission();
        PortalConfig createdPortalConfig = this.layoutService.getPortalConfig(portalConfigToCreate.getName());
        createdPortalConfig.setDescription(portalConfigToCreate.getDescription());
        createdPortalConfig.setLabel(portalConfigToCreate.getLabel());
        createdPortalConfig.setDisplayed(portalConfigToCreate.isDisplayed());
        createdPortalConfig.setDisplayOrder(portalConfigToCreate.isDisplayed() ? portalConfigToCreate.getDisplayOrder() : 0);
        createdPortalConfig.setAccessPermissions(accessPermissions);
        createdPortalConfig.setEditPermission(editPermission);
        if (StringUtils.isNotBlank((CharSequence)portalConfigToCreate.getBannerUploadId())) {
            createdPortalConfig.setBannerUploadId(portalConfigToCreate.getBannerUploadId());
        }
        this.layoutService.save(createdPortalConfig);
        return createdPortalConfig;
    }

    public void updateSite(SiteUpdateModel updateModel, String username) throws IllegalAccessException, ObjectNotFoundException {
        SiteKey siteKey = new SiteKey(updateModel.getSiteType(), updateModel.getSiteName());
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            throw new ObjectNotFoundException(String.format("Site with key %s doesn't exist", siteKey));
        }
        if (!this.aclService.canEditSite(siteKey, username)) {
            throw new IllegalAccessException(String.format("Site with key %s can't be edited by user %s", siteKey, username));
        }
        portalConfig.setDescription(updateModel.getSiteDescription());
        portalConfig.setLabel(updateModel.getSiteLabel());
        portalConfig.setDisplayed(updateModel.isDisplayed());
        portalConfig.setDisplayOrder(updateModel.isDisplayed() ? updateModel.getDisplayOrder() : 0);
        if (updateModel.isBannerRemoved() && portalConfig.getBannerFileId() != 0L) {
            this.layoutService.removeSiteBanner(siteKey.getName());
            portalConfig.setBannerFileId(0L);
        } else if (StringUtils.isNotBlank((CharSequence)updateModel.getBannerUploadId())) {
            portalConfig.setBannerUploadId(updateModel.getBannerUploadId());
        }
        this.layoutService.save(portalConfig);
    }

    public void deleteSite(SiteKey siteKey, String username) throws IllegalAccessException, ObjectNotFoundException {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            throw new ObjectNotFoundException(String.format("Site with key %s doesn't exist", siteKey));
        }
        if (!this.aclService.canEditSite(siteKey, username)) {
            throw new IllegalAccessException(String.format("Site with key %s can't be deleted by user %s", siteKey, username));
        }
        this.layoutService.remove(portalConfig);
    }

    public void updateSitePermissions(PermissionUpdateModel permissionUpdateModel, String username) throws IllegalAccessException, ObjectNotFoundException {
        SiteKey siteKey = new SiteKey(permissionUpdateModel.getSiteType(), permissionUpdateModel.getSiteName());
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteKey);
        if (portalConfig == null) {
            throw new ObjectNotFoundException(String.format("Site %s doesn't exist", siteKey));
        }
        if (!this.aclService.canEditSite(siteKey, username)) {
            throw new IllegalAccessException(String.format("Site permissions with key %s can't be edited by user %s", siteKey, username));
        }
        if (!StringUtils.isBlank((CharSequence)permissionUpdateModel.getEditPermission())) {
            portalConfig.setEditPermission(permissionUpdateModel.getEditPermission());
        }
        if (permissionUpdateModel.getAccessPermissions() != null) {
            portalConfig.setAccessPermissions(permissionUpdateModel.getAccessPermissions().toArray(new String[0]));
        }
        this.layoutService.save(portalConfig);
    }

    public NodeLabel getSiteLabels(Long siteId, String username) throws ObjectNotFoundException, IllegalAccessException {
        return this.getSiteLabel(siteId, username, true);
    }

    public NodeLabel getSiteDescriptions(Long siteId, String username) throws ObjectNotFoundException, IllegalAccessException {
        return this.getSiteLabel(siteId, username, false);
    }

    private NodeLabel getSiteLabel(long siteId, String username, boolean isLabel) throws ObjectNotFoundException, IllegalAccessException {
        PortalConfig portalConfig = this.layoutService.getPortalConfig(siteId);
        if (portalConfig == null) {
            throw new ObjectNotFoundException(String.format("Site with id %s doesn't exists", siteId));
        }
        if (!this.aclService.canViewSite(new SiteKey(portalConfig.getType(), portalConfig.getName()), username)) {
            throw new IllegalAccessException();
        }
        Locale defaultLocale = this.getDefaultLocale();
        NodeLabel nodeLabel = new NodeLabel();
        nodeLabel.setDefaultLanguage(defaultLocale.getLanguage());
        nodeLabel.setSupportedLanguages(this.getSupportedLanguages(defaultLocale));
        Map<String, String> labels = this.getLabels(portalConfig, defaultLocale, username, isLabel);
        nodeLabel.setLabels(labels);
        return nodeLabel;
    }

    private Map<String, String> getLabels(PortalConfig portalConfig, Locale defaultLocale, String username, boolean isLabel) {
        SiteKey siteKey = new SiteKey(SiteType.valueOf((String)portalConfig.getType().toUpperCase()), portalConfig.getName());
        UserPortalConfig userPortalConfig = this.portalConfigService.getUserPortalConfig(siteKey.getName(), username);
        UserPortal userPortal = userPortalConfig.getUserPortal();
        HashMap<String, String> labels = new HashMap<String, String>();
        this.localeConfigService.getLocalConfigs().stream().map(LocaleConfig::getLocale).forEach(locale -> {
            String translatedLabel = isLabel ? userPortal.getPortalLabel(siteKey, locale) : userPortal.getPortalDescription(siteKey, locale);
            labels.put(LocaleContextInfo.getLocaleAsString((Locale)locale), translatedLabel);
        });
        if (!labels.containsKey(defaultLocale.getLanguage()) && !labels.isEmpty()) {
            labels.put(defaultLocale.getLanguage(), (String)labels.values().iterator().next());
        }
        return labels;
    }

    private Map<String, String> getSupportedLanguages(Locale defaultLocale) {
        if (this.supportedLanguages == null || !this.defaultConfiguredLocale.equals(defaultLocale)) {
            this.supportedLanguages = CollectionUtils.isEmpty((Collection)this.localeConfigService.getLocalConfigs()) ? Collections.singletonMap(defaultLocale.toLanguageTag(), defaultLocale.getDisplayName()) : this.localeConfigService.getLocalConfigs().stream().filter(localeConfig -> !StringUtils.equals((CharSequence)localeConfig.getLocale().toLanguageTag(), (CharSequence)"ma")).map(LocaleConfig::getLocale).collect(Collectors.toMap(Locale::toLanguageTag, Locale::getDisplayName));
            this.defaultConfiguredLocale = defaultLocale;
        }
        return this.supportedLanguages;
    }

    private Locale getDefaultLocale() {
        return this.localeConfigService.getDefaultLocaleConfig() == null ? Locale.ENGLISH : this.localeConfigService.getDefaultLocaleConfig().getLocale();
    }

    private String getAdministratorsPermission() {
        return "*:" + this.aclService.getAdministratorsGroup();
    }
}

