/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.attachment;

import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.plugin.attachment.PortletInstanceAttachmentPlugin;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PortletInstanceService;
import java.util.Collections;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PortletInstanceAttachmentPlugin.class})
@ExtendWith(value={MockitoExtension.class})
public class PortletInstanceAttachmentPluginTest {
    @Mock
    private Identity userIdentity;
    @MockBean
    private AttachmentService attachmentService;
    @MockBean
    private LayoutAclService layoutAclService;
    @MockBean
    private PortletInstanceService portletInstanceService;
    @Autowired
    private PortletInstanceAttachmentPlugin attachmentPlugin;

    @Test
    public void getObjectType() {
        Assertions.assertEquals((Object)"portletInstance", (Object)this.attachmentPlugin.getObjectType());
        Assertions.assertEquals((Object)"portletInstance", (Object)this.attachmentPlugin.getObjectType());
    }

    @Test
    public void hasEditPermission() {
        Assertions.assertFalse((boolean)this.attachmentPlugin.hasEditPermission(null, null));
        Assertions.assertFalse((boolean)this.attachmentPlugin.hasEditPermission(this.userIdentity, null));
        Mockito.when((Object)this.userIdentity.getUserId()).thenReturn((Object)"test");
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.userIdentity.getUserId())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.attachmentPlugin.hasEditPermission(this.userIdentity, null));
    }

    @Test
    public void hasAccessPermission() {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.attachmentPlugin.hasAccessPermission(null, "1"));
        PortletInstance portletInstance = (PortletInstance)Mockito.mock(PortletInstance.class);
        Mockito.when((Object)this.portletInstanceService.getPortletInstance(1L)).thenReturn((Object)portletInstance);
        Assertions.assertTrue((boolean)this.attachmentPlugin.hasAccessPermission(null, "1"));
        String username = "user";
        Mockito.when((Object)this.userIdentity.getUserId()).thenReturn((Object)username);
        Assertions.assertTrue((boolean)this.attachmentPlugin.hasAccessPermission(this.userIdentity, "1"));
        String permissionExpression = "A Permission Expression";
        Mockito.when((Object)portletInstance.getPermissions()).thenReturn(Collections.singletonList(permissionExpression));
        Assertions.assertFalse((boolean)this.attachmentPlugin.hasAccessPermission(this.userIdentity, "1"));
        Mockito.when((Object)this.layoutAclService.hasPermission(username, permissionExpression)).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.attachmentPlugin.hasAccessPermission(this.userIdentity, "1"));
    }

    @Test
    public void getAudienceId() {
        Assertions.assertEquals((long)0L, (long)this.attachmentPlugin.getAudienceId(null));
    }

    @Test
    public void getSpaceId() {
        Assertions.assertEquals((long)0L, (long)this.attachmentPlugin.getSpaceId(""));
    }
}

