/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.PageCreateModel;
import io.meeds.layout.model.PageTemplate;
import io.meeds.layout.model.PermissionUpdateModel;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.service.ContainerLayoutService;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PageLayoutService;
import io.meeds.layout.service.PageTemplateService;
import io.meeds.layout.service.PortletInstanceService;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import org.exoplatform.commons.addons.AddOnService;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.ModelObject;
import org.exoplatform.portal.config.model.ModelStyle;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.config.model.PageBody;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.config.model.TransientApplicationState;
import org.exoplatform.portal.config.serialize.model.SiteLayout;
import org.exoplatform.portal.mop.PageType;
import org.exoplatform.portal.mop.QueryResult;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PageLayoutService.class})
@ExtendWith(value={MockitoExtension.class})
public class PageLayoutServiceTest {
    private static final String ADDON_CONTAINER = "addonContainer";
    private static final String TEST_ADDON_CONTAINER = "testAddonContainer";
    private static final String TEST_USER = "testuser";
    private static final SiteKey SITE_KEY = SiteKey.portal((String)"test");
    private static final PageKey PAGE_KEY = PageKey.parse((String)"portal::test::test");
    @MockBean
    private LayoutService layoutService;
    @MockBean
    private LayoutAclService aclService;
    @MockBean
    private PageTemplateService pageTemplateService;
    @MockBean
    private UserPortalConfigService userPortalConfigService;
    @MockBean
    private AddOnService addOnService;
    @MockBean
    private ContainerLayoutService containerLayoutService;
    @MockBean
    private PortletInstanceService portletInstanceService;
    @Autowired
    private PageLayoutService pageLayoutService;
    @Mock
    private PortalConfig portalConfig;
    @Mock
    private PageContext pageContext;
    @Mock
    private PageState pageState;
    @Mock
    private Page page;
    @Mock
    private PortalConfig site;

    @Test
    public void getPages() {
        String siteTypeName = SITE_KEY.getTypeName();
        String siteName = SITE_KEY.getName();
        String pageDisplayName = "pageDisplayName";
        int offset = 0;
        int limit = 10;
        ArrayList<PageContext> pageContexts = new ArrayList<PageContext>();
        QueryResult queryResult = (QueryResult)Mockito.mock(QueryResult.class);
        Mockito.when((Object)queryResult.iterator()).thenAnswer(invocation -> pageContexts.iterator());
        Mockito.when((Object)this.layoutService.findPages(offset, limit, SITE_KEY.getType(), siteName, null, pageDisplayName)).thenReturn((Object)queryResult);
        List result = this.pageLayoutService.getPages(siteTypeName, siteName, pageDisplayName, offset, limit, TEST_USER);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)0, (int)result.size());
        Mockito.when((Object)this.pageContext.getKey()).thenReturn((Object)PAGE_KEY);
        pageContexts.add(this.pageContext);
        result = this.pageLayoutService.getPages(siteTypeName, siteName, pageDisplayName, offset, limit, TEST_USER);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)0, (int)result.size());
        Mockito.when((Object)this.aclService.canViewPage(PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        result = this.pageLayoutService.getPages(siteTypeName, siteName, pageDisplayName, offset, limit, TEST_USER);
        Assertions.assertNotNull((Object)result);
        Assertions.assertEquals((int)1, (int)result.size());
    }

    @Test
    public void impersonateSite() {
        SiteLayout pageBodyContainer = (SiteLayout)Mockito.mock(SiteLayout.class);
        Mockito.when((Object)this.site.getPortalLayout()).thenReturn((Object)pageBodyContainer);
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.site);
        Assertions.assertDoesNotThrow(() -> this.pageLayoutService.impersonateSite(SITE_KEY));
        Mockito.when((Object)this.layoutService.findPages(SITE_KEY)).thenReturn(Collections.singletonList(this.pageContext));
        Mockito.when((Object)this.pageContext.getKey()).thenReturn((Object)PAGE_KEY);
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Container container = (Container)Mockito.mock(Container.class);
        Application application = (Application)Mockito.mock(Application.class);
        Portlet preferences = (Portlet)Mockito.mock(Portlet.class);
        Mockito.when((Object)container.getChildren()).thenReturn(new ArrayList<Application>(Collections.singleton(application)));
        Mockito.when((Object)this.page.getChildren()).thenReturn(new ArrayList<Container>(Collections.singleton(container)));
        Mockito.when((Object)this.portletInstanceService.getApplicationPortletPreferences(application)).thenReturn((Object)preferences);
        ApplicationState state = (ApplicationState)Mockito.mock(ApplicationState.class);
        Mockito.when((Object)application.getState()).thenReturn((Object)state);
        this.pageLayoutService.impersonateSite(SITE_KEY);
        ((ContainerLayoutService)Mockito.verify((Object)this.containerLayoutService)).impersonateContainer(container, this.page);
        ((LayoutService)Mockito.verify((Object)this.layoutService, (VerificationMode)Mockito.never())).save(state, preferences);
        Mockito.when((Object)application.getStorageId()).thenReturn((Object)"2");
        this.pageLayoutService.impersonateSite(SITE_KEY);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save(state, preferences);
    }

    @Test
    public void getPage() throws IllegalAccessException, ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.getPage(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPageContext(PAGE_KEY)).thenReturn((Object)this.pageContext);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageLayoutService.getPage(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.aclService.canViewPage(PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        Assertions.assertEquals((Object)this.pageContext, (Object)this.pageLayoutService.getPage(PAGE_KEY, TEST_USER));
    }

    @Test
    public void getPageLayout() throws IllegalAccessException, ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.getPageLayout(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageLayoutService.getPageLayout(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.aclService.canViewPage(PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageLayoutService.getPageLayout(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.aclService.canViewSite(PAGE_KEY.getSite(), TEST_USER)).thenReturn((Object)true);
        Assertions.assertNull((Object)this.pageLayoutService.getPageLayout(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.aclService.hasAccessPermission((ModelObject)this.page, TEST_USER)).thenReturn((Object)true);
        Assertions.assertEquals((Object)this.page, (Object)this.pageLayoutService.getPageLayout(PAGE_KEY, TEST_USER));
    }

    @Test
    public void getPageLayoutWithSite() throws IllegalAccessException, ObjectNotFoundException {
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Mockito.when((Object)this.aclService.canViewPage(PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.aclService.canViewSite(PAGE_KEY.getSite(), TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.aclService.hasAccessPermission((ModelObject)this.page, TEST_USER)).thenReturn((Object)true);
        Assertions.assertEquals((Object)this.page, (Object)this.pageLayoutService.getPageLayout(PAGE_KEY, TEST_USER));
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.getPageLayout(PAGE_KEY, 2L, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(2L)).thenReturn((Object)this.site);
        Assertions.assertNull((Object)this.pageLayoutService.getPageLayout(PAGE_KEY, 2L, TEST_USER));
        Container container = (Container)Mockito.mock(Container.class);
        Application application = (Application)Mockito.mock(Application.class);
        Portlet preferences = (Portlet)Mockito.mock(Portlet.class);
        Mockito.when((Object)container.getChildren()).thenReturn(new ArrayList<Application>(Collections.singleton(application)));
        Mockito.when((Object)this.portletInstanceService.getApplicationPortletPreferences(application)).thenReturn((Object)preferences);
        PageBody pageBody = (PageBody)Mockito.mock(PageBody.class);
        SiteLayout pageBodyContainer = (SiteLayout)Mockito.mock(SiteLayout.class);
        Mockito.when((Object)this.site.getPortalLayout()).thenReturn((Object)pageBodyContainer);
        Mockito.when((Object)pageBodyContainer.getChildren()).thenReturn(new ArrayList<PageBody>(Collections.singleton(pageBody)));
        Assertions.assertNull((Object)this.pageLayoutService.getPageLayout(PAGE_KEY, 2L, TEST_USER));
        Mockito.when((Object)this.aclService.hasAccessPermission((ModelObject)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)TEST_USER))).thenReturn((Object)true);
        ModelObject pageLayout = this.pageLayoutService.getPageLayout(PAGE_KEY, 2L, true, TEST_USER);
        Assertions.assertNotNull((Object)pageLayout);
        Mockito.when((Object)this.page.getChildren()).thenReturn(new ArrayList<Container>(Collections.singleton(container)));
        pageLayout = this.pageLayoutService.getPageLayout(PAGE_KEY, 2L, true, TEST_USER);
        Assertions.assertNotNull((Object)pageLayout);
        ((Application)Mockito.verify((Object)application)).setState((ApplicationState)ArgumentMatchers.argThat(state -> {
            TransientApplicationState transientState;
            return state instanceof TransientApplicationState && Objects.equals((transientState = (TransientApplicationState)state).getContentState(), preferences);
        }));
    }

    @Test
    public void getPageApplicationLayout() throws IllegalAccessException, ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.getPageApplicationLayout(PAGE_KEY, 2L, TEST_USER));
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageLayoutService.getPageApplicationLayout(PAGE_KEY, 2L, TEST_USER));
        Mockito.when((Object)this.aclService.canViewPage(PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.aclService.canViewSite(PAGE_KEY.getSite(), TEST_USER)).thenReturn((Object)true);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.getPageApplicationLayout(PAGE_KEY, 2L, TEST_USER));
        Container container = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)this.page.getChildren()).thenReturn(new ArrayList<Container>(Collections.singleton(container)));
        Application application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)application.getStorageId()).thenReturn((Object)"2");
        Mockito.when((Object)container.getChildren()).thenReturn(new ArrayList<Application>(Collections.singleton(application)));
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.getPageApplicationLayout(PAGE_KEY, 2L, TEST_USER));
        Mockito.when((Object)this.aclService.hasAccessPermission((ModelObject)this.page, TEST_USER)).thenReturn((Object)true);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageLayoutService.getPageApplicationLayout(PAGE_KEY, 2L, TEST_USER));
        Mockito.when((Object)this.aclService.hasAccessPermission((ModelObject)container, TEST_USER)).thenReturn((Object)true);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageLayoutService.getPageApplicationLayout(PAGE_KEY, 2L, TEST_USER));
        Mockito.when((Object)this.aclService.hasAccessPermission((ModelObject)application, TEST_USER)).thenReturn((Object)true);
        Assertions.assertNotNull((Object)this.pageLayoutService.getPageApplicationLayout(PAGE_KEY, 2L, TEST_USER));
    }

    @Test
    public void getPageLayoutWithDynamicContainer() {
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Container dynamicContainer = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)dynamicContainer.getFactoryId()).thenReturn((Object)ADDON_CONTAINER);
        Mockito.when((Object)dynamicContainer.getName()).thenReturn((Object)TEST_ADDON_CONTAINER);
        Mockito.when((Object)this.page.getChildren()).thenReturn(new ArrayList<Container>(Collections.singleton(dynamicContainer)));
        Application application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)this.addOnService.getApplications(TEST_ADDON_CONTAINER)).thenReturn(Collections.singletonList(application));
        this.pageLayoutService.getPageLayout(PAGE_KEY);
        ((Container)Mockito.verify((Object)dynamicContainer)).setChildren((ArrayList)ArgumentMatchers.argThat(children -> children != null && children.size() == 1 && children.get(0) == application));
    }

    @Test
    public void createPage() {
        PageCreateModel pageModel = (PageCreateModel)Mockito.mock(PageCreateModel.class);
        Mockito.when((Object)pageModel.getPageSiteType()).thenReturn((Object)SITE_KEY.getTypeName());
        Mockito.when((Object)pageModel.getPageSiteName()).thenReturn((Object)SITE_KEY.getName());
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.createPage(pageModel, TEST_USER));
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageLayoutService.createPage(pageModel, TEST_USER));
        Mockito.when((Object)this.aclService.canEditNavigation(SITE_KEY, TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)pageModel.getPageName()).thenReturn((Object)PAGE_KEY.getName());
        Mockito.when((Object)pageModel.getPageTemplateId()).thenReturn((Object)2L);
        String pageTitle = "pageTitle";
        Mockito.when((Object)pageModel.getPageTitle()).thenReturn((Object)pageTitle);
        String sitePermission = "site permission";
        Mockito.when((Object)this.portalConfig.getAccessPermissions()).thenReturn((Object)new String[]{sitePermission});
        String siteEditPermission = "site edit permission";
        Mockito.when((Object)this.portalConfig.getEditPermission()).thenReturn((Object)siteEditPermission);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.createPage(pageModel, TEST_USER));
        PageTemplate pageTemplate = (PageTemplate)Mockito.mock(PageTemplate.class);
        Mockito.when((Object)pageTemplate.getContent()).thenReturn((Object)"{}");
        Mockito.when((Object)this.pageTemplateService.getPageTemplate(2L)).thenReturn((Object)pageTemplate);
        this.pageLayoutService.createPage(pageModel, TEST_USER);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save((PageContext)ArgumentMatchers.any(PageContext.class), (Page)ArgumentMatchers.argThat(p -> p.getAccessPermissions()[0].equals(sitePermission) && p.getEditPermission().equals(siteEditPermission) && p.getTitle().equals(pageTitle)));
        String pagePermission = "page permission";
        Mockito.when((Object)pageModel.getAccessPermissions()).thenReturn((Object)new String[]{pagePermission});
        String pageEditPermission = "page edit permission";
        Mockito.when((Object)pageModel.getEditPermission()).thenReturn((Object)pageEditPermission);
        this.pageLayoutService.createPage(pageModel, TEST_USER);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save((PageContext)ArgumentMatchers.any(PageContext.class), (Page)ArgumentMatchers.argThat(p -> p.getAccessPermissions()[0].equals(pagePermission) && p.getEditPermission().equals(pageEditPermission)));
    }

    @Test
    public void createPageWithLink() {
        PageCreateModel pageModel = (PageCreateModel)Mockito.mock(PageCreateModel.class);
        Mockito.when((Object)pageModel.getPageSiteType()).thenReturn((Object)SITE_KEY.getTypeName());
        Mockito.when((Object)pageModel.getPageSiteName()).thenReturn((Object)SITE_KEY.getName());
        Mockito.when((Object)pageModel.getPageType()).thenReturn((Object)PageType.LINK.name());
        Mockito.when((Object)pageModel.getLink()).thenReturn((Object)"#link");
        Mockito.when((Object)pageModel.getPageName()).thenReturn((Object)PAGE_KEY.getName());
        String pageTitle = "pageTitle";
        Mockito.when((Object)pageModel.getPageTitle()).thenReturn((Object)pageTitle);
        String sitePermission = "site permission";
        Mockito.when((Object)this.portalConfig.getAccessPermissions()).thenReturn((Object)new String[]{sitePermission});
        String siteEditPermission = "site edit permission";
        Mockito.when((Object)this.portalConfig.getEditPermission()).thenReturn((Object)siteEditPermission);
        Mockito.when((Object)this.layoutService.getPortalConfig(SITE_KEY)).thenReturn((Object)this.portalConfig);
        Mockito.when((Object)this.aclService.canEditNavigation(SITE_KEY, TEST_USER)).thenReturn((Object)true);
        this.pageLayoutService.createPage(pageModel, TEST_USER);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save((PageContext)ArgumentMatchers.any(PageContext.class), (Page)ArgumentMatchers.argThat(p -> p.getAccessPermissions()[0].equals(sitePermission) && p.getEditPermission().equals(siteEditPermission) && p.getLink().equals(pageModel.getLink()) && p.getType().equals(PageType.LINK.name()) && p.getTitle().equals(pageTitle)));
    }

    @Test
    public void clonePage() throws IllegalAccessException, ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.clonePage(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageLayoutService.clonePage(PAGE_KEY, TEST_USER));
        Mockito.when((Object)this.aclService.canEditPage(PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.page.getName()).thenReturn((Object)PAGE_KEY.getName());
        this.pageLayoutService.clonePage(PAGE_KEY, TEST_USER);
        ((Page)Mockito.verify((Object)this.page)).resetStorage();
        ((Page)Mockito.verify((Object)this.page)).setName(PAGE_KEY.getName() + "_draft_testuser");
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save((PageContext)ArgumentMatchers.any(PageContext.class), (Page)ArgumentMatchers.eq((Object)this.page));
    }

    @Test
    public void clonePageWithDynamicContainer() throws IllegalAccessException, ObjectNotFoundException {
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Container dynamicContainer = (Container)Mockito.mock(Container.class);
        Mockito.when((Object)dynamicContainer.getFactoryId()).thenReturn((Object)ADDON_CONTAINER);
        Mockito.when((Object)dynamicContainer.getName()).thenReturn((Object)TEST_ADDON_CONTAINER);
        Mockito.when((Object)this.page.getChildren()).thenReturn(new ArrayList<Container>(Collections.singleton(dynamicContainer)));
        Application application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)this.addOnService.getApplications(TEST_ADDON_CONTAINER)).thenReturn(Collections.singletonList(application));
        Mockito.when((Object)this.aclService.canEditPage(PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.page.getName()).thenReturn((Object)PAGE_KEY.getName());
        this.pageLayoutService.clonePage(PAGE_KEY, TEST_USER);
        ((Page)Mockito.verify((Object)this.page)).setChildren((ArrayList)ArgumentMatchers.argThat(children -> children != null && children.size() == 1 && children.get(0) == application));
    }

    @Test
    public void updatePageApplicationPreferences() throws IllegalAccessException, ObjectNotFoundException {
        PortletInstancePreference portletInstancePreference = (PortletInstancePreference)Mockito.mock(PortletInstancePreference.class);
        List<PortletInstancePreference> preferences = Collections.singletonList(portletInstancePreference);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.updatePageApplicationPreferences(PAGE_KEY, 2L, preferences, TEST_USER));
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageLayoutService.updatePageApplicationPreferences(PAGE_KEY, 2L, preferences, TEST_USER));
        Mockito.when((Object)this.aclService.canEditPage(PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.updatePageApplicationPreferences(PAGE_KEY, 2L, preferences, TEST_USER));
        Container container = (Container)Mockito.mock(Container.class);
        Application application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)container.getChildren()).thenReturn(new ArrayList<Application>(Collections.singleton(application)));
        Mockito.when((Object)this.page.getChildren()).thenReturn(new ArrayList<Container>(Collections.singleton(container)));
        Mockito.when((Object)application.getStorageId()).thenReturn((Object)"2");
        ApplicationState state = (ApplicationState)Mockito.mock(ApplicationState.class);
        Mockito.when((Object)application.getState()).thenReturn((Object)state);
        Mockito.when((Object)portletInstancePreference.getName()).thenReturn((Object)"name");
        Mockito.when((Object)portletInstancePreference.getValue()).thenReturn((Object)"value");
        this.pageLayoutService.updatePageApplicationPreferences(PAGE_KEY, 2L, preferences, TEST_USER);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save((ApplicationState)ArgumentMatchers.eq((Object)state), (Portlet)ArgumentMatchers.argThat(prefs -> prefs.getValue("name").equals("value")));
    }

    @Test
    public void updatePageLayout() throws IllegalAccessException, ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, true, TEST_USER));
        Mockito.when((Object)this.layoutService.getPage(PAGE_KEY)).thenReturn((Object)this.page);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, true, TEST_USER));
        Mockito.when((Object)this.aclService.canEditPage(PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.page.getPageKey()).thenReturn((Object)PAGE_KEY);
        this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, false, TEST_USER);
        ((Page)Mockito.verify((Object)this.page, (VerificationMode)Mockito.never())).resetStorage();
        ((Page)Mockito.verify((Object)this.page)).setChildren((ArrayList)ArgumentMatchers.any());
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save(this.page);
        this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, true, TEST_USER);
        ((Page)Mockito.verify((Object)this.page)).resetStorage();
        String width = "36px";
        String height = "36%";
        String borderColor = "#256977";
        Mockito.when((Object)this.page.getWidth()).thenReturn((Object)width);
        Mockito.when((Object)this.page.getHeight()).thenReturn((Object)height);
        ModelStyle cssStyle = (ModelStyle)Mockito.mock(ModelStyle.class);
        Mockito.when((Object)this.page.getCssStyle()).thenReturn((Object)cssStyle);
        Mockito.when((Object)cssStyle.getBorderColor()).thenReturn((Object)borderColor);
        Assertions.assertDoesNotThrow(() -> this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, true, TEST_USER));
        Mockito.when((Object)this.page.getWidth()).thenReturn((Object)"eval('alert(`XSS in width CSS style`)')");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, true, TEST_USER));
        Mockito.when((Object)this.page.getWidth()).thenReturn((Object)width);
        Mockito.when((Object)this.page.getHeight()).thenReturn((Object)"eval('alert(`XSS in height CSS style`)')");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, true, TEST_USER));
        Mockito.when((Object)this.page.getHeight()).thenReturn((Object)height);
        Mockito.when((Object)cssStyle.getBorderColor()).thenReturn((Object)"eval('alert(`XSS in background CSS style`)')");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, true, TEST_USER));
        Mockito.when((Object)cssStyle.getBorderColor()).thenReturn((Object)borderColor);
        Assertions.assertDoesNotThrow(() -> this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, true, TEST_USER));
        Application application = (Application)Mockito.mock(Application.class);
        Mockito.when((Object)this.page.getChildren()).thenReturn(new ArrayList<Application>(Collections.singletonList(application)));
        Mockito.when((Object)application.getWidth()).thenReturn((Object)"eval('alert(`XSS in application width CSS style`)')");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, true, TEST_USER));
        Mockito.when((Object)application.getWidth()).thenReturn((Object)width);
        Mockito.when((Object)application.getHeight()).thenReturn((Object)"eval('alert(`XSS in application height CSS style`)')");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, true, TEST_USER));
        Mockito.when((Object)application.getHeight()).thenReturn((Object)height);
        ModelStyle applicationCssStyle = (ModelStyle)Mockito.mock(ModelStyle.class);
        Mockito.when((Object)application.getCssStyle()).thenReturn((Object)applicationCssStyle);
        Mockito.when((Object)applicationCssStyle.getBorderColor()).thenReturn((Object)"eval('alert(`XSS in application background CSS style`)')");
        Assertions.assertThrows(IllegalArgumentException.class, () -> this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, true, TEST_USER));
        Mockito.when((Object)applicationCssStyle.getBorderColor()).thenReturn((Object)borderColor);
        Assertions.assertDoesNotThrow(() -> this.pageLayoutService.updatePageLayout(PAGE_KEY.format(), this.page, true, TEST_USER));
    }

    @Test
    public void updatePageLink() throws IllegalAccessException, IllegalStateException, ObjectNotFoundException {
        String link = "link";
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.updatePageLink(PAGE_KEY, link, TEST_USER));
        Mockito.when((Object)this.layoutService.getPageContext(PAGE_KEY)).thenReturn((Object)this.pageContext);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageLayoutService.updatePageLink(PAGE_KEY, link, TEST_USER));
        Mockito.when((Object)this.aclService.canEditPage(PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.pageContext.getState()).thenReturn((Object)this.pageState);
        Assertions.assertThrows(IllegalStateException.class, () -> this.pageLayoutService.updatePageLink(PAGE_KEY, link, TEST_USER));
        Mockito.when((Object)this.pageState.getType()).thenReturn((Object)PageType.LINK.name());
        this.pageLayoutService.updatePageLink(PAGE_KEY, link, TEST_USER);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save(this.pageContext);
        ((PageState)Mockito.verify((Object)this.pageState)).setLink(link);
    }

    @Test
    public void updatePagePermissions() throws IllegalAccessException, ObjectNotFoundException {
        List<String> accessPermissions = Arrays.asList("access", "permissions");
        String editPermission = "edit permission";
        PermissionUpdateModel permissionModel = new PermissionUpdateModel(accessPermissions, editPermission);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageLayoutService.updatePagePermissions(PAGE_KEY, permissionModel, TEST_USER));
        Mockito.when((Object)this.layoutService.getPageContext(PAGE_KEY)).thenReturn((Object)this.pageContext);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageLayoutService.updatePagePermissions(PAGE_KEY, permissionModel, TEST_USER));
        Mockito.when((Object)this.aclService.canEditPage(PAGE_KEY, TEST_USER)).thenReturn((Object)true);
        Mockito.when((Object)this.pageContext.getState()).thenReturn((Object)this.pageState);
        this.pageLayoutService.updatePagePermissions(PAGE_KEY, permissionModel, TEST_USER);
        ((LayoutService)Mockito.verify((Object)this.layoutService)).save(this.pageContext);
        ((PageState)Mockito.verify((Object)this.pageState)).setEditPermission(permissionModel.getEditPermission());
        ((PageState)Mockito.verify((Object)this.pageState)).setAccessPermissions(permissionModel.getAccessPermissions());
    }
}

