/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin;

import io.meeds.layout.plugin.SpaceNavigationDatabindPlugin;
import io.meeds.layout.service.NavigationLayoutService;
import io.meeds.layout.service.PageLayoutService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.service.DatabindService;
import io.meeds.social.space.template.model.SpaceTemplate;
import io.meeds.social.space.template.service.SpaceTemplateService;
import io.meeds.social.translation.service.TranslationService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.SiteKey;
import org.exoplatform.portal.mop.navigation.NavigationContext;
import org.exoplatform.portal.mop.navigation.NodeContext;
import org.exoplatform.portal.mop.service.DescriptionService;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.mop.service.NavigationService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={SpaceNavigationDatabindPlugin.class})
@ExtendWith(value={MockitoExtension.class})
class SpaceNavigationDatabindPluginTest {
    @Mock
    private Identity userIdentity;
    @MockBean
    protected DatabindService databindService;
    @MockBean
    protected FileService fileService;
    @MockBean
    protected TranslationService translationService;
    @MockBean
    protected SpaceTemplateService spaceTemplateService;
    @MockBean
    protected AttachmentService attachmentService;
    @MockBean
    LayoutService layoutService;
    @MockBean
    private NavigationService navigationService;
    @MockBean
    DescriptionService descriptionService;
    @MockBean
    private NavigationLayoutService navigationLayoutService;
    @MockBean
    private PageLayoutService pageLayoutService;
    @MockBean
    PortletInstanceService portletInstanceService;
    @MockBean
    protected UserACL userAcl;
    @MockBean
    private IdentityManager identityManager;
    @Autowired
    private SpaceNavigationDatabindPlugin spaceNavigationDatabindPlugin;

    SpaceNavigationDatabindPluginTest() {
    }

    @Test
    void getObjectType() {
        Assertions.assertEquals((Object)"SpaceNavigation", (Object)this.spaceNavigationDatabindPlugin.getObjectType());
    }

    @Test
    void canHandleDatabind() {
        Assertions.assertTrue((boolean)this.spaceNavigationDatabindPlugin.canHandleDatabind("SpaceTemplate", "1"));
        Assertions.assertFalse((boolean)this.spaceNavigationDatabindPlugin.canHandleDatabind("ObjectInstance", "1"));
    }

    @Test
    void serialize() throws IllegalAccessException {
        ZipOutputStream zipOutputStream = (ZipOutputStream)Mockito.mock(ZipOutputStream.class);
        SpaceTemplate spaceTemplate = (SpaceTemplate)Mockito.mock(SpaceTemplate.class);
        PortalConfig portalConfig = (PortalConfig)Mockito.mock(PortalConfig.class);
        Mockito.when((Object)spaceTemplate.getLayout()).thenReturn((Object)"layout");
        Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(ArgumentMatchers.anyLong(), Mockito.anyString(), (Locale)Mockito.any(Locale.class), Mockito.anyBoolean())).thenReturn((Object)spaceTemplate);
        Mockito.when((Object)this.layoutService.getPortalConfig((SiteKey)Mockito.any(SiteKey.class))).thenReturn((Object)portalConfig);
        this.spaceNavigationDatabindPlugin.serialize("1", zipOutputStream, "root");
        ((SpaceTemplateService)Mockito.verify((Object)this.spaceTemplateService, (VerificationMode)Mockito.times((int)1))).getSpaceTemplate(ArgumentMatchers.anyLong(), Mockito.anyString(), (Locale)Mockito.any(Locale.class), Mockito.anyBoolean());
    }

    @Test
    void deserialize() throws Exception {
        File zipFile = this.createZipFileWithTwoJsonFiles();
        NodeContext parentNode = (NodeContext)Mockito.mock(NodeContext.class);
        Mockito.when((Object)parentNode.getId()).thenReturn((Object)"85");
        Mockito.when((Object)this.navigationService.loadNode((SiteKey)Mockito.any(SiteKey.class))).thenReturn(null).thenReturn((Object)parentNode);
        ((NavigationService)Mockito.doNothing().when((Object)this.navigationService)).saveNavigation((NavigationContext)Mockito.any(NavigationContext.class));
        SpaceTemplate spaceTemplate = (SpaceTemplate)Mockito.mock(SpaceTemplate.class);
        Mockito.when((Object)spaceTemplate.getLayout()).thenReturn((Object)"layout");
        Mockito.when((Object)this.spaceTemplateService.getSpaceTemplate(ArgumentMatchers.anyLong())).thenReturn((Object)spaceTemplate);
        CompletableFuture futureReport = this.spaceNavigationDatabindPlugin.deserialize(zipFile, null, "admin");
        DatabindReport report = (DatabindReport)((CompletableFuture)futureReport.thenApply(Pair::getLeft)).join();
        Assertions.assertNotNull((Object)report);
        Assertions.assertTrue((boolean)report.isSuccess());
        Assertions.assertEquals((int)2, (int)report.getProcessedItems().size());
    }

    private File createZipFileWithTwoJsonFiles() throws IOException {
        File tempFile = File.createTempFile("test", ".zip");
        try (FileOutputStream fos = new FileOutputStream(tempFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            this.addJsonToZip(zos, "space1/config.json", "{\"spaceTemplateId\":\"4\"}");
            this.addJsonToZip(zos, "space1/navigation.json", "[{\"name\":\"overview\",\"icon\":null,\"visibility\":\"DISPLAYED\",\"pageReference\":\"portal_template::public::overview\",\"labels\":{},\"children\":[{\"name\":\"actions\",\"icon\":null,\"visibility\":\"DISPLAYED\",\"pageReference\":\"portal_template::public::actions\",\"labels\":{},\"children\":[]}]}]");
            this.addJsonToZip(zos, "site2/config.json", "{\"spaceTemplateId\":\"4\"}");
        }
        return tempFile;
    }

    private void addJsonToZip(ZipOutputStream zos, String fileName, String jsonContent) throws IOException {
        ZipEntry entry = new ZipEntry(fileName);
        zos.putNextEntry(entry);
        zos.write(jsonContent.getBytes());
        zos.closeEntry();
    }
}

