/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.upgrade;

import io.meeds.layout.plugin.upgrade.SpaceBannerHomePageUpgradePlugin;
import io.meeds.layout.service.PortletInstanceService;
import jakarta.persistence.EntityManager;
import jakarta.persistence.EntityTransaction;
import jakarta.persistence.Query;
import java.io.Serializable;
import java.util.ArrayList;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.persistence.impl.EntityManagerService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.jdbc.entity.PageEntity;
import org.exoplatform.portal.jdbc.entity.WindowEntity;
import org.exoplatform.portal.mop.dao.PageDAO;
import org.exoplatform.portal.mop.dao.WindowDAO;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class SpaceBannerHomePageUpgradePluginTest {
    @Mock
    private CacheService cacheService;
    @Mock
    private SettingService settingService;
    @Mock
    private PortletInstanceService portletInstanceService;
    @Mock
    private EntityManagerService entityManagerService;
    @Mock
    private WindowDAO windowDAO;
    @Mock
    private PageDAO pageDAO;
    @Mock
    private InitParams initParams;
    @Mock
    private EntityManager entityManager;
    @Mock
    private ExoCache<Serializable, Object> portletPreferencesCache;
    @Mock
    private Query query;

    @BeforeEach
    public void before() {
        Mockito.when((Object)this.cacheService.getCacheInstance("portal.PortletPreferences")).thenReturn(this.portletPreferencesCache);
    }

    @Test
    public void processUpgrade() {
        ArrayList<Long> pageIdList = new ArrayList<Long>();
        pageIdList.add(1L);
        pageIdList.add(2L);
        pageIdList.add(null);
        Mockito.when((Object)this.query.getResultList()).thenReturn(pageIdList);
        Mockito.when((Object)this.entityManager.createNativeQuery(ArgumentMatchers.anyString(), (Class)ArgumentMatchers.any())).thenReturn((Object)this.query);
        Mockito.when((Object)this.entityManager.createNativeQuery(ArgumentMatchers.anyString())).thenReturn((Object)this.query);
        Mockito.when((Object)this.entityManagerService.getEntityManager()).thenReturn((Object)this.entityManager);
        EntityTransaction transaction = (EntityTransaction)Mockito.mock(EntityTransaction.class);
        Mockito.when((Object)transaction.isActive()).thenReturn((Object)true);
        Mockito.when((Object)this.entityManager.getTransaction()).thenReturn((Object)transaction);
        PageEntity pageEntity1 = (PageEntity)Mockito.mock(PageEntity.class);
        PageEntity pageEntity2 = (PageEntity)Mockito.mock(PageEntity.class);
        Mockito.when((Object)pageEntity1.getPageBody()).thenReturn((Object)"[{\"id\":1,\"type\":\"WINDOW\"}]");
        Mockito.when((Object)pageEntity2.getPageBody()).thenReturn((Object)"[{\"id\":2,\"type\":\"WINDOW\"}]");
        Mockito.when((Object)((PageEntity)this.pageDAO.find((Serializable)Long.valueOf(1L)))).thenReturn((Object)pageEntity1);
        Mockito.when((Object)((PageEntity)this.pageDAO.find((Serializable)Long.valueOf(2L)))).thenReturn((Object)pageEntity2);
        WindowEntity windowEntity1 = (WindowEntity)Mockito.mock(WindowEntity.class);
        WindowEntity windowEntity2 = (WindowEntity)Mockito.mock(WindowEntity.class);
        Mockito.when((Object)windowEntity1.getContentId()).thenReturn((Object)"social-portlet/SpaceMenuPortlet");
        Mockito.when((Object)windowEntity2.getContentId()).thenReturn((Object)"social-portlet/SpaceMenuPortlet");
        Mockito.when((Object)((WindowEntity)this.windowDAO.find((Serializable)Long.valueOf(1L)))).thenReturn((Object)windowEntity1);
        Mockito.when((Object)((WindowEntity)this.windowDAO.find((Serializable)Long.valueOf(2L)))).thenReturn((Object)windowEntity2);
        SpaceBannerHomePageUpgradePlugin spaceBannerHomePageUpgradePlugin = new SpaceBannerHomePageUpgradePlugin(this.settingService, this.initParams, this.entityManagerService, this.pageDAO, this.windowDAO, this.cacheService, this.portletInstanceService);
        spaceBannerHomePageUpgradePlugin.processUpgrade(null, null);
        ((Query)Mockito.verify((Object)this.query, (VerificationMode)Mockito.times((int)2))).executeUpdate();
    }
}

