/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.plugin.PortletInstancePreferencePlugin;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.storage.PortletInstanceLayoutStorage;
import java.util.ArrayList;
import java.util.Collections;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.portal.config.model.Application;
import org.exoplatform.portal.config.model.ApplicationState;
import org.exoplatform.portal.config.model.Container;
import org.exoplatform.portal.config.model.Page;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PortletInstanceLayoutStorage.class})
@ExtendWith(value={MockitoExtension.class})
public class PortletInstanceRenderServiceTest {
    private static final String CONTENT_ID = "test/content";
    @MockBean
    private LayoutAclService layoutAclService;
    @MockBean
    private SettingService settingService;
    @MockBean
    private LayoutService layoutService;
    @Autowired
    private PortletInstanceLayoutStorage portletInstanceLayoutStorage;
    @Mock
    private Application application;
    @Mock
    private PortletInstance portletInstance;
    @Mock
    private Page page;
    @Mock
    private Container container;
    @Mock
    private PortletInstancePreferencePlugin plugin;

    @Test
    public void getPortletInstanceApplicationByInstanceId() {
        Mockito.when((Object)this.settingService.get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"2"))).thenReturn((Object)new SettingValue((Object)"3"));
        Mockito.when((Object)this.layoutService.getApplicationModel("3")).thenReturn((Object)this.application);
        Mockito.when((Object)this.portletInstance.getId()).thenReturn((Object)2L);
        Application portletInstanceApplication = this.portletInstanceLayoutStorage.getPortletInstanceApplication(this.portletInstance, 0L);
        Assertions.assertEquals((Object)this.application, (Object)portletInstanceApplication);
    }

    @Test
    public void getPortletInstanceApplicationPlaceholder() {
        Assertions.assertNull((Object)this.portletInstanceLayoutStorage.getPortletInstanceApplication(null, 0L));
    }

    @Test
    public void getPortletInstancePreferencesWhenNoPlugin() {
        Mockito.when((Object)this.layoutService.getApplicationModel("3")).thenReturn((Object)this.application);
        Portlet portlet = new Portlet();
        Mockito.when((Object)this.layoutService.load((ApplicationState)ArgumentMatchers.any())).thenReturn((Object)portlet);
        portlet.setValue("test", "testValue");
        Portlet portletInstancePreferences = this.portletInstanceLayoutStorage.getApplicationPreferences(3L);
        Assertions.assertNotNull((Object)portletInstancePreferences);
        Assertions.assertEquals((Object)"test", (Object)((Preference)portletInstancePreferences.iterator().next()).getName());
        Assertions.assertEquals((Object)"testValue", (Object)((Preference)portletInstancePreferences.iterator().next()).getValue());
    }

    @Test
    public void getPortletInstanceApplicationByInstanceIdAndCreateApplication() {
        PortletInstancePreference preference = new PortletInstancePreference();
        preference.setName("prefName");
        preference.setValue("prefValue");
        Mockito.when((Object)this.portletInstance.getPreferences()).thenReturn(Collections.singletonList(preference));
        Mockito.when((Object)this.portletInstance.getContentId()).thenReturn((Object)CONTENT_ID);
        ((LayoutService)Mockito.doAnswer(invocation -> {
            Mockito.when((Object)this.layoutService.getPage((PageKey)ArgumentMatchers.any(PageKey.class))).thenReturn((Object)this.page);
            ArrayList<Container> list = new ArrayList<Container>();
            list.add(this.container);
            Mockito.when((Object)this.page.getChildren()).thenReturn(list);
            ArrayList<Application> apps = new ArrayList<Application>();
            apps.add(this.application);
            Mockito.when((Object)this.container.getChildren()).thenReturn(apps);
            return null;
        }).when((Object)this.layoutService)).save((PageContext)ArgumentMatchers.any(PageContext.class), (Page)ArgumentMatchers.any(Page.class));
        ((Container)Mockito.doAnswer(invocation -> {
            ArrayList children = (ArrayList)invocation.getArgument(0);
            children.set(children.size() - 1, this.application);
            Mockito.when((Object)this.container.getChildren()).thenReturn((Object)children);
            Mockito.when((Object)this.application.getStorageId()).thenReturn((Object)"3");
            return null;
        }).when((Object)this.container)).setChildren((ArrayList)ArgumentMatchers.any());
        Application portletInstanceApplication = this.portletInstanceLayoutStorage.getPortletInstanceApplication(this.portletInstance, 0L);
        Assertions.assertEquals((Object)this.application, (Object)portletInstanceApplication);
    }

    @Test
    public void getPortletInstanceApplicationByApplicationId() {
        Mockito.when((Object)this.settingService.get((Context)ArgumentMatchers.any(), (Scope)ArgumentMatchers.any(), (String)ArgumentMatchers.eq((Object)"2"))).thenReturn((Object)new SettingValue((Object)"3"));
        Mockito.when((Object)this.layoutService.getApplicationModel("3")).thenReturn((Object)this.application);
        Application portletInstanceApplication = this.portletInstanceLayoutStorage.getPortletInstanceApplication(null, 3L);
        Assertions.assertEquals((Object)this.application, (Object)portletInstanceApplication);
    }
}

