/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin;

import io.meeds.layout.model.LayoutModel;
import io.meeds.layout.model.PageTemplate;
import io.meeds.layout.model.PageTemplateDatabind;
import io.meeds.layout.plugin.PageTemplateDatabindPlugin;
import io.meeds.layout.service.PageTemplateService;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.layout.util.JsonUtils;
import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.service.DatabindService;
import io.meeds.social.translation.service.TranslationService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PageTemplateDatabindPlugin.class})
@ExtendWith(value={MockitoExtension.class})
class PageTemplateDatabindPluginTest {
    @MockBean
    private PageTemplateService pageTemplateService;
    @MockBean
    private DatabindService databindService;
    @MockBean
    private FileService fileService;
    @MockBean
    private TranslationService translationService;
    @MockBean
    private AttachmentService attachmentService;
    @MockBean
    private PortletInstanceService portletInstanceService;
    @MockBean
    private UserACL userAcl;
    @MockBean
    private IdentityManager identityManager;
    @Autowired
    private PageTemplateDatabindPlugin pageTemplateDatabindPlugin;

    PageTemplateDatabindPluginTest() {
    }

    @Test
    void getObjectType() {
        Assertions.assertEquals((Object)"PageTemplate", (Object)this.pageTemplateDatabindPlugin.getObjectType());
    }

    @Test
    void canHandleDatabind() {
        Assertions.assertTrue((boolean)this.pageTemplateDatabindPlugin.canHandleDatabind("PageTemplate", "1"));
        Assertions.assertFalse((boolean)this.pageTemplateDatabindPlugin.canHandleDatabind("ObjectInstance", "1"));
    }

    @Test
    void serialize() {
        ZipOutputStream zipOutputStream = (ZipOutputStream)Mockito.mock(ZipOutputStream.class);
        PageTemplate pageTemplate = (PageTemplate)Mockito.mock(PageTemplate.class);
        Mockito.when((Object)this.pageTemplateService.getPageTemplate(ArgumentMatchers.anyLong(), (Locale)Mockito.any(Locale.class), Mockito.anyBoolean(), Mockito.anyBoolean())).thenReturn((Object)pageTemplate);
        Mockito.when((Object)pageTemplate.getContent()).thenReturn((Object)JsonUtils.toJsonString((Object)new LayoutModel()));
        this.pageTemplateDatabindPlugin.serialize("1", zipOutputStream, "root");
        ((PageTemplateService)Mockito.verify((Object)this.pageTemplateService, (VerificationMode)Mockito.times((int)1))).getPageTemplate(1L, Locale.getDefault(), true, true);
    }

    @Test
    void deserialize() throws Exception {
        File zipFile = this.createZipFileWithTwoJsonFiles();
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.userAcl.getSuperUser()).thenReturn((Object)"root");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity(this.userAcl.getSuperUser())).thenReturn((Object)identity);
        Mockito.lenient().when((Object)identity.getId()).thenReturn((Object)"29");
        Mockito.when((Object)this.pageTemplateService.createPageTemplate((PageTemplate)Mockito.any())).thenReturn((Object)new PageTemplate());
        CompletableFuture futureReport = this.pageTemplateDatabindPlugin.deserialize(zipFile, null, "admin");
        DatabindReport report = (DatabindReport)((CompletableFuture)futureReport.thenApply(Pair::getLeft)).join();
        Assertions.assertNotNull((Object)report);
        Assertions.assertTrue((boolean)report.isSuccess());
        Assertions.assertEquals((int)2, (int)report.getProcessedItems().size());
        ((PageTemplateService)Mockito.verify((Object)this.pageTemplateService, (VerificationMode)Mockito.times((int)2))).createPageTemplate((PageTemplate)Mockito.any());
    }

    private File createZipFileWithTwoJsonFiles() throws IOException {
        File tempFile = File.createTempFile("test", ".zip");
        try (FileOutputStream fos = new FileOutputStream(tempFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            PageTemplateDatabind config1 = new PageTemplateDatabind();
            config1.setContent(JsonUtils.toJsonString((Object)new LayoutModel()));
            config1.setNames(Map.of("en", "Test Page 1"));
            config1.setDescriptions(Map.of("en", "Desc 1"));
            PageTemplateDatabind config2 = new PageTemplateDatabind();
            config2.setContent(JsonUtils.toJsonString((Object)new LayoutModel()));
            config2.setNames(Map.of("en", "Test Page 2"));
            config2.setDescriptions(Map.of("en", "Desc 2"));
            this.addJsonToZip(zos, "PageTemplate_1/config.json", JsonUtils.toJsonString((Object)config1));
            this.addJsonToZip(zos, "PageTemplate_1/layout.json", JsonUtils.toJsonString((Object)new LayoutModel()));
            this.addJsonToZip(zos, "PageTemplate_2/config.json", JsonUtils.toJsonString((Object)config2));
            this.addJsonToZip(zos, "PageTemplate_2/layout.json", JsonUtils.toJsonString((Object)new LayoutModel()));
        }
        return tempFile;
    }

    private void addJsonToZip(ZipOutputStream zos, String fileName, String jsonContent) throws IOException {
        ZipEntry entry = new ZipEntry(fileName);
        zos.putNextEntry(entry);
        zos.write(jsonContent.getBytes());
        zos.closeEntry();
    }
}

