/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.model.PortletDescriptor;
import io.meeds.layout.storage.PortletStorage;
import java.util.Collections;
import java.util.List;
import org.gatein.common.i18n.LocalizedString;
import org.gatein.common.net.media.MediaType;
import org.gatein.pc.api.Portlet;
import org.gatein.pc.api.PortletInvoker;
import org.gatein.pc.api.info.CapabilitiesInfo;
import org.gatein.pc.api.info.MetaInfo;
import org.gatein.pc.api.info.ModeInfo;
import org.gatein.pc.api.info.PortletInfo;
import org.gatein.pc.api.info.PreferencesInfo;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PortletStorage.class})
@ExtendWith(value={MockitoExtension.class})
public class PortletStorageTest {
    private static final String MODE = "edit";
    private static final String NAME = "name";
    private static final String APPLICATION_NAME = "test";
    private static final String PORTLET_NAME = "portlet";
    @MockBean
    private PortletInvoker portletInvoker;
    @Mock
    private PortletInfo portletInfo;
    @Mock
    private MetaInfo metaInfo;
    @Mock
    private Portlet portlet;
    @Mock
    private CapabilitiesInfo capabilitiesInfo;
    @Mock
    private ModeInfo modeInfo;
    @Mock
    private PreferencesInfo preferencesInfo;
    @Mock
    private LocalizedString nameLS;
    @Mock
    private LocalizedString descriptionLS;
    @Autowired
    private PortletStorage portletStorage;

    @BeforeEach
    public void init() {
        this.portletStorage.setPortletDescriptors(null);
    }

    @Test
    public void getPortletDescriptors() {
        Mockito.when((Object)this.portletInvoker.getPortlets()).thenReturn(Collections.singleton(this.portlet));
        Mockito.when((Object)this.portlet.getInfo()).thenReturn((Object)this.portletInfo);
        Mockito.when((Object)this.portletInfo.getApplicationName()).thenReturn((Object)APPLICATION_NAME);
        Mockito.when((Object)this.portletInfo.getName()).thenReturn((Object)PORTLET_NAME);
        Mockito.when((Object)this.portletInfo.getMeta()).thenReturn((Object)this.metaInfo);
        Mockito.when((Object)this.portletInfo.getCapabilities()).thenReturn((Object)this.capabilitiesInfo);
        Mockito.when((Object)this.capabilitiesInfo.getModes(MediaType.create((String)"text/html"))).thenReturn(Collections.singleton(this.modeInfo));
        Mockito.when((Object)this.modeInfo.getModeName()).thenReturn((Object)MODE);
        Mockito.when((Object)this.metaInfo.getMetaValue("display-name")).thenReturn((Object)this.nameLS);
        Mockito.when((Object)this.metaInfo.getMetaValue("description")).thenReturn((Object)this.descriptionLS);
        Mockito.when((Object)this.nameLS.getDefaultString()).thenReturn((Object)NAME);
        List portletDescriptors = this.portletStorage.getPortletDescriptors();
        Assert.assertNotNull((Object)portletDescriptors);
        Assertions.assertEquals((int)1, (int)portletDescriptors.size());
        PortletDescriptor portletDescriptor = (PortletDescriptor)portletDescriptors.get(0);
        Assertions.assertEquals((Object)APPLICATION_NAME, (Object)portletDescriptor.getApplicationName());
        Assertions.assertEquals((Object)PORTLET_NAME, (Object)portletDescriptor.getPortletName());
        Assertions.assertEquals((Object)"test/portlet", (Object)portletDescriptor.getContentId());
        Assertions.assertEquals((Object)PORTLET_NAME, (Object)portletDescriptor.getDescription());
        Assertions.assertEquals((Object)NAME, (Object)portletDescriptor.getName());
        Assertions.assertEquals(Collections.singletonList(MODE), (Object)portletDescriptor.getSupportedModes());
    }

    @Test
    public void getPortletDescriptor() {
        Mockito.when((Object)this.portletInvoker.getPortlets()).thenReturn(Collections.singleton(this.portlet));
        Mockito.when((Object)this.portlet.getInfo()).thenReturn((Object)this.portletInfo);
        Mockito.when((Object)this.portletInfo.getApplicationName()).thenReturn((Object)APPLICATION_NAME);
        Mockito.when((Object)this.portletInfo.getName()).thenReturn((Object)PORTLET_NAME);
        Mockito.when((Object)this.portletInfo.getMeta()).thenReturn((Object)this.metaInfo);
        Mockito.when((Object)this.portletInfo.getCapabilities()).thenReturn((Object)this.capabilitiesInfo);
        Mockito.when((Object)this.capabilitiesInfo.getModes(MediaType.create((String)"text/html"))).thenReturn(Collections.singleton(this.modeInfo));
        Mockito.when((Object)this.modeInfo.getModeName()).thenReturn((Object)MODE);
        Mockito.when((Object)this.metaInfo.getMetaValue("display-name")).thenReturn((Object)this.nameLS);
        Mockito.when((Object)this.metaInfo.getMetaValue("description")).thenReturn((Object)this.descriptionLS);
        Mockito.when((Object)this.nameLS.getDefaultString()).thenReturn((Object)NAME);
        PortletDescriptor portletDescriptor = this.portletStorage.getPortletDescriptor(PORTLET_NAME);
        Assertions.assertEquals((Object)APPLICATION_NAME, (Object)portletDescriptor.getApplicationName());
        Assertions.assertEquals((Object)PORTLET_NAME, (Object)portletDescriptor.getPortletName());
        Assertions.assertEquals((Object)"test/portlet", (Object)portletDescriptor.getContentId());
        Assertions.assertEquals((Object)PORTLET_NAME, (Object)portletDescriptor.getDescription());
        Assertions.assertEquals((Object)NAME, (Object)portletDescriptor.getName());
        Assertions.assertEquals(Collections.singletonList(MODE), (Object)portletDescriptor.getSupportedModes());
        Mockito.when((Object)this.portlet.isRemote()).thenReturn((Object)true);
        this.portletStorage.setPortletDescriptors(null);
        Assert.assertNull((Object)this.portletStorage.getPortletDescriptor(PORTLET_NAME));
    }
}

