/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.dao.SectionTemplateDAO;
import io.meeds.layout.entity.SectionTemplateEntity;
import io.meeds.layout.model.SectionTemplate;
import io.meeds.layout.storage.PortletStorage;
import io.meeds.layout.storage.SectionTemplateStorage;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={SectionTemplateStorage.class})
@ExtendWith(value={MockitoExtension.class})
public class SectionTemplateStorageTest {
    private static final String CONTENT = "{}";
    @MockBean
    private SectionTemplateDAO sectionTemplateDAO;
    @MockBean
    private PortletStorage portletStorage;
    @Mock
    private SectionTemplateEntity sectionTemplateEntity;
    @Mock
    private SectionTemplate sectionTemplate;
    @Autowired
    private SectionTemplateStorage sectionTemplateStorage;
    String username = "test";

    @Test
    public void getSectionTemplates() {
        Mockito.when((Object)this.sectionTemplateDAO.findAll()).thenReturn(Collections.singletonList(this.sectionTemplateEntity));
        Mockito.when((Object)this.sectionTemplateEntity.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.sectionTemplateEntity.getContent()).thenReturn((Object)CONTENT);
        Mockito.when((Object)this.sectionTemplateEntity.isSystem()).thenReturn((Object)true);
        List sectionTemplates = this.sectionTemplateStorage.getSectionTemplates();
        Assertions.assertNotNull((Object)sectionTemplates);
        Assertions.assertEquals((int)1, (int)sectionTemplates.size());
        Assertions.assertEquals((Long)this.sectionTemplateEntity.getId(), (long)((SectionTemplate)sectionTemplates.get(0)).getId());
        Assertions.assertEquals((Object)this.sectionTemplateEntity.getContent(), (Object)((SectionTemplate)sectionTemplates.get(0)).getContent());
        Assertions.assertEquals((Object)this.sectionTemplateEntity.isSystem(), (Object)((SectionTemplate)sectionTemplates.get(0)).isSystem());
    }

    @Test
    public void getSectionTemplate() {
        Mockito.when((Object)this.sectionTemplateDAO.findById((Object)2L)).thenReturn(Optional.of(this.sectionTemplateEntity));
        Mockito.when((Object)this.sectionTemplateEntity.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.sectionTemplateEntity.getContent()).thenReturn((Object)CONTENT);
        SectionTemplate retrievedSectionTemplate = this.sectionTemplateStorage.getSectionTemplate(2L);
        Assertions.assertEquals((Long)this.sectionTemplateEntity.getId(), (long)retrievedSectionTemplate.getId());
        Assertions.assertEquals((Object)this.sectionTemplateEntity.getContent(), (Object)retrievedSectionTemplate.getContent());
    }

    @Test
    public void createSectionTemplate() {
        Mockito.when((Object)this.sectionTemplate.getContent()).thenReturn((Object)CONTENT);
        Mockito.when((Object)((SectionTemplateEntity)this.sectionTemplateDAO.save((Object)((SectionTemplateEntity)ArgumentMatchers.any(SectionTemplateEntity.class))))).thenAnswer(invocation -> {
            SectionTemplateEntity entity = (SectionTemplateEntity)invocation.getArgument(0);
            entity.setId(Long.valueOf(2L));
            return entity;
        });
        SectionTemplate createdSectionTemplate = this.sectionTemplateStorage.createSectionTemplate(this.sectionTemplate);
        Assertions.assertNotNull((Object)createdSectionTemplate);
        Assertions.assertEquals((long)2L, (long)createdSectionTemplate.getId());
        Assertions.assertEquals((Object)this.sectionTemplate.getContent(), (Object)createdSectionTemplate.getContent());
    }

    @Test
    public void updateSectionTemplate() throws ObjectNotFoundException {
        Mockito.when((Object)this.sectionTemplate.getContent()).thenReturn((Object)CONTENT);
        Mockito.when((Object)((SectionTemplateEntity)this.sectionTemplateDAO.save((Object)((SectionTemplateEntity)ArgumentMatchers.any(SectionTemplateEntity.class))))).thenAnswer(invocation -> invocation.getArgument(0));
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.sectionTemplateStorage.updateSectionTemplate(this.sectionTemplate));
        Mockito.when((Object)this.sectionTemplate.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.sectionTemplate.getContent()).thenReturn((Object)CONTENT);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.sectionTemplateStorage.updateSectionTemplate(this.sectionTemplate));
        Mockito.when((Object)this.sectionTemplateDAO.existsById((Object)this.sectionTemplate.getId())).thenReturn((Object)true);
        SectionTemplate updatedSectionTemplate = this.sectionTemplateStorage.updateSectionTemplate(this.sectionTemplate);
        Assertions.assertNotNull((Object)updatedSectionTemplate);
        Assertions.assertEquals((long)this.sectionTemplate.getId(), (long)updatedSectionTemplate.getId());
        Assertions.assertEquals((Object)this.sectionTemplate.getContent(), (Object)updatedSectionTemplate.getContent());
    }

    @Test
    public void deleteSectionTemplate() throws ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.sectionTemplateStorage.deleteSectionTemplate(2L));
        Mockito.when((Object)this.sectionTemplateDAO.existsById((Object)2L)).thenReturn((Object)true);
        this.sectionTemplateStorage.deleteSectionTemplate(2L);
        ((SectionTemplateDAO)Mockito.verify((Object)this.sectionTemplateDAO, (VerificationMode)Mockito.times((int)1))).deleteById((Object)2L);
    }
}

