/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.attachment;

import io.meeds.layout.plugin.attachment.CmsPortletAttachmentPlugin;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PortletInstanceService;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={CmsPortletAttachmentPlugin.class})
@ExtendWith(value={MockitoExtension.class})
class CmsPortletAttachmentPluginTest {
    @MockBean
    private AttachmentService attachmentService;
    @MockBean
    private LayoutAclService layoutAclService;
    @MockBean
    private PortletInstanceService portletInstanceService;
    @Autowired
    private CmsPortletAttachmentPlugin attachmentPlugin;
    @Mock
    private Identity userIdentity;

    CmsPortletAttachmentPluginTest() {
    }

    @Test
    void getObjectType() {
        Assertions.assertEquals((Object)"cmsPortlet", (Object)this.attachmentPlugin.getObjectType());
        Assertions.assertEquals((Object)"cmsPortlet", (Object)this.attachmentPlugin.getObjectType());
    }

    @Test
    void hasEditPermission() {
        Assertions.assertFalse((boolean)this.attachmentPlugin.hasEditPermission(null, null));
        Assertions.assertFalse((boolean)this.attachmentPlugin.hasEditPermission(this.userIdentity, null));
        Mockito.when((Object)this.userIdentity.getUserId()).thenReturn((Object)"test");
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.userIdentity.getUserId())).thenReturn((Object)true);
        Assertions.assertTrue((boolean)this.attachmentPlugin.hasEditPermission(this.userIdentity, null));
    }

    @Test
    void hasAccessPermission() {
        Assertions.assertTrue((boolean)this.attachmentPlugin.hasAccessPermission(this.userIdentity, null));
    }

    @Test
    void getAudienceId() {
        Assertions.assertEquals((long)0L, (long)this.attachmentPlugin.getAudienceId(null));
    }

    @Test
    void getSpaceId() {
        Assertions.assertEquals((long)0L, (long)this.attachmentPlugin.getSpaceId(""));
    }
}

