/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.renderer;

import io.meeds.layout.model.PortletInstanceContext;
import io.meeds.layout.model.PortletInstancePreference;
import io.meeds.layout.plugin.renderer.LoginFormPortletInstancePreferencePlugin;
import io.meeds.social.translation.service.TranslationService;
import java.util.HashMap;
import java.util.List;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.pom.spi.portlet.Portlet;
import org.exoplatform.portal.pom.spi.portlet.Preference;
import org.exoplatform.social.attachment.AttachmentService;
import org.junit.Assert;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={LoginFormPortletInstancePreferencePlugin.class})
@ExtendWith(value={MockitoExtension.class})
public class LoginFormPortletInstancePreferencePluginTest {
    private static final String OTHER_PREF_NAME = "name2";
    private static final String SETTING_NAME = "name";
    private static final String DATA_INIT_PREFERENCE_NAME = "data.init";
    @Autowired
    private LoginFormPortletInstancePreferencePlugin loginFormPortletInstancePreferencePlugin;
    @MockBean
    private TranslationService translationService;
    @MockBean
    private FileService fileService;
    @MockBean
    private AttachmentService attachmentService;

    @BeforeEach
    public void setup() {
        Mockito.lenient().when((Object)this.translationService.getAllTranslationFields((String)ArgumentMatchers.any(), (String)ArgumentMatchers.any())).thenReturn(new HashMap());
    }

    @Test
    void getPortletName() {
        Assertions.assertEquals((Object)"LoginForm", (Object)this.loginFormPortletInstancePreferencePlugin.getPortletName());
    }

    @Test
    void generatePreferences() {
        HashMap<String, Preference> map = new HashMap<String, Preference>();
        map.put(SETTING_NAME, new Preference(SETTING_NAME, "value", false));
        map.put(OTHER_PREF_NAME, new Preference(OTHER_PREF_NAME, "value", false));
        Portlet preferences = new Portlet(map);
        List generatedPreferences = this.loginFormPortletInstancePreferencePlugin.generatePreferences(null, preferences, new PortletInstanceContext());
        Assert.assertNotNull((Object)generatedPreferences);
        Assertions.assertEquals((int)2, (int)generatedPreferences.size());
        Assertions.assertEquals((Object)DATA_INIT_PREFERENCE_NAME, (Object)((PortletInstancePreference)generatedPreferences.get(1)).getName());
    }

    @Test
    void generatePreferencesWithComputeForExport() {
        HashMap<String, Preference> map = new HashMap<String, Preference>();
        map.put(SETTING_NAME, new Preference(SETTING_NAME, "value", false));
        map.put(OTHER_PREF_NAME, new Preference(OTHER_PREF_NAME, "value", false));
        PortletInstanceContext portletInstanceContext = (PortletInstanceContext)Mockito.mock(PortletInstanceContext.class);
        Mockito.when((Object)portletInstanceContext.isExport()).thenReturn((Object)true);
        Portlet preferences = new Portlet(map);
        List generatedPreferences = this.loginFormPortletInstancePreferencePlugin.generatePreferences(null, preferences, portletInstanceContext);
        Assert.assertNotNull((Object)generatedPreferences);
        Assertions.assertEquals((int)1, (int)generatedPreferences.size());
        Assertions.assertEquals((Object)OTHER_PREF_NAME, (Object)((PortletInstancePreference)generatedPreferences.get(0)).getName());
    }
}

