/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin;

import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.plugin.PortletInstanceDatabindPlugin;
import io.meeds.layout.service.PortletInstanceService;
import io.meeds.social.databind.model.DatabindReport;
import io.meeds.social.databind.service.DatabindService;
import io.meeds.social.translation.service.TranslationService;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.tuple.Pair;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.file.services.FileService;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.attachment.AttachmentService;
import org.exoplatform.social.core.manager.IdentityManager;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PortletInstanceDatabindPlugin.class})
@ExtendWith(value={MockitoExtension.class})
class PortletInstanceDatabindPluginTest {
    @Mock
    private Identity userIdentity;
    @MockBean
    private PortletInstanceService portletInstanceService;
    @MockBean
    private DatabindService databindService;
    @MockBean
    private FileService fileService;
    @MockBean
    private TranslationService translationService;
    @MockBean
    private AttachmentService attachmentService;
    @MockBean
    private UserACL userAcl;
    @MockBean
    private IdentityManager identityManager;
    @Autowired
    private PortletInstanceDatabindPlugin portletInstanceDatabindPlugin;

    PortletInstanceDatabindPluginTest() {
    }

    @Test
    void getObjectType() {
        Assertions.assertEquals((Object)"PortletInstance", (Object)this.portletInstanceDatabindPlugin.getObjectType());
    }

    @Test
    void canHandleDatabind() {
        Assertions.assertTrue((boolean)this.portletInstanceDatabindPlugin.canHandleDatabind("PortletInstance", "1"));
        Assertions.assertFalse((boolean)this.portletInstanceDatabindPlugin.canHandleDatabind("ObjectInstance", "1"));
    }

    @Test
    void serialize() throws ObjectNotFoundException, IllegalAccessException {
        ZipOutputStream zipOutputStream = (ZipOutputStream)Mockito.mock(ZipOutputStream.class);
        PortletInstance portletInstance = (PortletInstance)Mockito.mock(PortletInstance.class);
        Mockito.when((Object)this.portletInstanceService.getPortletInstance(ArgumentMatchers.anyLong(), Mockito.anyString(), (Locale)Mockito.any(Locale.class), Mockito.anyBoolean())).thenReturn((Object)portletInstance);
        Mockito.when((Object)portletInstance.getContentId()).thenReturn((Object)"1");
        this.portletInstanceDatabindPlugin.serialize("1", zipOutputStream, "root");
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService, (VerificationMode)Mockito.times((int)1))).getPortletInstance(1L, "root", Locale.getDefault(), true);
    }

    @Test
    void deserialize() throws Exception {
        File zipFile = this.createZipFileWithTwoJsonFiles();
        Mockito.when((Object)this.portletInstanceService.createPortletInstance((PortletInstance)Mockito.any())).thenReturn((Object)new PortletInstance());
        CompletableFuture futureReport = this.portletInstanceDatabindPlugin.deserialize(zipFile, Map.of("categoryId", "1"), "admin");
        DatabindReport report = (DatabindReport)((CompletableFuture)futureReport.thenApply(Pair::getLeft)).join();
        Assertions.assertNotNull((Object)report);
        Assertions.assertTrue((boolean)report.isSuccess());
        Assertions.assertEquals((int)2, (int)report.getProcessedItems().size());
        Assertions.assertTrue((boolean)report.getProcessedItems().contains("12345"));
        Assertions.assertTrue((boolean)report.getProcessedItems().contains("67890"));
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService, (VerificationMode)Mockito.times((int)2))).createPortletInstance((PortletInstance)Mockito.any());
    }

    private File createZipFileWithTwoJsonFiles() throws IOException {
        File tempFile = File.createTempFile("test", ".zip");
        try (FileOutputStream fos = new FileOutputStream(tempFile);
             ZipOutputStream zos = new ZipOutputStream(fos);){
            this.addJsonToZip(zos, "instance1.json", "{\"contentId\":\"12345\",\"names\":{\"en\":\"Test Instance 1\"},\"descriptions\":{\"en\":\"Desc 1\"}}");
            this.addJsonToZip(zos, "instance2.json", "{\"contentId\":\"67890\",\"names\":{\"en\":\"Test Instance 2\"},\"descriptions\":{\"en\":\"Desc 2\"}}");
        }
        return tempFile;
    }

    private void addJsonToZip(ZipOutputStream zos, String fileName, String jsonContent) throws IOException {
        ZipEntry entry = new ZipEntry(fileName);
        zos.putNextEntry(entry);
        zos.write(jsonContent.getBytes());
        zos.closeEntry();
    }
}

