/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.service;

import io.meeds.layout.model.PageTemplate;
import io.meeds.layout.service.LayoutAclService;
import io.meeds.layout.service.PageTemplateService;
import io.meeds.layout.storage.PageTemplateStorage;
import io.meeds.social.translation.model.TranslationField;
import io.meeds.social.translation.service.TranslationService;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.LocaleConfigService;
import org.exoplatform.social.attachment.AttachmentService;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PageTemplateService.class})
@ExtendWith(value={MockitoExtension.class})
public class PageTemplateServiceTest {
    private static final String LAYOUT_CONTENT = "...layout...";
    private static final String LAYOUT_CATEGORY = "CATEGORY";
    @MockBean
    private LayoutAclService layoutAclService;
    @MockBean
    private TranslationService translationService;
    @MockBean
    private AttachmentService attachmentService;
    @MockBean
    private LocaleConfigService localeConfigService;
    @MockBean
    private PageTemplateStorage pageTemplateStorage;
    @Mock
    private PageTemplate pageTemplate;
    @Mock
    private LocaleConfig defaultLocaleConfig;
    @Mock
    private LocaleConfig localeConfig;
    @Autowired
    private PageTemplateService pageTemplateService;
    private String testuser = "testuser";

    @Test
    public void getPageTemplates() {
        Mockito.when((Object)this.pageTemplate.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.pageTemplate.getContent()).thenReturn((Object)LAYOUT_CONTENT);
        Mockito.when((Object)this.pageTemplateStorage.getPageTemplates()).thenReturn(Collections.singletonList(this.pageTemplate));
        List pageTemplates = this.pageTemplateService.getPageTemplates();
        Assertions.assertNotNull((Object)pageTemplates);
        Assertions.assertEquals((int)1, (int)pageTemplates.size());
        Assertions.assertEquals((long)this.pageTemplate.getId(), (long)((PageTemplate)pageTemplates.get(0)).getId());
        Assertions.assertEquals((Object)this.pageTemplate.getContent(), (Object)((PageTemplate)pageTemplates.get(0)).getContent());
        Assertions.assertNull((Object)((PageTemplate)pageTemplates.get(0)).getName());
        Assertions.assertNull((Object)((PageTemplate)pageTemplates.get(0)).getDescription());
        Assertions.assertEquals((long)0L, (long)((PageTemplate)pageTemplates.get(0)).getIllustrationId());
    }

    @Test
    public void getPageTemplatesWithExpand() throws ObjectNotFoundException {
        PageTemplate template = new PageTemplate(2L, false, false, LAYOUT_CATEGORY, LAYOUT_CONTENT);
        Mockito.when((Object)this.localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.defaultLocaleConfig);
        Mockito.when((Object)this.defaultLocaleConfig.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.pageTemplateStorage.getPageTemplates()).thenReturn(Collections.singletonList(template));
        List pageTemplates = this.pageTemplateService.getPageTemplates(true);
        Assertions.assertNotNull((Object)pageTemplates);
        Assertions.assertEquals((int)1, (int)pageTemplates.size());
        Assertions.assertEquals((long)template.getId(), (long)((PageTemplate)pageTemplates.get(0)).getId());
        Assertions.assertEquals((Object)template.getContent(), (Object)((PageTemplate)pageTemplates.get(0)).getContent());
        Assertions.assertNull((Object)((PageTemplate)pageTemplates.get(0)).getName());
        Assertions.assertNull((Object)((PageTemplate)pageTemplates.get(0)).getDescription());
        Assertions.assertEquals((long)0L, (long)((PageTemplate)pageTemplates.get(0)).getIllustrationId());
        Mockito.when((Object)this.translationService.getTranslationField("pageTemplate", template.getId(), "title")).thenThrow(ObjectNotFoundException.class);
        pageTemplates = this.pageTemplateService.getPageTemplates(true);
        Assertions.assertNotNull((Object)pageTemplates);
        Assertions.assertEquals((int)1, (int)pageTemplates.size());
        Mockito.reset((Object[])new TranslationService[]{this.translationService});
        TranslationField titleTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("pageTemplate", template.getId(), "title")).thenReturn((Object)titleTranslationField);
        pageTemplates = this.pageTemplateService.getPageTemplates(true);
        Assertions.assertNotNull((Object)pageTemplates);
        Assertions.assertEquals((int)1, (int)pageTemplates.size());
        Assertions.assertEquals((long)template.getId(), (long)((PageTemplate)pageTemplates.get(0)).getId());
        Assertions.assertEquals((Object)template.getContent(), (Object)((PageTemplate)pageTemplates.get(0)).getContent());
        Assertions.assertNull((Object)((PageTemplate)pageTemplates.get(0)).getName());
        Assertions.assertNull((Object)((PageTemplate)pageTemplates.get(0)).getDescription());
        Assertions.assertEquals((long)0L, (long)((PageTemplate)pageTemplates.get(0)).getIllustrationId());
        String frTitle = "testTitle";
        Mockito.when((Object)titleTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.FRENCH, frTitle));
        pageTemplates = this.pageTemplateService.getPageTemplates(true);
        Assertions.assertNotNull((Object)pageTemplates);
        Assertions.assertEquals((int)1, (int)pageTemplates.size());
        Assertions.assertEquals((Object)frTitle, (Object)((PageTemplate)pageTemplates.get(0)).getName());
        TranslationField descriptionTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("pageTemplate", template.getId(), "description")).thenReturn((Object)descriptionTranslationField);
        String enDesc = "testDescription";
        Mockito.when((Object)descriptionTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.ENGLISH, enDesc));
        pageTemplates = this.pageTemplateService.getPageTemplates(true);
        Assertions.assertNotNull((Object)pageTemplates);
        Assertions.assertEquals((int)1, (int)pageTemplates.size());
        Assertions.assertEquals((Object)enDesc, (Object)((PageTemplate)pageTemplates.get(0)).getDescription());
        Mockito.when((Object)this.attachmentService.getAttachmentFileIds("pageTemplate", "2")).thenReturn(Collections.singletonList("32"));
        pageTemplates = this.pageTemplateService.getPageTemplates(Locale.GERMAN, true);
        Assertions.assertNotNull((Object)pageTemplates);
        Assertions.assertEquals((int)1, (int)pageTemplates.size());
        Assertions.assertEquals((long)32L, (long)((PageTemplate)pageTemplates.get(0)).getIllustrationId());
    }

    @Test
    public void getPageTemplateWithExpand() throws ObjectNotFoundException {
        PageTemplate template = new PageTemplate(2L, false, false, LAYOUT_CATEGORY, LAYOUT_CONTENT);
        Mockito.when((Object)this.localeConfigService.getDefaultLocaleConfig()).thenReturn((Object)this.defaultLocaleConfig);
        Mockito.when((Object)this.defaultLocaleConfig.getLocale()).thenReturn((Object)Locale.ENGLISH);
        Mockito.when((Object)this.pageTemplateStorage.getPageTemplate(2L)).thenReturn((Object)template);
        PageTemplate retrievedPageTemplate = this.pageTemplateService.getPageTemplate(2L);
        Assertions.assertNotNull((Object)retrievedPageTemplate);
        Assertions.assertEquals((long)template.getId(), (long)retrievedPageTemplate.getId());
        Assertions.assertEquals((Object)template.getContent(), (Object)retrievedPageTemplate.getContent());
        Assertions.assertNull((Object)retrievedPageTemplate.getName());
        Assertions.assertNull((Object)retrievedPageTemplate.getDescription());
        Assertions.assertEquals((long)0L, (long)retrievedPageTemplate.getIllustrationId());
        Mockito.when((Object)this.translationService.getTranslationField("pageTemplate", template.getId(), "title")).thenThrow(ObjectNotFoundException.class);
        retrievedPageTemplate = this.pageTemplateService.getPageTemplate(2L, Locale.FRENCH, true, true);
        Assertions.assertNotNull((Object)retrievedPageTemplate);
        Mockito.reset((Object[])new TranslationService[]{this.translationService});
        TranslationField titleTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("pageTemplate", template.getId(), "title")).thenReturn((Object)titleTranslationField);
        retrievedPageTemplate = this.pageTemplateService.getPageTemplate(2L, Locale.FRENCH, true);
        Assertions.assertNotNull((Object)retrievedPageTemplate);
        Assertions.assertEquals((long)template.getId(), (long)retrievedPageTemplate.getId());
        Assertions.assertEquals((Object)template.getContent(), (Object)retrievedPageTemplate.getContent());
        Assertions.assertNull((Object)retrievedPageTemplate.getName());
        Assertions.assertNull((Object)retrievedPageTemplate.getDescription());
        Assertions.assertEquals((long)0L, (long)retrievedPageTemplate.getIllustrationId());
        String frTitle = "testTitle";
        Mockito.when((Object)titleTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.FRENCH, frTitle));
        retrievedPageTemplate = this.pageTemplateService.getPageTemplate(2L, Locale.FRENCH, true);
        Assertions.assertEquals((Object)frTitle, (Object)retrievedPageTemplate.getName());
        TranslationField descriptionTranslationField = (TranslationField)Mockito.mock(TranslationField.class);
        Mockito.when((Object)this.translationService.getTranslationField("pageTemplate", template.getId(), "description")).thenReturn((Object)descriptionTranslationField);
        String enDesc = "testDescription";
        Mockito.when((Object)descriptionTranslationField.getLabels()).thenReturn(Collections.singletonMap(Locale.ENGLISH, enDesc));
        retrievedPageTemplate = this.pageTemplateService.getPageTemplate(2L, Locale.ENGLISH, true);
        Assertions.assertNotNull((Object)retrievedPageTemplate);
        Assertions.assertEquals((Object)enDesc, (Object)retrievedPageTemplate.getDescription());
        Mockito.when((Object)this.attachmentService.getAttachmentFileIds("pageTemplate", "2")).thenReturn(Collections.singletonList("32"));
        retrievedPageTemplate = this.pageTemplateService.getPageTemplate(2L, Locale.GERMAN, true);
        Assertions.assertNotNull((Object)retrievedPageTemplate);
        Assertions.assertEquals((long)32L, (long)retrievedPageTemplate.getIllustrationId());
    }

    @Test
    public void getPageTemplate() {
        Mockito.when((Object)this.pageTemplateStorage.getPageTemplate(2L)).thenReturn((Object)this.pageTemplate);
        PageTemplate retrievedPageTemplate = this.pageTemplateService.getPageTemplate(3L);
        Assertions.assertNull((Object)retrievedPageTemplate);
        retrievedPageTemplate = this.pageTemplateService.getPageTemplate(2L);
        Assertions.assertNotNull((Object)retrievedPageTemplate);
        Assertions.assertEquals((Object)this.pageTemplate, (Object)retrievedPageTemplate);
    }

    @Test
    public void createPageTemplate() throws IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageTemplateService.createPageTemplate(this.pageTemplate, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        this.pageTemplateService.createPageTemplate(this.pageTemplate, this.testuser);
        ((PageTemplateStorage)Mockito.verify((Object)this.pageTemplateStorage, (VerificationMode)Mockito.times((int)1))).createPageTemplate(this.pageTemplate);
    }

    @Test
    public void deletePageTemplate() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageTemplateService.deletePageTemplate(2L, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.pageTemplateService.deletePageTemplate(2L, this.testuser));
        Mockito.when((Object)this.pageTemplateStorage.getPageTemplate(2L)).thenReturn((Object)this.pageTemplate);
        Mockito.when((Object)this.pageTemplate.isSystem()).thenReturn((Object)true);
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageTemplateService.deletePageTemplate(2L, this.testuser));
        Mockito.when((Object)this.pageTemplate.isSystem()).thenReturn((Object)false);
        this.pageTemplateService.deletePageTemplate(2L, this.testuser);
        ((AttachmentService)Mockito.verify((Object)this.attachmentService, (VerificationMode)Mockito.times((int)1))).deleteAttachments("pageTemplate", "2");
        ((TranslationService)Mockito.verify((Object)this.translationService, (VerificationMode)Mockito.times((int)1))).deleteTranslationLabels("pageTemplate", 2L);
        ((PageTemplateStorage)Mockito.verify((Object)this.pageTemplateStorage, (VerificationMode)Mockito.times((int)1))).deletePageTemplate(2L);
    }

    @Test
    public void deletePageTemplateWhenException() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageTemplateService.deletePageTemplate(2L, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        Mockito.when((Object)this.pageTemplateStorage.getPageTemplate(2L)).thenReturn((Object)this.pageTemplate);
        ((AttachmentService)Mockito.doThrow(RuntimeException.class).when((Object)this.attachmentService)).deleteAttachments(ArgumentMatchers.anyString(), (String)ArgumentMatchers.any());
        ((TranslationService)Mockito.doThrow(ObjectNotFoundException.class).when((Object)this.translationService)).deleteTranslationLabels(ArgumentMatchers.anyString(), ArgumentMatchers.anyLong());
        this.pageTemplateService.deletePageTemplate(2L, this.testuser);
        ((PageTemplateStorage)Mockito.verify((Object)this.pageTemplateStorage, (VerificationMode)Mockito.times((int)1))).deletePageTemplate(2L);
    }

    @Test
    public void updatePageTemplate() throws ObjectNotFoundException, IllegalAccessException {
        Assertions.assertThrows(IllegalAccessException.class, () -> this.pageTemplateService.updatePageTemplate(this.pageTemplate, this.testuser));
        Mockito.when((Object)this.layoutAclService.isAdministrator(this.testuser)).thenReturn((Object)true);
        this.pageTemplateService.updatePageTemplate(this.pageTemplate, this.testuser);
        ((PageTemplateStorage)Mockito.verify((Object)this.pageTemplateStorage, (VerificationMode)Mockito.times((int)1))).updatePageTemplate(this.pageTemplate);
    }
}

