/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.plugin.upgrade;

import io.meeds.layout.model.ApplicationReferenceUpgrade;
import io.meeds.layout.model.PortletInstance;
import io.meeds.layout.plugin.upgrade.LayoutApplicationReferenceUpgradePlugin;
import io.meeds.layout.service.PortletInstanceService;
import java.io.Serializable;
import java.util.Collections;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.portal.mop.dao.WindowDAO;
import org.exoplatform.services.cache.CacheService;
import org.exoplatform.services.cache.ExoCache;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;

@ExtendWith(value={MockitoExtension.class})
public class LayoutApplicationReferenceUpgradePluginTest {
    @Mock
    private CacheService cacheService;
    @Mock
    private SettingService settingService;
    @Mock
    private PortletInstanceService portletInstanceService;
    @Mock
    private WindowDAO windowDAO;
    @Mock
    private InitParams initParams;
    @Mock
    private ApplicationReferenceUpgrade applicationModification;
    @Mock
    private PortletInstance portletInstance;
    @Mock
    private ExoCache<Serializable, Object> portletPreferencesCache;
    private String oldContentId = "oldApp/oldContentId";
    private String newContentId = "newApp/newContentId";

    @BeforeEach
    public void before() {
        Mockito.when((Object)this.cacheService.getCacheInstance("portal.PortletPreferences")).thenReturn(this.portletPreferencesCache);
    }

    @Test
    public void processUpgradeWithModification() {
        Mockito.when((Object)this.initParams.getObjectParamValues(ApplicationReferenceUpgrade.class)).thenReturn(Collections.singletonList(this.applicationModification));
        Mockito.when((Object)this.portletInstanceService.getPortletInstances()).thenReturn(Collections.singletonList(this.portletInstance));
        Mockito.when((Object)this.portletInstance.getContentId()).thenReturn((Object)this.oldContentId);
        Mockito.when((Object)this.applicationModification.isModification()).thenReturn((Object)true);
        Mockito.when((Object)this.applicationModification.getOldContentId()).thenReturn((Object)this.oldContentId);
        Mockito.when((Object)this.applicationModification.getNewContentId()).thenReturn((Object)this.newContentId);
        Mockito.when((Object)this.applicationModification.isUpgradePages()).thenReturn((Object)true);
        Mockito.when((Object)this.applicationModification.isUpgradePortletInstance()).thenReturn((Object)true);
        LayoutApplicationReferenceUpgradePlugin applicationReferenceUpgradePlugin = new LayoutApplicationReferenceUpgradePlugin(this.cacheService, this.settingService, this.portletInstanceService, this.windowDAO, this.initParams);
        Assertions.assertTrue((boolean)applicationReferenceUpgradePlugin.shouldProceedToUpgrade(null, null));
        applicationReferenceUpgradePlugin.processUpgrade(null, null);
        ((WindowDAO)Mockito.verify((Object)this.windowDAO)).updateContentId(this.oldContentId, this.newContentId);
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService)).updatePortletInstance(this.portletInstance);
        ((ExoCache)Mockito.verify(this.portletPreferencesCache)).clearCache();
    }

    @Test
    public void processUpgradeWithRemoval() {
        Mockito.when((Object)this.initParams.getObjectParamValues(ApplicationReferenceUpgrade.class)).thenReturn(Collections.singletonList(this.applicationModification));
        Mockito.when((Object)this.portletInstanceService.getPortletInstances()).thenReturn(Collections.singletonList(this.portletInstance));
        Mockito.when((Object)this.portletInstance.getContentId()).thenReturn((Object)this.oldContentId);
        Mockito.when((Object)this.applicationModification.isRemoval()).thenReturn((Object)true);
        Mockito.when((Object)this.applicationModification.getOldContentId()).thenReturn((Object)this.oldContentId);
        Mockito.when((Object)this.applicationModification.getNewContentId()).thenReturn((Object)this.newContentId);
        Mockito.when((Object)this.applicationModification.isUpgradePages()).thenReturn((Object)true);
        Mockito.when((Object)this.applicationModification.isUpgradePortletInstance()).thenReturn((Object)true);
        Mockito.when((Object)this.portletInstance.getId()).thenReturn((Object)2L);
        LayoutApplicationReferenceUpgradePlugin applicationReferenceUpgradePlugin = new LayoutApplicationReferenceUpgradePlugin(this.cacheService, this.settingService, this.portletInstanceService, this.windowDAO, this.initParams);
        Assertions.assertTrue((boolean)applicationReferenceUpgradePlugin.shouldProceedToUpgrade(null, null));
        applicationReferenceUpgradePlugin.processUpgrade(null, null);
        ((WindowDAO)Mockito.verify((Object)this.windowDAO)).deleteByContentId(this.oldContentId);
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService)).deletePortletInstance(2L);
        ((ExoCache)Mockito.verify(this.portletPreferencesCache)).clearCache();
    }

    @Test
    public void processUpgradeWithModificationIgnoreAll() {
        Mockito.when((Object)this.initParams.getObjectParamValues(ApplicationReferenceUpgrade.class)).thenReturn(Collections.singletonList(this.applicationModification));
        Mockito.when((Object)this.portletInstanceService.getPortletInstances()).thenReturn(Collections.singletonList(this.portletInstance));
        Mockito.when((Object)this.applicationModification.isModification()).thenReturn((Object)true);
        Mockito.when((Object)this.applicationModification.getOldContentId()).thenReturn((Object)this.oldContentId);
        Mockito.when((Object)this.applicationModification.getNewContentId()).thenReturn((Object)this.newContentId);
        LayoutApplicationReferenceUpgradePlugin applicationReferenceUpgradePlugin = new LayoutApplicationReferenceUpgradePlugin(this.cacheService, this.settingService, this.portletInstanceService, this.windowDAO, this.initParams);
        Assertions.assertTrue((boolean)applicationReferenceUpgradePlugin.shouldProceedToUpgrade(null, null));
        applicationReferenceUpgradePlugin.processUpgrade(null, null);
        ((WindowDAO)Mockito.verify((Object)this.windowDAO, (VerificationMode)Mockito.never())).updateContentId(this.oldContentId, this.newContentId);
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService, (VerificationMode)Mockito.never())).updatePortletInstance(this.portletInstance);
        ((ExoCache)Mockito.verify(this.portletPreferencesCache)).clearCache();
    }

    @Test
    public void processUpgradeWithRemovalIgnoreAll() {
        Mockito.when((Object)this.initParams.getObjectParamValues(ApplicationReferenceUpgrade.class)).thenReturn(Collections.singletonList(this.applicationModification));
        Mockito.when((Object)this.portletInstanceService.getPortletInstances()).thenReturn(Collections.singletonList(this.portletInstance));
        Mockito.when((Object)this.applicationModification.isRemoval()).thenReturn((Object)true);
        Mockito.when((Object)this.applicationModification.getOldContentId()).thenReturn((Object)this.oldContentId);
        Mockito.when((Object)this.applicationModification.getNewContentId()).thenReturn((Object)this.newContentId);
        LayoutApplicationReferenceUpgradePlugin applicationReferenceUpgradePlugin = new LayoutApplicationReferenceUpgradePlugin(this.cacheService, this.settingService, this.portletInstanceService, this.windowDAO, this.initParams);
        Assertions.assertTrue((boolean)applicationReferenceUpgradePlugin.shouldProceedToUpgrade(null, null));
        applicationReferenceUpgradePlugin.processUpgrade(null, null);
        ((WindowDAO)Mockito.verify((Object)this.windowDAO, (VerificationMode)Mockito.never())).deleteByContentId(this.oldContentId);
        ((PortletInstanceService)Mockito.verify((Object)this.portletInstanceService, (VerificationMode)Mockito.never())).deletePortletInstance(2L);
        ((ExoCache)Mockito.verify(this.portletPreferencesCache)).clearCache();
    }
}

