/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.layout.storage;

import io.meeds.layout.dao.PortletInstanceCategoryDAO;
import io.meeds.layout.entity.PortletInstanceCategoryEntity;
import io.meeds.layout.model.PortletInstanceCategory;
import io.meeds.layout.storage.PortletInstanceCategoryStorage;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.Test;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.jupiter.MockitoExtension;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.boot.test.mock.mockito.MockBean;

@SpringBootTest(classes={PortletInstanceCategoryStorage.class})
@ExtendWith(value={MockitoExtension.class})
public class PortletInstanceCategoryStorageTest {
    private static final String ICON = "icon";
    @MockBean
    private PortletInstanceCategoryDAO portletInstanceCategoryDAO;
    @Mock
    private PortletInstanceCategoryEntity portletInstanceCategoryEntity;
    @Mock
    private PortletInstanceCategory portletInstanceCategory;
    @Autowired
    private PortletInstanceCategoryStorage portletInstanceCategoryStorage;
    String username = "test";

    @Test
    public void getPortletInstanceCategories() {
        Mockito.when((Object)this.portletInstanceCategoryDAO.findAll()).thenReturn(Collections.singletonList(this.portletInstanceCategoryEntity));
        Mockito.when((Object)this.portletInstanceCategoryEntity.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.portletInstanceCategoryEntity.getIcon()).thenReturn((Object)ICON);
        Mockito.when((Object)this.portletInstanceCategoryEntity.isSystem()).thenReturn((Object)true);
        Mockito.when((Object)this.portletInstanceCategoryEntity.getPermissions()).thenReturn(Collections.singletonList("permissions"));
        List portletInstanceCategories = this.portletInstanceCategoryStorage.getPortletInstanceCategories();
        Assertions.assertNotNull((Object)portletInstanceCategories);
        Assertions.assertEquals((int)1, (int)portletInstanceCategories.size());
        Assertions.assertEquals((Long)this.portletInstanceCategoryEntity.getId(), (long)((PortletInstanceCategory)portletInstanceCategories.get(0)).getId());
        Assertions.assertEquals((Object)this.portletInstanceCategoryEntity.getIcon(), (Object)((PortletInstanceCategory)portletInstanceCategories.get(0)).getIcon());
        Assertions.assertEquals((Object)this.portletInstanceCategoryEntity.getPermissions(), (Object)((PortletInstanceCategory)portletInstanceCategories.get(0)).getPermissions());
        Assertions.assertEquals((Object)this.portletInstanceCategoryEntity.isSystem(), (Object)((PortletInstanceCategory)portletInstanceCategories.get(0)).isSystem());
    }

    @Test
    public void getPortletInstanceCategory() {
        Mockito.when((Object)this.portletInstanceCategoryDAO.findById((Object)2L)).thenReturn(Optional.of(this.portletInstanceCategoryEntity));
        Mockito.when((Object)this.portletInstanceCategoryEntity.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.portletInstanceCategoryEntity.getIcon()).thenReturn((Object)ICON);
        PortletInstanceCategory retrievedPortletInstanceCategory = this.portletInstanceCategoryStorage.getPortletInstanceCategory(2L);
        Assertions.assertEquals((Long)this.portletInstanceCategoryEntity.getId(), (long)retrievedPortletInstanceCategory.getId());
        Assertions.assertEquals((Object)this.portletInstanceCategoryEntity.getIcon(), (Object)retrievedPortletInstanceCategory.getIcon());
    }

    @Test
    public void createPortletInstanceCategory() {
        Mockito.when((Object)this.portletInstanceCategory.getIcon()).thenReturn((Object)ICON);
        Mockito.when((Object)((PortletInstanceCategoryEntity)this.portletInstanceCategoryDAO.save((Object)((PortletInstanceCategoryEntity)ArgumentMatchers.any(PortletInstanceCategoryEntity.class))))).thenAnswer(invocation -> {
            PortletInstanceCategoryEntity entity = (PortletInstanceCategoryEntity)invocation.getArgument(0);
            entity.setId(Long.valueOf(2L));
            return entity;
        });
        PortletInstanceCategory createdPortletInstanceCategory = this.portletInstanceCategoryStorage.createPortletInstanceCategory(this.portletInstanceCategory);
        Assertions.assertNotNull((Object)createdPortletInstanceCategory);
        Assertions.assertEquals((long)2L, (long)createdPortletInstanceCategory.getId());
        Assertions.assertEquals((Object)this.portletInstanceCategory.getIcon(), (Object)createdPortletInstanceCategory.getIcon());
    }

    @Test
    public void updatePortletInstanceCategory() throws ObjectNotFoundException {
        Mockito.when((Object)this.portletInstanceCategory.getIcon()).thenReturn((Object)ICON);
        Mockito.when((Object)((PortletInstanceCategoryEntity)this.portletInstanceCategoryDAO.save((Object)((PortletInstanceCategoryEntity)ArgumentMatchers.any(PortletInstanceCategoryEntity.class))))).thenAnswer(invocation -> invocation.getArgument(0));
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.portletInstanceCategoryStorage.updatePortletInstanceCategory(this.portletInstanceCategory));
        Mockito.when((Object)this.portletInstanceCategory.getId()).thenReturn((Object)2L);
        Mockito.when((Object)this.portletInstanceCategory.getIcon()).thenReturn((Object)ICON);
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.portletInstanceCategoryStorage.updatePortletInstanceCategory(this.portletInstanceCategory));
        Mockito.when((Object)this.portletInstanceCategoryDAO.existsById((Object)this.portletInstanceCategory.getId())).thenReturn((Object)true);
        PortletInstanceCategory updatedPortletInstanceCategory = this.portletInstanceCategoryStorage.updatePortletInstanceCategory(this.portletInstanceCategory);
        Assertions.assertNotNull((Object)updatedPortletInstanceCategory);
        Assertions.assertEquals((long)this.portletInstanceCategory.getId(), (long)updatedPortletInstanceCategory.getId());
        Assertions.assertEquals((Object)this.portletInstanceCategory.getIcon(), (Object)updatedPortletInstanceCategory.getIcon());
    }

    @Test
    public void deletePortletInstanceCategory() throws ObjectNotFoundException {
        Assertions.assertThrows(ObjectNotFoundException.class, () -> this.portletInstanceCategoryStorage.deletePortletInstanceCategory(2L));
        Mockito.when((Object)this.portletInstanceCategoryDAO.existsById((Object)2L)).thenReturn((Object)true);
        this.portletInstanceCategoryStorage.deletePortletInstanceCategory(2L);
        ((PortletInstanceCategoryDAO)Mockito.verify((Object)this.portletInstanceCategoryDAO, (VerificationMode)Mockito.times((int)1))).deleteById((Object)2L);
    }
}

