/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.security.Keys;
import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.model.Room;
import io.meeds.chat.rest.model.Message;
import io.meeds.chat.rest.model.RoomEntity;
import io.meeds.chat.rest.model.RoomList;
import io.meeds.chat.service.utils.MatrixHttpClient;
import io.meeds.chat.storage.MatrixRoomStorage;
import jakarta.annotation.PostConstruct;
import java.io.IOException;
import java.security.Key;
import java.time.Instant;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import lombok.Generated;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.commons.file.model.FileItem;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.portal.localization.LocaleContextInfoUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.api.IdentityStorage;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class MatrixService {
    private static final Log LOG = ExoLogger.getLogger(MatrixService.class);
    @Autowired
    private MatrixRoomStorage matrixRoomStorage;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private IdentityStorage identityStorage;
    @Autowired
    private OrganizationService organizationService;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private ResourceBundleService resourceBundleService;
    @Autowired
    private MatrixHttpClient matrixHttpClient;
    private boolean serviceAvailable;
    private String matrixAccessToken;

    public MatrixService(MatrixRoomStorage matrixRoomStorage, IdentityManager identityManager, IdentityStorage identityStorage, OrganizationService organizationService, MatrixHttpClient matrixHttpClient) {
        this.matrixRoomStorage = matrixRoomStorage;
        this.identityManager = identityManager;
        this.identityStorage = identityStorage;
        this.organizationService = organizationService;
        this.matrixHttpClient = matrixHttpClient;
    }

    @PostConstruct
    public void init() {
        try {
            this.getMatrixAccessToken();
            String userFullMatrixID = "@" + PropertyManager.getProperty((String)"meeds.matrix.user.name") + ":" + PropertyManager.getProperty((String)"meeds.matrix.server.name");
            String displayName = System.getProperty("meeds.matrix.user.display.name", "Chat Bot");
            if (StringUtils.isNotBlank((CharSequence)displayName)) {
                this.updateUserDisplayName(userFullMatrixID, displayName);
            }
            this.serviceAvailable = true;
        }
        catch (Exception e) {
            LOG.error("Could not initialize Matrix service, the service is unavailable", new Object[]{e.getMessage()});
            this.serviceAvailable = false;
        }
    }

    private String getMatrixAccessToken() throws JsonException, IOException, InterruptedException {
        if (StringUtils.isBlank((CharSequence)this.matrixAccessToken)) {
            try {
                String jwtAccessToken = this.getJWTSessionToken(PropertyManager.getProperty((String)"meeds.matrix.user.name"));
                this.matrixAccessToken = this.matrixHttpClient.getAdminAccessToken(jwtAccessToken);
            }
            catch (IOException | InterruptedException | JsonException e) {
                LOG.error((Object)"Could not get Matrix Access token for the administrator account !");
                throw e;
            }
        }
        return this.matrixAccessToken;
    }

    public void updateUserDisplayName(String matrixFullID, String newDisplayName) {
        try {
            String currentUserDisplayName = this.matrixHttpClient.getUserDisplayName(matrixFullID, this.getMatrixAccessToken());
            if (StringUtils.isNotBlank((CharSequence)currentUserDisplayName) && !currentUserDisplayName.equals(newDisplayName)) {
                this.matrixHttpClient.updateUserDisplayName(matrixFullID, newDisplayName, this.getMatrixAccessToken());
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't update the display name of the user {}", new Object[]{matrixFullID, e});
        }
    }

    public String getRoomBySpace(Space space) {
        return this.matrixRoomStorage.getMatrixRoomBySpaceId(space.getId());
    }

    public Room getById(String roomId) {
        return this.matrixRoomStorage.getById(roomId);
    }

    public Room linkSpaceToMatrixRoom(Space space, String roomId) {
        return this.matrixRoomStorage.saveRoomForSpace(space.getId(), roomId);
    }

    public String createRoomForSpaceOnMatrix(Space space) throws Exception {
        String teamDisplayName = space.getDisplayName();
        String description = space.getDescription() != null ? space.getDescription() : "";
        return this.matrixHttpClient.createRoom(teamDisplayName, description, this.getMatrixAccessToken());
    }

    public String getMatrixIdForUser(String userName) {
        Identity newMember = this.identityManager.getOrCreateUserIdentity(userName);
        Profile newMemberProfile = newMember.getProfile();
        if (StringUtils.isNotBlank((CharSequence)((String)newMemberProfile.getProperty("matrixId")))) {
            return newMemberProfile.getProperty("matrixId").toString();
        }
        return null;
    }

    public String getJWTSessionToken(String userNameOnMatrix) {
        Date expirtaionDate = Date.from(Instant.now().plusSeconds(604800L));
        return Jwts.builder().setSubject(userNameOnMatrix).signWith((Key)Keys.hmacShaKeyFor((byte[])PropertyManager.getProperty((String)"meeds.matrix.jwt.secret").getBytes())).setExpiration(expirtaionDate).compact();
    }

    public String saveUserAccount(User user, boolean isNew, boolean isEnableUserOperation) throws JsonException, IOException, InterruptedException {
        String matrixId = this.matrixHttpClient.saveUserAccount(user, user.getUserName(), isNew, this.getMatrixAccessToken(), isEnableUserOperation);
        Identity userIdentity = this.identityManager.getOrCreateUserIdentity(user.getUserName());
        Profile userProfile = userIdentity.getProfile();
        if (StringUtils.isNotBlank((CharSequence)matrixId) && (userProfile.getProperty("matrixId") == null || StringUtils.isBlank((CharSequence)userProfile.getProperty("matrixId").toString()))) {
            userProfile.getProperties().put("matrixId", matrixId);
            this.identityManager.updateProfile(userProfile);
        }
        return matrixId;
    }

    public String uploadFileOnMatrix(String fileName, String mimeType, byte[] fileBytes) throws JsonException, IOException, InterruptedException {
        return this.matrixHttpClient.uploadFile(fileName, mimeType, fileBytes, this.getMatrixAccessToken());
    }

    public void updateUserAvatar(Profile profile, String userMatrixID) throws JsonException, IOException, InterruptedException {
        try {
            if (StringUtils.isNotBlank((CharSequence)userMatrixID)) {
                FileItem avatarFileItem = this.identityStorage.getAvatarFile(profile.getIdentity());
                String mimeType = "image/jpg";
                if (avatarFileItem != null && avatarFileItem.getFileInfo() != null && !"DEFAULT_AVATAR".equals(avatarFileItem.getFileInfo().getName())) {
                    if (!"application/octet-stream".equals(avatarFileItem.getFileInfo().getMimetype())) {
                        mimeType = avatarFileItem.getFileInfo().getMimetype();
                    }
                    String userAvatarUrl = this.uploadFileOnMatrix("avatar-of-" + profile.getIdentity().getRemoteId() + ".jpg", mimeType, avatarFileItem.getAsByte());
                    if (StringUtils.isNotBlank((CharSequence)userMatrixID) && StringUtils.isNotBlank((CharSequence)userAvatarUrl)) {
                        this.matrixHttpClient.updateUserAvatar(userMatrixID, userAvatarUrl, this.getMatrixAccessToken());
                    }
                }
            }
        }
        catch (Exception e) {
            LOG.error("Could not save the avatar of {} on Matrix", new Object[]{profile.getFullName(), e});
        }
    }

    public void disableAccount(String matrixUsername) throws JsonException, IOException, InterruptedException {
        this.matrixHttpClient.disableAccount(matrixUsername, false, this.getMatrixAccessToken());
    }

    public boolean updateRoomDescription(String roomId, String description) throws JsonException, IOException, InterruptedException {
        return this.matrixHttpClient.updateRoomDescription(roomId, description, this.getMatrixAccessToken());
    }

    public void updateRoomAvatar(Space space, String roomId) throws Exception {
        String mimeType = "";
        String fileExtension = "";
        String fileName = "";
        try {
            Identity identity = this.identityManager.getOrCreateIdentity("space", space.getPrettyName());
            FileItem spaceAvatarFileItem = this.identityManager.getAvatarFile(identity);
            byte[] imageBytes = new byte[]{};
            if (space.getAvatarAttachment() != null && space.getAvatarAttachment().getImageBytes() != null) {
                imageBytes = space.getAvatarAttachment().getImageBytes();
                mimeType = space.getAvatarAttachment().getMimeType();
                fileName = space.getAvatarAttachment().getFileName();
                fileExtension = StringUtils.isNotBlank((CharSequence)fileName) && fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".")) : ".jpg";
            } else if (spaceAvatarFileItem != null && spaceAvatarFileItem.getAsByte() != null) {
                imageBytes = spaceAvatarFileItem.getAsByte();
                mimeType = spaceAvatarFileItem.getFileInfo().getMimetype();
                fileName = spaceAvatarFileItem.getFileInfo().getName();
                String string = fileExtension = StringUtils.isNotBlank((CharSequence)fileName) && fileName.contains(".") ? fileName.substring(fileName.lastIndexOf(".")) : ".jpg";
            }
            if ("application/octet-stream".equals(mimeType)) {
                mimeType = "image/jpg";
            }
            fileName = "avatar-space-%s%s".formatted(space.getPrettyName(), fileExtension);
            if (StringUtils.isNotBlank((CharSequence)roomId) && imageBytes != null) {
                String avatarURL = this.uploadFileOnMatrix(fileName, mimeType, imageBytes);
                this.matrixHttpClient.updateRoomAvatar(roomId, avatarURL, this.getMatrixAccessToken());
            }
        }
        catch (Exception e) {
            throw new Exception("Could not save the avatar of the space %s".formatted(space.getDisplayName()), e);
        }
    }

    public MatrixRoomPermissions getRoomSettings(String roomId) throws JsonException, IOException, InterruptedException {
        return this.matrixHttpClient.getRoomSettings(roomId, this.getMatrixAccessToken());
    }

    public boolean updateRoomSettings(String roomId, MatrixRoomPermissions matrixRoomPermissions) throws JsonException, IOException, InterruptedException {
        return this.matrixHttpClient.updateRoomSettings(roomId, matrixRoomPermissions, this.getMatrixAccessToken()) != null;
    }

    public void kickUserFromRoom(String roomId, String matrixIdOfUser, String message) throws JsonException, IOException, InterruptedException {
        this.matrixHttpClient.kickUserFromRoom(roomId, matrixIdOfUser, message, this.getMatrixAccessToken());
    }

    public void joinUserToRoom(String roomId, String matrixIdOfUser) throws JsonException, IOException, InterruptedException {
        this.matrixHttpClient.joinUserToRoom(roomId, matrixIdOfUser, this.getMatrixAccessToken());
    }

    public void renameRoom(String roomId, String spaceDisplayName) throws JsonException, IOException, InterruptedException {
        this.matrixHttpClient.renameRoom(roomId, spaceDisplayName, this.getMatrixAccessToken());
    }

    public void makeUserAdminInRoom(String matrixRoomId, String matrixIdOfUser) throws JsonException, IOException, InterruptedException {
        this.matrixHttpClient.makeUserAdminInRoom(matrixRoomId, matrixIdOfUser, this.getMatrixAccessToken());
    }

    public String createRoom(Space space) throws Exception {
        String description;
        String teamDisplayName = space.getDisplayName();
        String matrixRoomId = this.matrixHttpClient.createRoom(teamDisplayName, description = space.getDescription() != null ? space.getDescription() : "", this.getMatrixAccessToken());
        if (StringUtils.isNotBlank((CharSequence)matrixRoomId)) {
            this.linkSpaceToMatrixRoom(space, matrixRoomId);
            MatrixRoomPermissions matrixRoomPermissions = this.getRoomSettings(matrixRoomId);
            matrixRoomPermissions.setInvite("100");
            this.updateRoomSettings(matrixRoomId, matrixRoomPermissions);
        }
        return matrixRoomId;
    }

    public long getAllLinkedRooms() {
        return this.matrixRoomStorage.getSpaceRoomCount();
    }

    public Room getDirectMessagingRoom(String firstParticipant, String secondParticipant) {
        return this.matrixRoomStorage.getDirectMessagingRoom(firstParticipant, secondParticipant);
    }

    public void deleteRoom(String roomId) throws JsonException, IOException, InterruptedException {
        boolean success = this.matrixHttpClient.deleteRoom(roomId, this.getMatrixAccessToken());
        if (success) {
            this.matrixRoomStorage.removeMatrixRoom(roomId);
        }
    }

    public Room createDirectMessagingRoom(Room directMessagingRoom) throws ObjectAlreadyExistsException {
        String firstParticipant = directMessagingRoom.getFirstParticipant();
        String secondParticipant = directMessagingRoom.getSecondParticipant();
        if (StringUtils.isBlank((CharSequence)firstParticipant) || StringUtils.isBlank((CharSequence)secondParticipant)) {
            throw new IllegalArgumentException("The ids of the room participants should not be null");
        }
        if (this.identityManager.getOrCreateUserIdentity(directMessagingRoom.getFirstParticipant()) == null || this.identityManager.getOrCreateUserIdentity(directMessagingRoom.getSecondParticipant()) == null) {
            throw new IllegalArgumentException("The ids of the room participants should be valid user identity ids");
        }
        Room matrixRoom = this.matrixRoomStorage.getDirectMessagingRoom(firstParticipant, secondParticipant);
        if (matrixRoom == null) {
            return this.matrixRoomStorage.saveDirectMessagingRoom(directMessagingRoom.getFirstParticipant(), directMessagingRoom.getSecondParticipant(), directMessagingRoom.getRoomId());
        }
        throw new ObjectAlreadyExistsException((Object)"A direct messaging room is already created for the users %s and %s".formatted(firstParticipant, secondParticipant));
    }

    public List<Room> getMatrixDMRoomsOfUser(String user) {
        return this.matrixRoomStorage.getMatrixDMRoomsOfUser(user);
    }

    public boolean isUserMemberOfGroup(String userName, String groupId) throws Exception {
        this.organizationService = CommonsUtils.getOrganizationService();
        Collection userMemberships = this.organizationService.getMembershipHandler().findMembershipsByUserAndGroup(userName, groupId);
        return !userMemberships.isEmpty();
    }

    public List<Room> getSpaceRooms() {
        return this.matrixRoomStorage.getSpaceRooms();
    }

    public Identity findUserByMatrixId(String userIdOnMatrix) {
        ProfileFilter profileFilter = new ProfileFilter();
        HashMap<String, String> matrixProperty = new HashMap<String, String>();
        matrixProperty.put("matrixId", userIdOnMatrix);
        profileFilter.setProfileSettings(matrixProperty);
        ListAccess userIdentities = this.identityManager.getIdentitiesByProfileFilter("organization", profileFilter, true);
        try {
            if (userIdentities != null && userIdentities.getSize() >= 1) {
                return ((Identity[])userIdentities.load(0, 1))[0];
            }
        }
        catch (Exception e) {
            LOG.error("Couldn't find a user having the Matrix ID : {}", new Object[]{userIdOnMatrix, e});
        }
        return null;
    }

    public RoomList processRooms(RoomList roomList, String currentUserName) {
        if (roomList == null || roomList.getRooms() == null) {
            throw new IllegalArgumentException("The room list Object is empty");
        }
        if (StringUtils.isBlank((CharSequence)currentUserName)) {
            throw new IllegalArgumentException("The username of the current user is mandatory");
        }
        for (RoomEntity room : roomList.getRooms()) {
            String updatedContent;
            Identity identity;
            Message message;
            String roomId = room.getId().substring(0, room.getId().indexOf(":"));
            Room matrixRoom = this.getById(roomId);
            if (matrixRoom != null) {
                if (StringUtils.isNotBlank((CharSequence)matrixRoom.getSpaceId())) {
                    Space space = this.spaceService.getSpaceById(matrixRoom.getSpaceId());
                    if (space == null) continue;
                    room.setName(space.getDisplayName());
                    room.setAvatarUrl(space.getAvatarUrl());
                    room.setSpaceId(matrixRoom.getSpaceId());
                } else {
                    Identity identity2 = null;
                    if (matrixRoom.getFirstParticipant().equals(currentUserName)) {
                        identity2 = this.identityManager.getOrCreateUserIdentity(matrixRoom.getSecondParticipant());
                    } else if (matrixRoom.getSecondParticipant().equals(currentUserName)) {
                        identity2 = this.identityManager.getOrCreateUserIdentity(matrixRoom.getFirstParticipant());
                    }
                    if (identity2 == null) continue;
                    room.setName(identity2.getProfile().getFullName());
                    room.setAvatarUrl(identity2.getProfile().getAvatarUrl());
                    room.setUserId(identity2.getRemoteId());
                    room.setIdentityId(identity2.getId());
                }
            }
            if ((message = room.getLastMessage()) == null || !StringUtils.isNotBlank((CharSequence)message.getSender()) || (identity = this.findUserByMatrixId(this.extractUserId(message.getSender()))) == null) continue;
            Locale locale = LocaleContextInfoUtils.getUserLocale((String)currentUserName);
            if (!identity.getRemoteId().equals(currentUserName)) {
                updatedContent = this.resourceBundleService.getSharedString("matrix.chat.lastMessage.pattern", locale).replace("{0}", identity.getProfile().getFullName()).replace("{1}", message.getContent());
            } else {
                String you = this.resourceBundleService.getSharedString("matrix.words.you", locale);
                updatedContent = this.resourceBundleService.getSharedString("matrix.chat.lastMessage.pattern", locale).replace("{0}", you).replace("{1}", message.getContent());
            }
            message.setContent(updatedContent);
            room.setLastMessage(new Message(updatedContent, identity.getProfile().getFullName()));
        }
        return roomList;
    }

    public String extractUserId(String fullMatrixUserId) {
        String serverName = PropertyManager.getProperty((String)"meeds.matrix.server.name");
        if (fullMatrixUserId.startsWith("@") && fullMatrixUserId.endsWith(serverName)) {
            return fullMatrixUserId.substring(1, fullMatrixUserId.indexOf(":"));
        }
        return fullMatrixUserId;
    }

    public String updateUserPresence(String userIdOnMatrix, String presence, String statusMessage) {
        try {
            return this.matrixHttpClient.setUserPresence(userIdOnMatrix, presence, statusMessage, this.getMatrixAccessToken());
        }
        catch (Exception e) {
            LOG.error("Could not update the presence onf the user {} on Matrix", new Object[]{userIdOnMatrix, e});
            return null;
        }
    }

    @Generated
    public boolean isServiceAvailable() {
        return this.serviceAvailable;
    }
}

