/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import com.fasterxml.jackson.core.type.TypeReference;
import io.meeds.chat.model.MatrixMessage;
import io.meeds.chat.model.Room;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.service.utils.MatrixConstants;
import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.service.PermanentLinkService;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.service.PwaNotificationService;
import io.meeds.social.util.JsonUtils;
import java.io.IOException;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChatNotificationService {
    private static final Log LOG = ExoLogger.getLogger(ChatNotificationService.class);
    @Autowired
    private MatrixService matrixService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    ResourceBundleService resourceBundleService;
    @Autowired
    private PwaNotificationService pwaNotificationService;
    @Autowired
    private SettingService settingService;
    @Autowired
    private PermanentLinkService permanentLinkService;
    @Autowired
    private UserPortalConfigService portalConfigService;
    private static UserStateService userStateService;
    private static UserSettingService userSettingService;
    public static String IN_KEY;
    private static final String USER_STATUS_AVAILABLE = "available";
    public static final Scope USER_CHAT_NOTIFICATION_SCOPE;
    public static final String MUTED_ROOMS = "mutedRooms";
    public static final String PUSH_NOTIFICATIONS_SETTINGS = "pushNotificationsSettings";

    public ScheduledFuture<?> sendCreateNotificationAction(String eventId, String userName, String roomId, int unreadCount) {
        if (!this.canSendPushNotificationToUser(userName, roomId)) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String encodedId = URLEncoder.encode(eventId + "|" + roomId, StandardCharsets.UTF_8).replace("+", "%20");
        params.put("notificationId", encodedId);
        params.put("username", userName);
        params.put("action", "open");
        params.put("type", "CHAT_NOTIFICATION");
        return this.pwaNotificationService.create(params);
    }

    public PwaNotificationMessage createNotification(MatrixMessage message, String userName) {
        if (message != null) {
            PwaNotificationMessage pwaNotificationMessage = new PwaNotificationMessage();
            Room room = this.matrixService.getById(message.getRoomId());
            LocaleConfig localeConfig = this.pwaNotificationService.getLocaleConfig(userName);
            String sender = message.getSender();
            if (room != null) {
                if (StringUtils.isBlank((CharSequence)room.getSpaceId())) {
                    String senderUserName = room.getFirstParticipant().equals(userName) ? room.getSecondParticipant() : room.getFirstParticipant();
                    Identity senderIdentity = this.identityManager.getOrCreateUserIdentity(senderUserName);
                    String senderFullName = senderIdentity != null ? senderIdentity.getProfile().getFullName() : sender;
                    pwaNotificationMessage.setTitle(senderFullName);
                    pwaNotificationMessage.setIcon(senderIdentity != null ? senderIdentity.getProfile().getAvatarUrl() : "");
                } else {
                    Space space = this.spaceService.getSpaceById(room.getSpaceId());
                    Identity senderIdentity = this.matrixService.findSpaceMemberByMatrixId(sender, space);
                    String senderFullName = senderIdentity != null ? senderIdentity.getProfile().getFullName() : sender;
                    pwaNotificationMessage.setTitle(senderFullName + " " + this.resourceBundleService.getSharedString(IN_KEY, localeConfig.getLocale()) + " " + space.getDisplayName());
                    pwaNotificationMessage.setIcon(space.getAvatarUrl());
                }
                pwaNotificationMessage.setBody(message.getMessageContent());
                pwaNotificationMessage.setUrl(this.getMessageLink(message));
                this.pwaNotificationService.setDefaultNotificationMessageProperties(pwaNotificationMessage, message.getEventId(), localeConfig);
                return pwaNotificationMessage;
            }
            return null;
        }
        return null;
    }

    public PwaNotificationMessage createNotification(String eventId, String roomId, String userName, long lastMessageTimeStamp, String token) {
        MatrixMessage message = this.matrixService.getRoomEvent(eventId, roomId, token);
        if (lastMessageTimeStamp >= message.getTimeStamp()) {
            return null;
        }
        return this.createNotification(message, userName);
    }

    public boolean createMentionNotification(String eventId, String roomId, String userName, String pushKey) {
        MatrixMessage message;
        Room room = this.matrixService.getById(roomId);
        if (room == null) {
            return false;
        }
        if (StringUtils.isNotBlank((CharSequence)room.getSpaceId())) {
            message = this.matrixService.getRoomEvent(eventId, roomId, null);
        } else {
            String accessToken = null;
            try {
                accessToken = this.matrixService.getAccessToken(pushKey);
            }
            catch (IOException | JsonException e) {
                LOG.error((Object)"Could not get Matrix Access token for the administrator account !", e);
            }
            catch (InterruptedException interruptedException) {
                Thread.currentThread().interrupt();
                LOG.error((Object)"Could not get Matrix Access token for the administrator account !", (Throwable)interruptedException);
            }
            if (StringUtils.isBlank((CharSequence)accessToken)) {
                return false;
            }
            message = this.matrixService.getRoomEvent(eventId, roomId, accessToken);
            this.matrixService.invalidateAccessToken(accessToken);
        }
        Identity receiverIdentity = this.identityManager.getOrCreateUserIdentity(userName);
        String matrixReceiverId = userName;
        if (receiverIdentity != null && StringUtils.isNotBlank((CharSequence)((String)receiverIdentity.getProfile().getProperties().get("matrixId")))) {
            matrixReceiverId = this.matrixService.getUserFullMatrixID((String)receiverIdentity.getProfile().getProperties().get("matrixId"));
        }
        String roomName = "";
        String senderFullName = "";
        String roomAvatarUrl = "";
        if (message != null && message.getMentionedUsers() != null && !message.getMentionedUsers().isEmpty() && message.getMentionedUsers().contains(matrixReceiverId)) {
            Identity senderIdentity = this.identityManager.getOrCreateUserIdentity(this.matrixService.findUserByMatrixId(message.getSender()));
            if (senderIdentity != null) {
                senderFullName = senderIdentity.getProfile().getFullName();
            }
            if (StringUtils.isNotBlank((CharSequence)room.getSpaceId())) {
                Space space = this.spaceService.getSpaceById(room.getSpaceId());
                roomName = space.getDisplayName();
                roomAvatarUrl = space.getAvatarUrl();
            } else if (senderIdentity != null) {
                roomName = senderIdentity.getProfile().getFullName();
                roomAvatarUrl = senderIdentity.getProfile().getAvatarUrl();
            } else {
                roomName = message.getSender();
            }
            NotificationContext ctx = NotificationContextImpl.cloneInstance();
            ctx.append(MatrixConstants.MATRIX_ROOM_ID, (Object)message.getRoomId());
            ctx.append(MatrixConstants.MATRIX_MESSAGE_SENDER, (Object)this.matrixService.findUserByMatrixId(message.getSender()));
            ctx.append(MatrixConstants.MATRIX_ROOM_NAME, (Object)roomName);
            ctx.append(MatrixConstants.MATRIX_ROOM_TYPE, (Object)(StringUtils.isNotBlank((CharSequence)room.getSpaceId()) ? "SPACE" : "ONE_TO_ONE"));
            ctx.append(MatrixConstants.MATRIX_ROOM_AVATAR, (Object)roomAvatarUrl);
            ctx.append(MatrixConstants.MATRIX_MESSAGE_CONTENT, (Object)message.getMessageContent());
            ctx.append(MatrixConstants.MATRIX_ROOM_MEMBER, (Object)userName);
            ctx.append(MatrixConstants.MATRIX_MESSAGE_SENDER_FULLNAME, (Object)senderFullName);
            String permalink = this.getMessageLink(message);
            ctx.append(MatrixConstants.MATRIX_MESSAGE_URL, (Object)(StringUtils.isNotBlank((CharSequence)permalink) ? permalink : ""));
            return ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"MatrixMentionReceivedNotificationPlugin"))).execute(ctx);
        }
        return false;
    }

    public boolean isPrivateRoomMutedForUser(String userName, String roomId) {
        return this.getMutedRooms(userName).contains(roomId);
    }

    public void toggleMutePrivateRoom(String userName, String roomId) {
        HashSet<String> mutedRoomIds = new HashSet<String>(this.getMutedRooms(userName));
        boolean changed = mutedRoomIds.remove(roomId);
        if (!changed) {
            changed = mutedRoomIds.add(roomId);
        }
        if (changed) {
            this.settingService.set(Context.USER.id(userName), USER_CHAT_NOTIFICATION_SCOPE, MUTED_ROOMS, SettingValue.create((String)JsonUtils.toJsonString(mutedRoomIds)));
        }
    }

    private Set<String> getMutedRooms(String userName) {
        try {
            SettingValue settingValue = this.settingService.get(Context.USER.id(userName), USER_CHAT_NOTIFICATION_SCOPE, MUTED_ROOMS);
            if (settingValue == null || settingValue.getValue() == null) {
                return Collections.emptySet();
            }
            return (Set)JsonUtils.OBJECT_MAPPER.readValue(settingValue.getValue().toString(), (TypeReference)new TypeReference<Set<String>>(this){});
        }
        catch (Exception e) {
            LOG.error("Error reading muted rooms setting value for user {}", new Object[]{userName, e});
            return Collections.emptySet();
        }
    }

    private String getMessageLink(MatrixMessage message) {
        String urlFormat = "%s?roomId=%s&message=%s";
        Room room = this.matrixService.getById(message.getRoomId());
        String link = "";
        try {
            if (StringUtils.isNotBlank((CharSequence)room.getSpaceId())) {
                link = this.permanentLinkService.getLink(new PermanentLinkObject("space", room.getSpaceId()));
                return urlFormat.formatted(link, room.getRoomId(), message.getEventId());
            }
            String sender = this.matrixService.findUserByMatrixId(message.getSender());
            link = String.format("/portal/%s/profile/%s", this.portalConfigService.getMetaPortal(), sender);
        }
        catch (Exception e) {
            link = String.format("/portal/%s", this.portalConfigService.getMetaPortal());
        }
        return urlFormat.formatted(link, room.getRoomId(), message.getEventId());
    }

    public boolean isPushNotificationsEnabled(String userName) {
        SettingValue settingValue = this.settingService.get(Context.USER.id(userName), USER_CHAT_NOTIFICATION_SCOPE, PUSH_NOTIFICATIONS_SETTINGS);
        return settingValue == null || Boolean.parseBoolean((String)settingValue.getValue());
    }

    public void updatePushNotificationSettings(String userName, boolean pushNotificationStatus) {
        this.settingService.set(Context.USER.id(userName), USER_CHAT_NOTIFICATION_SCOPE, PUSH_NOTIFICATIONS_SETTINGS, new SettingValue((Object)String.valueOf(pushNotificationStatus)));
    }

    private boolean canSendPushNotificationToUser(String userName, String roomId) {
        UserSetting userSetting;
        if (!this.isPushNotificationsEnabled(userName)) {
            return false;
        }
        Room room = this.matrixService.getById(roomId);
        if (room == null) {
            return false;
        }
        boolean roomMuted = StringUtils.isNotBlank((CharSequence)room.getSpaceId()) ? (userSetting = ChatNotificationService.getUserSettingService().get(userName)) != null && userSetting.isSpaceMuted(Long.parseLong(room.getSpaceId())) : this.isPrivateRoomMutedForUser(userName, roomId);
        UserStateModel userStatus = ChatNotificationService.getUserStateService().getUserState(userName);
        return userStatus.getStatus().equals(USER_STATUS_AVAILABLE) && !roomMuted;
    }

    private static UserStateService getUserStateService() {
        if (userStateService == null) {
            userStateService = (UserStateService)CommonsUtils.getService(UserStateService.class);
        }
        return userStateService;
    }

    private static UserSettingService getUserSettingService() {
        if (userSettingService == null) {
            userSettingService = (UserSettingService)CommonsUtils.getService(UserSettingService.class);
        }
        return userSettingService;
    }

    static {
        IN_KEY = "matrix.words.in";
        USER_CHAT_NOTIFICATION_SCOPE = Scope.APPLICATION.id("ChatNotificationSettings");
    }
}

