/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.upgrade;

import io.meeds.chat.model.Room;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.upgrade.MatrixRoomAndAccountsUpgradePlugin;
import org.exoplatform.commons.utils.ListAccess;
import org.exoplatform.container.xml.InitParams;
import org.exoplatform.services.organization.OrganizationService;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.UserHandler;
import org.exoplatform.services.organization.impl.UserImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.SpaceFilter;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;

class MatrixRoomAndAccountsUpgradePluginTest {
    private SpaceService spaceService;
    private MatrixService matrixService;
    private IdentityManager identityManager;
    private OrganizationService organizationService;

    MatrixRoomAndAccountsUpgradePluginTest() {
    }

    @BeforeEach
    void setUp() throws Exception {
        this.spaceService = (SpaceService)Mockito.mock(SpaceService.class);
        this.identityManager = (IdentityManager)Mockito.mock(IdentityManager.class);
        this.matrixService = (MatrixService)Mockito.mock(MatrixService.class);
        this.organizationService = (OrganizationService)Mockito.mock(OrganizationService.class);
        UserHandler userHandler = (UserHandler)Mockito.mock(UserHandler.class);
        ListAccess usersListAccess = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)usersListAccess.getSize()).thenReturn((Object)3);
        UserImpl user1 = new UserImpl("user1");
        UserImpl user2 = new UserImpl("user2");
        UserImpl user3 = new UserImpl("user3");
        Identity user1Identity = (Identity)Mockito.mock(Identity.class);
        Identity user2Identity = (Identity)Mockito.mock(Identity.class);
        Identity user3Identity = (Identity)Mockito.mock(Identity.class);
        Profile user1Profile = (Profile)Mockito.mock(Profile.class);
        Profile user2Profile = (Profile)Mockito.mock(Profile.class);
        Profile user3Profile = (Profile)Mockito.mock(Profile.class);
        Mockito.when((Object)user1Profile.getProperty((String)ArgumentMatchers.eq((Object)"matrixId"))).thenReturn((Object)"user1");
        Mockito.when((Object)user2Profile.getProperty((String)ArgumentMatchers.eq((Object)"matrixId"))).thenReturn((Object)"user2");
        Mockito.when((Object)user3Profile.getProperty((String)ArgumentMatchers.eq((Object)"matrixId"))).thenReturn((Object)"user3");
        Mockito.when((Object)user1Identity.getProfile()).thenReturn((Object)user1Profile);
        Mockito.when((Object)user2Identity.getProfile()).thenReturn((Object)user2Profile);
        Mockito.when((Object)user3Identity.getProfile()).thenReturn((Object)user3Profile);
        Mockito.when((Object)((User[])usersListAccess.load(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt()))).thenReturn((Object)new User[]{user1, user2, user3});
        Mockito.when((Object)userHandler.findAllUsers()).thenReturn((Object)usersListAccess);
        Mockito.when((Object)this.organizationService.getUserHandler()).thenReturn((Object)userHandler);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity((String)ArgumentMatchers.eq((Object)"user1"))).thenReturn((Object)user1Identity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity((String)ArgumentMatchers.eq((Object)"user2"))).thenReturn((Object)user2Identity);
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity((String)ArgumentMatchers.eq((Object)"user3"))).thenReturn((Object)user3Identity);
        Space space = new Space();
        space.setId(1L);
        space.setMembers(new String[]{"user1", "user2", "user3"});
        ListAccess spaces = (ListAccess)Mockito.mock(ListAccess.class);
        Mockito.when((Object)spaces.getSize()).thenReturn((Object)1);
        Mockito.when((Object)((Space[])spaces.load(ArgumentMatchers.anyInt(), ArgumentMatchers.anyInt()))).thenReturn((Object)new Space[]{space});
        Mockito.when((Object)this.spaceService.getMemberSpaces(ArgumentMatchers.anyString())).thenReturn((Object)spaces);
        Room room = new Room();
        room.setRoomId("!ThisIsAnIdentifierOfARoom:matrix.exo.tn");
        room.setSpaceId("1");
        Mockito.when((Object)this.matrixService.getRoomBySpace((Space)ArgumentMatchers.eq((Object)space))).thenReturn((Object)room);
        Mockito.when((Object)this.spaceService.getAllSpacesByFilter((SpaceFilter)ArgumentMatchers.any())).thenReturn((Object)spaces);
    }

    @Test
    void processUpgrade() {
        InitParams initParams = new InitParams();
        MatrixRoomAndAccountsUpgradePlugin matrixRoomAndAccountsUpgradePlugin = new MatrixRoomAndAccountsUpgradePlugin(initParams, this.spaceService, this.matrixService, this.organizationService, this.identityManager);
        matrixRoomAndAccountsUpgradePlugin.processUpgrade("versionSource", "versionTarget");
    }
}

