/*
 * Decompiled with CFR 0.152.
 */
import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.service.utils.MatrixHttpClient;
import java.io.IOException;
import java.util.Date;
import java.util.Random;
import org.exoplatform.services.organization.User;
import org.exoplatform.services.organization.idm.UserImpl;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.identity.model.Profile;
import org.exoplatform.ws.frameworks.json.impl.JsonException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;

public class MatrixUtilsTest {
    private String access_token = "syt_ZXhv_BDVYgRelgkgjGduvVCyz_1iXdtf";
    MatrixHttpClient matrixHttpClient = new MatrixHttpClient();

    @Before
    public void setUp() {
        System.setProperty("meeds.matrix.server.url", "http://localhost:8008");
        System.setProperty("meeds.matrix.shared_secret_registration", "4fzT.7xvkyp1EA-*bX#fzpVgOc_cb0y9z6*uOCUht1DO5ksad8");
        System.setProperty("meeds.matrix.server.name", "matrix.exo.tn");
    }

    public void testCreateUserAccount() {
        String randomKey = String.valueOf(Math.round(Math.random() * 100.0));
        UserImpl user = new UserImpl("testUser" + randomKey);
        user.setEmail("test@exo.com");
        user.setFirstName("test " + randomKey);
        user.setLastName("User");
        this.matrixHttpClient.createUserAccount((User)user, this.access_token);
    }

    public void testSaveUserAccount() {
        String randomKey = String.valueOf(Math.round(Math.random() * 100.0));
        Identity user = new Identity("testUser" + randomKey);
        Profile profile = new Profile();
        profile.setProperty("email", (Object)"test@exo.com");
        profile.setProperty("firstName", (Object)("test " + randomKey));
        profile.setProperty("lastName", (Object)"User");
        this.matrixHttpClient.saveUserAccount(user, user.getRemoteId(), true, this.access_token);
    }

    public void testDisableUserAccount() {
        String randomKey = String.valueOf(Math.round(Math.random() * 10000.0));
        Identity user = new Identity("testUser" + randomKey);
        Profile profile = new Profile();
        profile.setProperty("email", (Object)"test@exo.com");
        profile.setProperty("firstName", (Object)("test " + randomKey));
        profile.setProperty("lastName", (Object)"User");
        String username = this.matrixHttpClient.saveUserAccount(user, user.getRemoteId(), true, this.access_token);
        this.matrixHttpClient.disableAccount(username, false, this.access_token);
    }

    public void testRenameSpace() {
        String roomId = null;
        try {
            roomId = this.matrixHttpClient.createRoom("new room", "new room description", this.access_token);
        }
        catch (Exception exception) {
            // empty catch block
        }
        Assert.assertNotNull((Object)this.matrixHttpClient.renameRoom(roomId, "new room renamed" + new Date().getTime(), this.access_token));
    }

    public void testInviteUser() throws Exception {
        String randomKey = String.valueOf(Math.round(Math.random() * 10000.0));
        Identity user = new Identity("testUser" + randomKey);
        Profile profile = new Profile();
        profile.setProperty("email", (Object)"test@exo.com");
        profile.setProperty("firstName", (Object)("test " + randomKey));
        profile.setProperty("lastName", (Object)"User");
        String invitee = this.matrixHttpClient.saveUserAccount(user, user.getRemoteId(), true, this.access_token);
        String roomId = this.matrixHttpClient.createRoom("Football game", "Description of Football team", this.access_token);
        this.matrixHttpClient.inviteUserToRoom(roomId, invitee, "Welcome to Football game room !", this.access_token);
    }

    public void testKickUser() {
        String roomId = "!rYdqPkQhIzNWyVPDFX";
        this.matrixHttpClient.kickUserFromRoom(roomId, "@testuser1:matrix.exo.tn", "Talking too much!", this.access_token);
    }

    public void updateRoomSettings() throws JsonException, IOException, InterruptedException {
        String roomId = "!rYdqPkQhIzNWyVPDFX";
        MatrixRoomPermissions settings = this.matrixHttpClient.getRoomSettings(roomId, this.access_token);
        settings.setInvite("0");
        String updateEventId = this.matrixHttpClient.updateRoomSettings(roomId, settings, this.access_token);
    }

    public void updateRoomAvatar() {
        try {
            String roomId = "!HaTqHwWINwoSoIGfZx";
            byte[] resource = this.getClass().getClassLoader().getResourceAsStream("meeds.png").readAllBytes();
            String imageStored = this.matrixHttpClient.uploadFile("image.png", "image/png", resource, this.access_token);
            boolean bl = this.matrixHttpClient.updateRoomAvatar(roomId, imageStored, this.access_token);
        }
        catch (IOException e) {
            throw new RuntimeException(e);
        }
    }

    public void updateUserAvatar() {
        try {
            String roomId = "@root:matrix.exo.tn";
            int randomInt = new Random().nextInt(3);
            byte[] resource = this.getClass().getClassLoader().getResourceAsStream("avatar" + randomInt + ".png").readAllBytes();
            String imageStored = this.matrixHttpClient.uploadFile("image.png", "image/png", resource, this.access_token);
            Assert.assertTrue((boolean)this.matrixHttpClient.updateUserAvatar(roomId, imageStored, this.access_token));
        }
        catch (IOException e) {
            Assert.fail();
        }
    }

    @Test
    public void testCleanMatrixUsername() {
        String[] usernames;
        for (String username : usernames = new String[]{"Samue\u00e2l", "fre@d", "Shazia", "gorkef/", "\u00b2&\u00e9\"'(-\u00e8_\u00e7\u00e0)=\u00b21234567890\u00b0+'azertyuiopqsdfghjklm\u00f9*^$wxcvbn,;:!?./\u00a7%\u00b5\u00a8\u00a3<>\u00b2&~#{[|`\\^@]}"}) {
            String result = this.matrixHttpClient.cleanMatrixUsername(username);
            Assert.assertNotNull((Object)result);
        }
    }

    public void testDeleteSpace() throws Exception {
        long currentTime = System.currentTimeMillis();
        String matrixRoomId = this.matrixHttpClient.createRoom("test space" + currentTime, "test description " + currentTime, this.access_token);
        this.matrixHttpClient.deleteRoom(matrixRoomId, this.access_token);
    }

    public void testGetUserPresence() {
        String accessToken = "syt_cm9vdA_MgLOkjIhSlwzrIpMElUo_1kSAtC";
        String userIdOnMatrix = "@root:matrix.exo.tn";
        try {
            String status = this.matrixHttpClient.getUserPresence(userIdOnMatrix, accessToken);
            Assert.assertNotNull((Object)status);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }

    public void testSetUserPresence() {
        String accessToken = "syt_cm9vdA_MgLOkjIhSlwzrIpMElUo_1kSAtC";
        String userIdOnMatrix = "@root:matrix.exo.tn";
        String presence = "online";
        String statusMessage = "Hello I am online";
        try {
            String status = this.matrixHttpClient.setUserPresence(userIdOnMatrix, presence, statusMessage, accessToken);
            Assert.assertNotNull((Object)status);
        }
        catch (Exception e) {
            Assert.fail();
        }
    }
}

