/*
 * This file is part of the Meeds project (https://meeds.io/).
 *
 * Copyright (C) 2020 - 2025 Meeds Association contact@meeds.io
 *
 * This program is free software; you can redistribute it and/or
 * modify it under the terms of the GNU Lesser General Public
 * License as published by the Free Software Foundation; either
 * version 3 of the License, or (at your option) any later version.
 * This program is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU
 * Lesser General Public License for more details.
 *
 * You should have received a copy of the GNU Lesser General Public License
 * along with this program; if not, write to the Free Software Foundation,
 * Inc., 51 Franklin Street, Fifth Floor, Boston, MA 02110-1301, USA.
 */
package io.meeds.chat.dao;

import io.meeds.chat.entity.RoomEntity;
import io.meeds.chat.entity.RoomStatus;
import org.springframework.data.jpa.repository.JpaRepository;
import org.springframework.data.jpa.repository.Query;

import java.util.List;

public interface MatrixRoomDAO extends JpaRepository<RoomEntity, Long> {

  public RoomEntity findByRoomId(String roomId);

  public RoomEntity findBySpaceId(String spaceId);

  @Query("""
          SELECT m from MatrixRoom m
          WHERE (m.firstParticipant = ?1
          AND m.secondParticipant = ?2)
          OR
          (m.firstParticipant = ?2
          AND m.secondParticipant = ?1)
      """)
  public RoomEntity findByFirstParticipantAndSecondParticipant(String firstParticipant, String secondParticipant);

  public List<RoomEntity> findByFirstParticipantOrSecondParticipant(String userOne, String userTwo);

  public RoomEntity findByRoomIdStartsWith(String roomId);

  public List<RoomEntity> findBySpaceIdIsNotNull();

  public List<RoomEntity> findBySpaceIdIsNotNullAndStatusIs(RoomStatus status);

  public List<RoomEntity> findBySpaceIdIn(List<String> spaceIds);
}
