/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat;

import io.meeds.chat.model.MatrixRoomPermissions;
import io.meeds.chat.model.MatrixUserPermission;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.service.utils.MatrixHttpClient;
import io.meeds.kernel.test.AbstractSpringTest;
import io.meeds.kernel.test.KernelExtension;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.exoplatform.commons.utils.PropertyManager;
import org.exoplatform.component.test.ConfigurationUnit;
import org.exoplatform.component.test.ConfiguredBy;
import org.exoplatform.component.test.ContainerScope;
import org.exoplatform.component.test.KernelBootstrap;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.jpa.search.ProfileSearchConnector;
import org.exoplatform.social.core.jpa.storage.RDBMSIdentityStorageImpl;
import org.exoplatform.social.core.profile.ProfileFilter;
import org.exoplatform.social.core.relationship.model.Relationship;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.core.storage.cache.CachedIdentityStorage;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.BeforeAll;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.extension.ExtendWith;
import org.mockito.ArgumentMatchers;
import org.mockito.Mockito;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.test.mock.mockito.MockBean;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;
import org.springframework.test.context.TestPropertySource;
import org.springframework.test.context.junit.jupiter.SpringExtension;

@ExtendWith(value={SpringExtension.class, KernelExtension.class})
@SpringBootApplication(scanBasePackages={"io.meeds.chat", "io.meeds.spring.kernel.test", "io.meeds.spring.jpa", "io.meeds.spring.liquibase", "io.meeds.spring.web", "io.meeds.pwa"})
@EnableJpaRepositories(basePackages={"io.meeds.chat"})
@TestPropertySource(properties={"spring.liquibase.change-log=classpath:db/changelog/matrix-rdbms.db.changelog-master.xml", "spring.profiles.active=matrix"})
@ConfiguredBy(value={@ConfigurationUnit(scope=ContainerScope.ROOT, path="conf/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/configuration.xml"), @ConfigurationUnit(scope=ContainerScope.PORTAL, path="conf/portal/matrix-test-configuration.xml")})
public class MatrixBaseTest
extends AbstractSpringTest {
    public static final String MODULE_NAME = "io.meeds.chat";
    public List<Space> spacesToDelete = new ArrayList<Space>();
    public List<String> roomsToDelete = new ArrayList<String>();
    public String matrixRoomId = "!thisIsACreatedRoom:matrix.meeds.tn";
    public String accessToken = "ThisIsAnAccessToken";
    @Autowired
    public SpaceService spaceService;
    @Autowired
    public CachedIdentityStorage identityStorage;
    @Autowired
    public MatrixService matrixService;
    @MockBean
    public ProfileSearchConnector profileSearchConnector;
    @MockBean
    public MatrixHttpClient matrixHttpClient;
    private static KernelBootstrap bootstrap;
    public static final String CHANGELOG_PATH = "classpath:db/changelog/matrix-rdbms.db.changelog-master.xml";

    @BeforeAll
    static void beforeAll() {
        PropertyManager.setProperty((String)"meeds.matrix.jwt.secret", (String)"ThisIsAJWTSecretOfMatrixForTestingPurposes");
        PropertyManager.setProperty((String)"meeds.matrix.server.url", (String)"https://matrix.exo.tn");
        PropertyManager.setProperty((String)"meeds.matrix.server.name", (String)"matrix.exo.tn");
    }

    public PortalContainer getContainer() {
        return bootstrap == null ? this.bootContainer() : bootstrap.getContainer();
    }

    protected PortalContainer bootContainer() {
        PortalContainer container = MatrixBaseTest.bootContainer(((Object)((Object)this)).getClass());
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        return container;
    }

    @BeforeEach
    protected void setUp() throws Exception {
        this.begin();
        PropertyManager.setProperty((String)"meeds.matrix.user.name", (String)"demo");
        Mockito.when((Object)this.profileSearchConnector.search((Identity)ArgumentMatchers.any(), (ProfileFilter)ArgumentMatchers.any(), (Relationship.Type)ArgumentMatchers.any(), ArgumentMatchers.anyLong(), ArgumentMatchers.anyLong())).thenReturn(List.of("1", "2"));
        Mockito.when((Object)this.profileSearchConnector.count((Identity)ArgumentMatchers.any(), (ProfileFilter)ArgumentMatchers.any(), (Relationship.Type)ArgumentMatchers.any())).thenReturn((Object)2);
        ((RDBMSIdentityStorageImpl)this.identityStorage.getStorage()).setProfileSearchConnector(this.profileSearchConnector);
        Mockito.when((Object)this.matrixHttpClient.getAdminAccessToken(ArgumentMatchers.anyString())).thenReturn((Object)this.accessToken);
        Mockito.when((Object)this.matrixHttpClient.createRoom(ArgumentMatchers.anyString(), ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)this.matrixRoomId);
        Mockito.when((Object)this.matrixHttpClient.deleteRoom(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)true);
        MatrixUserPermission matrixUserPermission = new MatrixUserPermission();
        matrixUserPermission.setUserName("demo");
        matrixUserPermission.setUserRole("50");
        MatrixUserPermission raulUserPermission = new MatrixUserPermission();
        raulUserPermission.setUserName("raul");
        raulUserPermission.setUserRole("0");
        MatrixRoomPermissions matrixRoomPermissions = new MatrixRoomPermissions();
        matrixRoomPermissions.setUsers(new ArrayList<MatrixUserPermission>(List.of(new MatrixUserPermission[]{matrixUserPermission, raulUserPermission})));
        Mockito.when((Object)this.matrixHttpClient.getRoomSettings(ArgumentMatchers.anyString(), ArgumentMatchers.anyString())).thenReturn((Object)matrixRoomPermissions);
        Mockito.when((Object)this.matrixHttpClient.saveUserAccount((Identity)ArgumentMatchers.any(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString())).thenReturn((Object)"@demo:matrix.meeds.tn");
        Mockito.when((Object)this.matrixHttpClient.saveUserAccount((Identity)ArgumentMatchers.any(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyString(), ArgumentMatchers.anyBoolean(), ArgumentMatchers.anyBoolean())).thenReturn((Object)"@demo:matrix.meeds.tn");
    }

    @AfterEach
    protected void tearDown() {
        for (Space space : this.spacesToDelete) {
            try {
                this.spaceService.deleteSpace(space);
            }
            catch (Exception exception) {}
        }
        for (String roomId : this.roomsToDelete) {
            try {
                this.matrixService.deleteRoom(roomId);
            }
            catch (Exception exception) {}
        }
        this.end();
    }

    protected void begin() {
        PortalContainer container = this.getContainer();
        ExoContainerContext.setCurrentContainer((ExoContainer)container);
        RequestLifeCycle.begin((ExoContainer)container);
    }

    protected void end() {
        RequestLifeCycle.end();
    }

    protected Space getSpaceInstance(int number) {
        Space space = new Space();
        space.setDisplayName("my space " + number);
        space.setPrettyName(space.getDisplayName());
        space.setRegistration("open");
        space.setDescription("add new space " + number);
        space.setVisibility("public");
        space.setRegistration("validation");
        Identity spaceIdentity = new Identity();
        spaceIdentity.setRemoteId(space.getPrettyName());
        spaceIdentity.setProviderId("space");
        this.identityStorage.saveIdentity(spaceIdentity);
        Space createdSpace = this.spaceService.createSpace(space, "root");
        String[] managers = new String[]{"demo", "tom"};
        String[] members = new String[]{"demo", "raul", "ghost", "dragon"};
        String[] invitedUsers = new String[]{"register1", "mary"};
        String[] pendingUsers = new String[]{"jame", "paul", "hacker"};
        Arrays.stream(pendingUsers).forEach(u -> this.spaceService.addPendingUser(createdSpace, u));
        Arrays.stream(invitedUsers).forEach(u -> this.spaceService.addInvitedUser(createdSpace, u));
        Arrays.stream(members).forEach(u -> this.spaceService.addMember(createdSpace, u));
        Arrays.stream(managers).forEach(u -> this.spaceService.addMember(createdSpace, u));
        Arrays.stream(managers).forEach(u -> this.spaceService.setManager(createdSpace, u, true));
        this.spacesToDelete.add(createdSpace);
        return createdSpace;
    }
}

