/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import com.fasterxml.jackson.core.type.TypeReference;
import io.meeds.chat.model.MatrixMessage;
import io.meeds.chat.model.Room;
import io.meeds.chat.service.MatrixService;
import io.meeds.chat.service.utils.MatrixConstants;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.service.PwaNotificationService;
import io.meeds.social.util.JsonUtils;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.ScheduledFuture;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.api.notification.NotificationContext;
import org.exoplatform.commons.api.notification.model.PluginKey;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.notification.impl.NotificationContextImpl;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.resources.LocaleConfig;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ChatNotificationService {
    private static final Log LOG = ExoLogger.getLogger(ChatNotificationService.class);
    @Autowired
    private MatrixService matrixService;
    @Autowired
    private IdentityManager identityManager;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    ResourceBundleService resourceBundleService;
    @Autowired
    private PwaNotificationService pwaNotificationService;
    @Autowired
    private SettingService settingService;
    private static UserStateService userStateService;
    private static UserSettingService userSettingService;
    public static String IN_KEY;
    private static final String USER_STATUS_AVAILABLE = "available";
    public static final Scope USER_CHAT_NOTIFICATION_SCOPE;
    public static final String MUTED_ROOMS = "mutedRooms";

    public ScheduledFuture<?> sendCreateNotificationAction(String eventId, String userName, String roomId, int unreadCount) {
        if (!this.isPushEnabledForUser(userName, roomId)) {
            return null;
        }
        HashMap<String, String> params = new HashMap<String, String>();
        String encodedId = URLEncoder.encode(eventId + "|" + roomId, StandardCharsets.UTF_8).replace("+", "%20");
        params.put("notificationId", encodedId);
        params.put("username", userName);
        params.put("action", "open");
        params.put("type", "CHAT_NOTIFICATION");
        return this.pwaNotificationService.create(params);
    }

    public PwaNotificationMessage createNotification(MatrixMessage message, String userName) {
        if (message != null) {
            PwaNotificationMessage pwaNotificationMessage = new PwaNotificationMessage();
            Room room = this.matrixService.getById(message.getRoomId());
            LocaleConfig localeConfig = this.pwaNotificationService.getLocaleConfig(userName);
            String sender = message.getSender();
            if (room != null) {
                if (StringUtils.isBlank((CharSequence)room.getSpaceId())) {
                    String senderUserName = room.getFirstParticipant().equals(userName) ? room.getSecondParticipant() : room.getFirstParticipant();
                    Identity senderIdentity = this.identityManager.getOrCreateUserIdentity(senderUserName);
                    String senderFullName = senderIdentity != null ? senderIdentity.getProfile().getFullName() : sender;
                    pwaNotificationMessage.setTitle(senderFullName);
                    pwaNotificationMessage.setIcon(senderIdentity != null ? senderIdentity.getProfile().getAvatarUrl() : "");
                } else {
                    Space space = this.spaceService.getSpaceById(room.getSpaceId());
                    Identity senderIdentity = this.matrixService.findSpaceMemberByMatrixId(sender, space);
                    String senderFullName = senderIdentity != null ? senderIdentity.getProfile().getFullName() : sender;
                    pwaNotificationMessage.setTitle(senderFullName + " " + this.resourceBundleService.getSharedString(IN_KEY, localeConfig.getLocale()) + " " + space.getDisplayName());
                    pwaNotificationMessage.setIcon(space.getAvatarUrl());
                }
                pwaNotificationMessage.setBody(message.getMessageContent());
                this.pwaNotificationService.setDefaultNotificationMessageProperties(pwaNotificationMessage, message.getEventId(), localeConfig);
                return pwaNotificationMessage;
            }
            return null;
        }
        return null;
    }

    public PwaNotificationMessage createNotification(String eventId, String roomId, String userName, String token) {
        MatrixMessage message = this.matrixService.getRoomEvent(eventId, roomId, token);
        return this.createNotification(message, userName);
    }

    public void createMentionNotification(String eventId, String roomId, String userName) {
        Room room = this.matrixService.getById(roomId);
        MatrixMessage message = this.matrixService.getRoomEvent(eventId, roomId);
        Identity receiverIdentity = this.identityManager.getOrCreateUserIdentity(userName);
        String matrixReceiverId = userName;
        if (receiverIdentity != null) {
            matrixReceiverId = (String)receiverIdentity.getProfile().getProperties().get("matrixId");
        }
        String roomName = "";
        String senderFullName = "";
        if (message != null && message.getMentionedUsers() != null && !message.getMentionedUsers().isEmpty() && message.getMentionedUsers().contains(matrixReceiverId) && room != null && StringUtils.isNotBlank((CharSequence)room.getSpaceId())) {
            Space space = this.spaceService.getSpaceById(room.getSpaceId());
            roomName = space.getDisplayName();
            Identity senderIdentity = this.matrixService.findSpaceMemberByMatrixId(message.getSender(), space);
            if (senderIdentity != null) {
                senderFullName = senderIdentity.getProfile().getFullName();
            }
            NotificationContext ctx = NotificationContextImpl.cloneInstance();
            ctx.append(MatrixConstants.MATRIX_ROOM_ID, (Object)message.getRoomId());
            ctx.append(MatrixConstants.MATRIX_ROOM_NAME, (Object)roomName);
            ctx.append(MatrixConstants.MATRIX_ROOM_MEMBER, (Object)userName);
            ctx.append(MatrixConstants.MATRIX_MESSAGE_SENDER_FULLNAME, (Object)senderFullName);
            ctx.getNotificationExecutor().with(ctx.makeCommand(PluginKey.key((String)"MatrixMentionReceivedNotificationPlugin"))).execute(ctx);
        }
    }

    public boolean isPrivateRoomMutedForUser(String userName, String roomId) {
        return this.getMutedRooms(userName).contains(roomId);
    }

    public void toggleMutePrivateRoom(String userName, String roomId) {
        HashSet<String> mutedRoomIds = new HashSet<String>(this.getMutedRooms(userName));
        boolean changed = mutedRoomIds.remove(roomId);
        if (!changed) {
            changed = mutedRoomIds.add(roomId);
        }
        if (changed) {
            this.settingService.set(Context.USER.id(userName), USER_CHAT_NOTIFICATION_SCOPE, MUTED_ROOMS, SettingValue.create((String)JsonUtils.toJsonString(mutedRoomIds)));
        }
    }

    private Set<String> getMutedRooms(String userName) {
        try {
            SettingValue settingValue = this.settingService.get(Context.USER.id(userName), USER_CHAT_NOTIFICATION_SCOPE, MUTED_ROOMS);
            if (settingValue == null || settingValue.getValue() == null) {
                return Collections.emptySet();
            }
            return (Set)JsonUtils.OBJECT_MAPPER.readValue(settingValue.getValue().toString(), (TypeReference)new TypeReference<Set<String>>(this){});
        }
        catch (Exception e) {
            LOG.error("Error reading muted rooms setting value for user {}", new Object[]{userName, e});
            return Collections.emptySet();
        }
    }

    private boolean isPushEnabledForUser(String userName, String roomId) {
        UserSetting userSetting;
        Room room = this.matrixService.getById(roomId);
        if (room == null) {
            return false;
        }
        boolean roomMuted = StringUtils.isNotBlank((CharSequence)room.getSpaceId()) ? (userSetting = ChatNotificationService.getUserSettingService().get(userName)) != null && userSetting.isSpaceMuted(Long.parseLong(room.getSpaceId())) : this.isPrivateRoomMutedForUser(userName, roomId);
        UserStateModel userStatus = ChatNotificationService.getUserStateService().getUserState(userName);
        return userStatus.getStatus().equals(USER_STATUS_AVAILABLE) && !roomMuted;
    }

    private static UserStateService getUserStateService() {
        if (userStateService == null) {
            userStateService = (UserStateService)CommonsUtils.getService(UserStateService.class);
        }
        return userStateService;
    }

    private static UserSettingService getUserSettingService() {
        if (userSettingService == null) {
            userSettingService = (UserSettingService)CommonsUtils.getService(UserSettingService.class);
        }
        return userSettingService;
    }

    static {
        IN_KEY = "matrix.words.in";
        USER_CHAT_NOTIFICATION_SCOPE = Scope.APPLICATION.id("ChatNotificationSettings");
    }
}

