/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.chat.service;

import com.fasterxml.jackson.core.type.TypeReference;
import io.meeds.chat.MatrixBaseTest;
import io.meeds.chat.model.MatrixMessage;
import io.meeds.chat.model.Room;
import io.meeds.chat.service.ChatNotificationService;
import io.meeds.chat.service.MatrixService;
import io.meeds.pwa.model.PwaNotificationMessage;
import io.meeds.pwa.service.PwaNotificationService;
import io.meeds.social.util.JsonUtils;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Set;
import org.exoplatform.commons.api.notification.model.NotificationInfo;
import org.exoplatform.commons.api.notification.model.UserSetting;
import org.exoplatform.commons.api.notification.model.WebNotificationFilter;
import org.exoplatform.commons.api.notification.service.WebNotificationService;
import org.exoplatform.commons.api.notification.service.setting.UserSettingService;
import org.exoplatform.commons.api.settings.SettingService;
import org.exoplatform.commons.api.settings.SettingValue;
import org.exoplatform.commons.api.settings.data.Context;
import org.exoplatform.commons.api.settings.data.Scope;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.commons.utils.CommonsUtils;
import org.exoplatform.services.resources.Orientation;
import org.exoplatform.services.resources.ResourceBundleService;
import org.exoplatform.services.resources.impl.LocaleConfigImpl;
import org.exoplatform.services.user.UserStateModel;
import org.exoplatform.services.user.UserStateService;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.websocket.entity.WebSocketMessage;
import org.exoplatform.ws.frameworks.cometd.ContinuationService;
import org.junit.jupiter.api.AfterEach;
import org.junit.jupiter.api.Assertions;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.Mock;
import org.mockito.MockedStatic;
import org.mockito.Mockito;
import org.mockito.stubbing.Answer;
import org.mockito.verification.VerificationMode;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.test.context.junit.jupiter.SpringJUnitConfig;
import org.springframework.test.util.ReflectionTestUtils;

@SpringJUnitConfig(value={MatrixBaseTest.class})
class ChatNotificationServiceTest
extends MatrixBaseTest {
    @Autowired
    MatrixService matrixService;
    @Autowired
    IdentityManager identityManager;
    @Autowired
    ChatNotificationService chatNotificationService;
    @Autowired
    PwaNotificationService pwaNotificationService;
    @Autowired
    WebNotificationService webNotificationService;
    @Mock
    private UserStateService userStateService;
    @Mock
    private UserStateModel userStateModel;
    @Mock
    private UserSetting userSetting;
    @Mock
    private UserSettingService userSettingService;
    @Mock
    private SettingService settingService;
    @Mock
    private ResourceBundleService resourceBundleService;
    @Mock
    private ContinuationService continuationService;
    private MockedStatic<CommonsUtils> commonsUtils;

    ChatNotificationServiceTest() {
    }

    @Override
    @BeforeEach
    public void setUp() throws Exception {
        super.setUp();
        this.commonsUtils = Mockito.mockStatic(CommonsUtils.class, (Answer)Mockito.CALLS_REAL_METHODS);
        this.commonsUtils.when(() -> CommonsUtils.getService(UserStateService.class)).thenReturn((Object)this.userStateService);
        this.commonsUtils.when(() -> CommonsUtils.getService(UserSettingService.class)).thenReturn((Object)this.userSettingService);
        this.commonsUtils.when(() -> CommonsUtils.getService(ContinuationService.class)).thenReturn((Object)this.continuationService);
        Mockito.when((Object)this.userStateService.getUserState(Mockito.anyString())).thenReturn((Object)this.userStateModel);
        Mockito.when((Object)this.userSettingService.get(Mockito.anyString())).thenReturn((Object)this.userSetting);
        ReflectionTestUtils.setField((Object)this.chatNotificationService, (String)"settingService", (Object)this.settingService);
    }

    @Override
    @AfterEach
    public void tearDown() {
        super.tearDown();
        if (this.commonsUtils != null) {
            this.commonsUtils.close();
        }
    }

    @Test
    void sendCreateNotificationAction() throws Exception {
        Space space = this.getSpaceInstance(2);
        String roomId = this.matrixService.getRoomBySpace(space).getRoomId();
        PwaNotificationService mockedPWANotificationService = (PwaNotificationService)Mockito.mock(PwaNotificationService.class);
        ReflectionTestUtils.setField((Object)this.chatNotificationService, (String)"pwaNotificationService", (Object)mockedPWANotificationService);
        String eventId = "eventIDOnMatrix";
        MatrixMessage matrixMessage = new MatrixMessage(eventId, roomId, "m.room.message", "Message content", "m.text", "@sender:matrix.meeds.tn", Collections.singletonList("@demo:matrix.meeds.tn"), 123456789L);
        Mockito.when((Object)this.matrixHttpClient.getEventById(eventId, roomId, this.accessToken)).thenReturn((Object)matrixMessage);
        Mockito.when((Object)this.continuationService.isPresent(Mockito.anyString())).thenReturn((Object)false);
        Mockito.when((Object)this.userStateModel.getStatus()).thenReturn((Object)"available");
        this.chatNotificationService.sendCreateNotificationAction(eventId, "demo", roomId, 5);
        ((PwaNotificationService)Mockito.verify((Object)mockedPWANotificationService, (VerificationMode)Mockito.times((int)1))).create((Map)Mockito.any(Map.class));
        Mockito.when((Object)this.userSetting.isSpaceMuted(Mockito.anyLong())).thenReturn((Object)false);
        this.chatNotificationService.sendCreateNotificationAction(eventId, "demo", roomId, 5);
        ((PwaNotificationService)Mockito.verify((Object)mockedPWANotificationService, (VerificationMode)Mockito.times((int)2))).create((Map)Mockito.any(Map.class));
        Mockito.when((Object)this.userStateModel.getStatus()).thenReturn((Object)"donotdisturb");
        Mockito.when((Object)this.userSetting.isSpaceMuted(Mockito.anyLong())).thenReturn((Object)false);
        this.chatNotificationService.sendCreateNotificationAction(eventId, "demo", roomId, 5);
        ((PwaNotificationService)Mockito.verify((Object)mockedPWANotificationService, (VerificationMode)Mockito.times((int)2))).create((Map)Mockito.any(Map.class));
        Mockito.when((Object)this.userStateModel.getStatus()).thenReturn((Object)"available");
        Mockito.when((Object)this.userSetting.isSpaceMuted(Mockito.anyLong())).thenReturn((Object)true);
        this.chatNotificationService.sendCreateNotificationAction(eventId, "demo", roomId, 5);
        ((PwaNotificationService)Mockito.verify((Object)mockedPWANotificationService, (VerificationMode)Mockito.times((int)2))).create((Map)Mockito.any(Map.class));
        Mockito.when((Object)this.continuationService.isPresent(Mockito.anyString())).thenReturn((Object)true);
        Mockito.when((Object)this.userStateModel.getStatus()).thenReturn((Object)"available");
        Mockito.when((Object)this.userSetting.isSpaceMuted(Mockito.anyLong())).thenReturn((Object)false);
        this.chatNotificationService.sendCreateNotificationAction(eventId, "demo", roomId, 5);
        ((ContinuationService)Mockito.verify((Object)this.continuationService, (VerificationMode)Mockito.times((int)1))).sendMessage(Mockito.anyString(), Mockito.anyString(), Mockito.any(WebSocketMessage.class));
        Mockito.when((Object)this.userStateModel.getStatus()).thenReturn((Object)"donotdisturb");
        Mockito.when((Object)this.userSetting.isSpaceMuted(Mockito.anyLong())).thenReturn((Object)false);
        this.chatNotificationService.sendCreateNotificationAction(eventId, "demo", roomId, 5);
        ((ContinuationService)Mockito.verify((Object)this.continuationService, (VerificationMode)Mockito.times((int)1))).sendMessage(Mockito.anyString(), Mockito.anyString(), Mockito.any(WebSocketMessage.class));
        Mockito.when((Object)this.userStateModel.getStatus()).thenReturn((Object)"available");
        Mockito.when((Object)this.userSetting.isSpaceMuted(Mockito.anyLong())).thenReturn((Object)true);
        this.chatNotificationService.sendCreateNotificationAction(eventId, "demo", roomId, 5);
        ((ContinuationService)Mockito.verify((Object)this.continuationService, (VerificationMode)Mockito.times((int)1))).sendMessage(Mockito.anyString(), Mockito.anyString(), Mockito.any(WebSocketMessage.class));
    }

    @Test
    void createNotification() throws Exception {
        Mockito.when((Object)this.userStateModel.getStatus()).thenReturn((Object)"available");
        Mockito.when((Object)this.userSetting.isSpaceMuted(Mockito.anyLong())).thenReturn((Object)false);
        String eventId = "eventIDOnMatrix";
        Space space = this.getSpaceInstance(1);
        String roomId = this.matrixService.getRoomBySpace(space).getRoomId();
        String userName = "demo";
        Identity demoIdentity = this.identityManager.getOrCreateUserIdentity("demo");
        String userIdOnMatrix = this.matrixService.saveUserAccount(demoIdentity, true);
        MatrixMessage matrixMessage = new MatrixMessage(eventId, roomId, "m.room.message", "This is a chat message", "m.text", userIdOnMatrix, new ArrayList(), 123456789L);
        Mockito.when((Object)this.matrixHttpClient.getEventById(eventId, this.matrixRoomId, this.accessToken)).thenReturn((Object)matrixMessage);
        LocaleConfigImpl localeConfig = new LocaleConfigImpl();
        localeConfig.setLocale(Locale.ENGLISH);
        localeConfig.setOrientation(Orientation.LT);
        PwaNotificationMessage pwaNotificationMessage = this.chatNotificationService.createNotification(eventId, this.matrixRoomId, userName, 0L, this.accessToken);
        Assertions.assertNotNull((Object)pwaNotificationMessage);
        Assertions.assertEquals((Object)"Demo exo in my space 1", (Object)pwaNotificationMessage.getTitle());
        Assertions.assertEquals((Object)"This is a chat message", (Object)pwaNotificationMessage.getBody());
        Room oneToOneRoom = new Room();
        oneToOneRoom.setRoomId("!oneToOneRoom:matrix.meeds.tn");
        oneToOneRoom.setFirstParticipant("demo");
        oneToOneRoom.setSecondParticipant("tom");
        oneToOneRoom = this.matrixService.createDirectMessagingRoom(oneToOneRoom);
        Identity tomIdentity = this.identityManager.getOrCreateUserIdentity("tom");
        matrixMessage = new MatrixMessage(eventId, oneToOneRoom.getRoomId(), "m.room.message", "This is a private chat message", "m.text", userIdOnMatrix, new ArrayList(), 123456789L);
        Mockito.when((Object)this.matrixHttpClient.getEventById(eventId, oneToOneRoom.getRoomId(), this.accessToken)).thenReturn((Object)matrixMessage);
        pwaNotificationMessage = this.chatNotificationService.createNotification(eventId, oneToOneRoom.getRoomId(), userName, 0L, this.accessToken);
        Assertions.assertNotNull((Object)pwaNotificationMessage);
        Assertions.assertNotNull((Object)pwaNotificationMessage.getIcon());
        Assertions.assertEquals((Object)tomIdentity.getProfile().getFullName(), (Object)pwaNotificationMessage.getTitle());
        Assertions.assertEquals((Object)"This is a private chat message", (Object)pwaNotificationMessage.getBody());
    }

    @Test
    void createMentionNotification() throws Exception {
        String eventId = "eventIDOnMatrix";
        Identity demoIdentity = this.identityManager.getOrCreateUserIdentity("demo");
        String userIdOnMatrix = this.matrixService.saveUserAccount(demoIdentity, true);
        MatrixMessage matrixMessage = new MatrixMessage(eventId, "fakeRoomId", "m.room.message", "This is a chat message", "m.text", userIdOnMatrix, Collections.singletonList("@demo:matrix.meeds.tn"), 123456789L);
        Mockito.when((Object)this.matrixHttpClient.getEventById(eventId, this.matrixRoomId, this.accessToken)).thenReturn((Object)matrixMessage);
        boolean result = this.chatNotificationService.createMentionNotification(eventId, "fakeRoomId", "demo", null);
        Assertions.assertFalse((boolean)result);
        Space space = this.getSpaceInstance(1);
        this.spacesToDelete.add(space);
        String roomId = this.matrixService.getRoomBySpace(space).getRoomId();
        matrixMessage.setRoomId(roomId);
        result = this.chatNotificationService.createMentionNotification(eventId, roomId, "demo", null);
        Assertions.assertTrue((boolean)result);
        Room room = new Room();
        room.setRoomId("!privateRoomId");
        room.setFirstParticipant("demo");
        room.setSecondParticipant("raul");
        room = this.matrixService.createDirectMessagingRoom(room);
        matrixMessage.setRoomId(room.getRoomId());
        result = this.chatNotificationService.createMentionNotification(eventId, room.getRoomId(), "demo", null);
        Assertions.assertFalse((boolean)result);
        Mockito.when((Object)this.matrixHttpClient.getAccessToken(Mockito.anyString())).thenReturn((Object)"sys_thisIsAFakeAccessToken2025");
        Mockito.when((Object)this.matrixHttpClient.getEventById(eventId, room.getRoomId(), "sys_thisIsAFakeAccessToken2025")).thenReturn((Object)matrixMessage);
        String userAsJson = "{\n    \"name\": \"@raul:matrix.meeds.tn\",\n    \"displayname\": \"Raul Hamdi\", // can be null if not set\n    \"threepids\": [\n        {\n            \"medium\": \"email\",\n            \"address\": \"raul@platform.com\",\n            \"added_at\": 1586458409743,\n            \"validated_at\": 1586458409743\n        },\n    ],\n}\n";
        Mockito.when((Object)this.matrixHttpClient.getUser(Mockito.anyString(), Mockito.anyString())).thenReturn((Object)userAsJson);
        result = this.chatNotificationService.createMentionNotification(eventId, room.getRoomId(), "demo", "ASamplePushKey");
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void sendPushNotification() throws ObjectNotFoundException, IllegalAccessException {
        NotificationInfo notificationInfo = NotificationInfo.instance().setFrom("raul").to("demo").with("ROOM_ID", "!roomIdenitfier:matrix.meeds.tn").with("MATRIX_ROOM_NAME", "Sample room").with("MATRIX_ROOM_TYPE", "SPACE").with("MATRIX_SENDER_FULL_NAME", "Raul Hamdi").with("MATRIX_ROOM_AVATAR", "/path/to/room").with("MATRIX_MESSAGE_URL", "/link/to/room/message").with("MATRIX_MESSAGE_CONTENT", "This is a message for testing !").key("MatrixMentionReceivedNotificationPlugin").end();
        this.webNotificationService.save(notificationInfo);
        WebNotificationFilter filter = new WebNotificationFilter("demo");
        List notifications = this.webNotificationService.getNotificationInfos(filter, 0, 10);
        for (NotificationInfo notif : notifications) {
            PwaNotificationMessage pwaNotificationMessage = this.pwaNotificationService.getNotification(1L, "demo");
            Assertions.assertNotNull((Object)pwaNotificationMessage);
            Assertions.assertEquals((Object)"Raul Hamdi mentioned you in Sample room", (Object)pwaNotificationMessage.getTitle());
            Assertions.assertEquals((Object)"This is a message for testing !", (Object)pwaNotificationMessage.getBody());
        }
    }

    @Test
    void isPushNotificationsEnabled() {
        Mockito.when((Object)this.settingService.get(Context.USER.id("demo"), ChatNotificationService.USER_CHAT_NOTIFICATION_SCOPE, "pushNotificationsSettings")).thenReturn(null);
        boolean result = this.chatNotificationService.isPushNotificationsEnabled("demo");
        Assertions.assertTrue((boolean)result);
    }

    @Test
    void updatePushNotificationSettings() {
        this.chatNotificationService.updatePushNotificationSettings("demo", true);
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)1))).set((Context)Mockito.eq((Object)Context.USER.id("demo")), (Scope)Mockito.eq((Object)ChatNotificationService.USER_CHAT_NOTIFICATION_SCOPE), (String)Mockito.eq((Object)"pushNotificationsSettings"), (SettingValue)Mockito.any());
    }

    @Test
    void testIsRoomMutedForUser() {
        String userName = "demo";
        String mutedRoomId = "!mutedRoom:matrix.meeds.tn";
        String otherRoomId = "!otherRoom:matrix.meeds.tn";
        Scope scope = ChatNotificationService.USER_CHAT_NOTIFICATION_SCOPE;
        String key = "mutedRooms";
        SettingValue settingValue = SettingValue.create((String)JsonUtils.toJsonString(Set.of(mutedRoomId)));
        Mockito.when((Object)this.settingService.get(Context.USER.id(userName), scope, key)).thenReturn((Object)settingValue);
        Assertions.assertTrue((boolean)this.chatNotificationService.isPrivateRoomMutedForUser(userName, mutedRoomId));
        SettingValue otherSettingValue = SettingValue.create((String)JsonUtils.toJsonString(Set.of(otherRoomId)));
        Mockito.when((Object)this.settingService.get(Context.USER.id(userName), scope, key)).thenReturn((Object)otherSettingValue);
        Assertions.assertFalse((boolean)this.chatNotificationService.isPrivateRoomMutedForUser(userName, mutedRoomId));
        Mockito.when((Object)this.settingService.get(Context.USER.id(userName), scope, key)).thenReturn(null);
        Assertions.assertFalse((boolean)this.chatNotificationService.isPrivateRoomMutedForUser(userName, mutedRoomId));
    }

    @Test
    void testToggleMutePrivateRoom() {
        String userName = "demo";
        String roomId = "!newRoom:matrix.meeds.tn";
        Scope scope = ChatNotificationService.USER_CHAT_NOTIFICATION_SCOPE;
        String key = "mutedRooms";
        Set[] currentMutedRooms = new Set[]{new HashSet()};
        Mockito.when((Object)this.settingService.get((Context)Mockito.eq((Object)Context.USER.id(userName)), (Scope)Mockito.eq((Object)scope), (String)Mockito.eq((Object)key))).thenAnswer(invocation -> SettingValue.create((String)JsonUtils.toJsonString((Object)currentMutedRooms[0])));
        ((SettingService)Mockito.doAnswer(invocation -> {
            String json = ((SettingValue)invocation.getArgument(3, SettingValue.class)).getValue().toString();
            currentMutedRooms[0] = (Set)JsonUtils.OBJECT_MAPPER.readValue(json, (TypeReference)new TypeReference<Set<String>>(this){});
            return null;
        }).when((Object)this.settingService)).set((Context)Mockito.any(), (Scope)Mockito.any(), (String)Mockito.any(), (SettingValue)Mockito.any());
        this.chatNotificationService.toggleMutePrivateRoom(userName, roomId);
        Assertions.assertTrue((boolean)currentMutedRooms[0].contains(roomId));
        this.chatNotificationService.toggleMutePrivateRoom(userName, roomId);
        Assertions.assertFalse((boolean)currentMutedRooms[0].contains(roomId));
        ((SettingService)Mockito.verify((Object)this.settingService, (VerificationMode)Mockito.times((int)2))).set((Context)Mockito.eq((Object)Context.USER.id(userName)), (Scope)Mockito.eq((Object)scope), (String)Mockito.eq((Object)key), (SettingValue)Mockito.any());
    }
}

