/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.ManyToOne;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.exoplatform.commons.api.persistence.ExoEntity;
import org.exoplatform.wiki.jpa.entity.BasePageEntity;
import org.exoplatform.wiki.jpa.entity.PageEntity;

@Entity(name="WikiPageVersionEntity")
@ExoEntity
@Table(name="WIKI_PAGE_VERSIONS")
@NamedQueries(value={@NamedQuery(name="wikiPageVersion.getLastversionNumberOfPage", query="SELECT max(p.versionNumber) FROM WikiPageVersionEntity p WHERE p.page.id = :pageId"), @NamedQuery(name="wikiPageVersion.getPageversionByPageIdAndVersion", query="SELECT p FROM WikiPageVersionEntity p WHERE p.page.id = :pageId AND p.versionNumber = :versionNumber"), @NamedQuery(name="wikiPageVersion.getAllPagesVersionsBySyntax", query="SELECT p FROM WikiPageVersionEntity p WHERE p.syntax = :syntax OR p.syntax IS NULL ORDER BY p.updatedDate DESC"), @NamedQuery(name="wikiPageVersion.countAllPagesVersionsBySyntax", query="SELECT COUNT(p) FROM WikiPageVersionEntity p WHERE p.syntax = :syntax OR p.syntax IS NULL"), @NamedQuery(name="wikiPageVersion.getPageVersionsByPageIdAndLang", query="SELECT p FROM WikiPageVersionEntity p WHERE p.page.id = :pageId AND ((:lang IS NULL AND p.lang IS NULL) OR (:lang IS NOT NULL AND p.lang = :lang))"), @NamedQuery(name="wikiPageVersion.getLatestPageVersionsByPageIdAndLang", query="SELECT p FROM WikiPageVersionEntity p WHERE p.page.id = :pageId AND ((:lang IS NULL AND p.lang IS NULL) OR (:lang IS NOT NULL AND p.lang = :lang)) ORDER BY  p.versionNumber DESC"), @NamedQuery(name="wikiPageVersion.getPageAvailableTranslationLanguages", query="SELECT DISTINCT p.lang FROM WikiPageVersionEntity p WHERE p.page.id = :pageId AND p.lang IS NOT NULL")})
public class PageVersionEntity
extends BasePageEntity {
    @Id
    @SequenceGenerator(name="SEQ_WIKI_PAGE_VERSIONS_VERS_ID", sequenceName="SEQ_WIKI_PAGE_VERSIONS_VERS_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WIKI_PAGE_VERSIONS_VERS_ID")
    @Column(name="PAGE_VERSION_ID")
    private long id;
    @ManyToOne
    @JoinColumn(name="PAGE_ID")
    private PageEntity page;
    @Column(name="VERSION_NUMBER")
    private long versionNumber;
    @Column(name="EDITION_COMMENT")
    private String comment;
    @Column(name="MINOR_EDIT")
    private boolean minorEdit;
    @Column(name="LANG")
    private String lang;

    public long getId() {
        return this.id;
    }

    public PageEntity getPage() {
        return this.page;
    }

    public void setPage(PageEntity page) {
        this.page = page;
    }

    public long getVersionNumber() {
        return this.versionNumber;
    }

    public void setVersionNumber(long versionNumber) {
        this.versionNumber = versionNumber;
    }

    public String getComment() {
        return this.comment;
    }

    public void setComment(String comment) {
        this.comment = comment;
    }

    public boolean isMinorEdit() {
        return this.minorEdit;
    }

    public void setMinorEdit(boolean minorEdit) {
        this.minorEdit = minorEdit;
    }

    public String getLang() {
        return this.lang;
    }

    public void setLang(String lang) {
        this.lang = lang;
    }
}

