/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.BufferedWriter;
import java.io.ByteArrayInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileWriter;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.StandardCopyOption;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import java.util.zip.ZipEntry;
import java.util.zip.ZipOutputStream;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.container.component.RequestLifeCycle;
import org.exoplatform.services.log.ExoLogger;
import org.exoplatform.services.log.Log;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.common.service.HTMLUploadImageProcessor;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.model.Attachment;
import org.exoplatform.wiki.model.ExportList;
import org.exoplatform.wiki.model.NoteToExport;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.ExportData;
import org.exoplatform.wiki.service.ExportResource;
import org.exoplatform.wiki.service.ExportStatus;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.NotesExportService;
import org.exoplatform.wiki.service.WikiService;

public class ExportThread
implements Runnable {
    private static final Log log = ExoLogger.getLogger(ExportThread.class);
    private static final String IMAGE_URL_REPLACEMENT_PREFIX = "//-";
    private static final String IMAGE_URL_REPLACEMENT_SUFFIX = "-//";
    private static final String EXPORT_ZIP_EXTENSION = ".zip";
    private static final String EXPORT_ZIP_PREFIX = "exportzip";
    private static final String TEMP_DIRECTORY_PATH = "java.io.tmpdir";
    private final NoteService noteService;
    private final WikiService wikiService;
    private final NotesExportService notesExportService;
    private final HTMLUploadImageProcessor htmlUploadImageProcessor;
    private final ExportData exportData;

    public ExportThread(NoteService noteService, WikiService wikiService, NotesExportService notesExportService, HTMLUploadImageProcessor htmlUploadImageProcessor, ExportData exportData) {
        this.noteService = noteService;
        this.wikiService = wikiService;
        this.notesExportService = notesExportService;
        this.htmlUploadImageProcessor = htmlUploadImageProcessor;
        this.exportData = exportData;
    }

    public static void cleanUp(File file) throws IOException {
        if (Files.exists(file.toPath(), new LinkOption[0])) {
            Files.delete(file.toPath());
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static File zipFiles(String zipFileName, List<File> addToZip, NotesExportService notesExportService, int exportId) throws IOException {
        String zipPath = System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + zipFileName;
        FileOutputStream fos = new FileOutputStream(zipPath);
        try (ZipOutputStream zipOut = new ZipOutputStream(fos);){
            for (File fileToZip : addToZip) {
                ExportResource exportResource = notesExportService.getExportRessourceById(exportId);
                if (exportResource.getStatus().equals(ExportStatus.CANCELLED.name())) {
                    File file = null;
                    return file;
                }
                try (FileInputStream fis = new FileInputStream(fileToZip);){
                    int length;
                    ZipEntry zipEntry = new ZipEntry(fileToZip.getName());
                    zipOut.putNextEntry(zipEntry);
                    byte[] bytes = new byte[1024];
                    while ((length = fis.read(bytes)) >= 0) {
                        zipOut.write(bytes, 0, length);
                    }
                    fis.close();
                }
                catch (IOException e) {
                    log.warn("cannot add the file: {} to the zip", new Object[]{fileToZip.getName()});
                }
            }
            fos.close();
        }
        catch (IOException e) {
            log.warn((Object)"cannot zip files");
        }
        File zip = new File(zipPath);
        if (zip.exists()) return zip;
        throw new FileNotFoundException("The created zip file could not be found");
    }

    @Override
    public void run() {
        try {
            RequestLifeCycle.begin((ExoContainer)PortalContainer.getInstance());
            this.processExport(this.exportData.getExportId(), this.exportData.getNotesToExportIds(), this.exportData.isExportAll(), this.exportData.getIdentity());
        }
        catch (IOException e) {
            log.error((Object)"cannot Export Notes", (Throwable)e);
        }
        finally {
            RequestLifeCycle.end();
        }
    }

    public void processExport(int exportId, String[] notesToExportIds, boolean exportAll, Identity identity) throws IOException {
        File zipFile = null;
        ExportResource exportResource = this.notesExportService.getExportRessourceById(exportId);
        if (exportResource != null) {
            String json;
            exportResource.setStatus(ExportStatus.IN_PROGRESS.name());
            exportResource.getAction().setStarted(true);
            exportResource.getAction().setAction("GETTING_NOTES");
            Page note_ = null;
            ArrayList<NoteToExport> noteToExportList = new ArrayList<NoteToExport>();
            if (exportAll) {
                for (String noteId : notesToExportIds) {
                    try {
                        NoteToExport noteToExport;
                        Page note = this.noteService.getNoteById(noteId, identity);
                        if (note == null) {
                            log.warn("Failed to export note {}: note not find ", new Object[]{noteId});
                            continue;
                        }
                        if (note_ == null) {
                            note_ = note;
                        }
                        if ((noteToExport = this.getNoteToExport(new NoteToExport(note.getId(), note.getName(), note.getOwner(), note.getAuthor(), note.getContent(), note.getSyntax(), note.getTitle(), note.getComment(), note.getWikiId(), note.getWikiType(), note.getWikiOwner()), exportId)) == null && (exportResource = this.notesExportService.getExportRessourceById(exportId)).getStatus().equals(ExportStatus.CANCELLED.name())) {
                            return;
                        }
                        noteToExportList.add(noteToExport);
                        exportResource.getAction().setNotesGetted(true);
                    }
                    catch (IllegalAccessException e) {
                        log.error("User does not have  permissions on the note {}", new Object[]{noteId, e});
                    }
                    catch (Exception ex) {
                        log.warn("Failed to export note {} ", new Object[]{noteId, ex});
                        Thread.currentThread().interrupt();
                    }
                }
            } else {
                ArrayList<NoteToExport> allNotesToExport = new ArrayList<NoteToExport>();
                int maxAncestors = 0;
                for (String noteId : notesToExportIds) {
                    try {
                        Page note = this.noteService.getNoteById(noteId, identity);
                        if (note == null) {
                            log.warn("Failed to export note {}: note not find ", new Object[]{noteId});
                            continue;
                        }
                        NoteToExport noteToExport = new NoteToExport(note.getId(), note.getName(), note.getOwner(), note.getAuthor(), note.getContent(), note.getSyntax(), note.getTitle(), note.getComment(), note.getWikiId(), note.getWikiType(), note.getWikiOwner());
                        noteToExport.setContent(this.processImagesForExport(note));
                        noteToExport.setContent(this.processNotesLinkForExport(noteToExport));
                        Iterator ancestors = this.getNoteAncestorsIds(noteToExport.getId());
                        noteToExport.setAncestors((LinkedList<String>)((Object)ancestors));
                        if (((LinkedList)((Object)ancestors)).size() > maxAncestors) {
                            maxAncestors = ((LinkedList)((Object)ancestors)).size();
                        }
                        allNotesToExport.add(noteToExport);
                        exportResource = this.notesExportService.getExportRessourceById(exportId);
                        if (exportResource.getStatus().equals(ExportStatus.CANCELLED.name())) {
                            this.notesExportService.removeExportResource(exportId);
                            return;
                        }
                        exportResource.setExportedNotesCount(exportResource.getExportedNotesCount() + 1);
                    }
                    catch (IllegalAccessException e) {
                        log.error("User does not have  permissions on the note {}", new Object[]{noteId, e});
                    }
                    catch (Exception ex) {
                        log.warn("Failed to export note {} ", new Object[]{noteId, ex});
                    }
                }
                exportResource.getAction().setNotesGetted(true);
                exportResource.getAction().setAction("UPDATING_NOTES_PARENTS");
                for (NoteToExport noteToExport : allNotesToExport) {
                    noteToExport.setParent(this.getParentOfNoteFromExistingNotes(noteToExport.getAncestors(), allNotesToExport, notesToExportIds));
                }
                if (exportResource.getStatus().equals(ExportStatus.CANCELLED.name())) {
                    this.notesExportService.removeExportResource(exportId);
                    return;
                }
                for (int level = maxAncestors; level >= 0; --level) {
                    List<NoteToExport> bottomNotes = this.getBottomNotesToExport(allNotesToExport, level);
                    for (NoteToExport bottomNote : bottomNotes) {
                        NoteToExport parent = bottomNote.getParent();
                        if (parent == null) continue;
                        List<NoteToExport> children = parent.getChildren();
                        if (children != null) {
                            children.add(bottomNote);
                        } else {
                            children = new ArrayList<NoteToExport>(Collections.singletonList(bottomNote));
                        }
                        for (NoteToExport noteToExport : children) {
                            NoteToExport currentParent = new NoteToExport(parent);
                            currentParent.setChildren(null);
                            currentParent.setParent(null);
                            noteToExport.setParent(currentParent);
                        }
                        parent.setChildren(children);
                        allNotesToExport.remove(bottomNote);
                        allNotesToExport.set(allNotesToExport.indexOf(parent), parent);
                    }
                }
                noteToExportList.addAll(allNotesToExport);
            }
            exportResource = this.notesExportService.getExportRessourceById(exportId);
            if (exportResource.getStatus().equals(ExportStatus.CANCELLED.name())) {
                this.notesExportService.removeExportResource(exportId);
                return;
            }
            exportResource.getAction().setNotesPrepared(true);
            exportResource.getAction().setAction("CREATING_CONTENT_DATA");
            if (exportResource.getStatus().equals(ExportStatus.CANCELLED.name())) {
                this.notesExportService.removeExportResource(exportId);
                return;
            }
            ExportList notesExport = new ExportList(new Date().getTime(), noteToExportList);
            exportResource.setNotesExport(notesExport);
            ArrayList<File> files = new ArrayList<File>();
            File temp = File.createTempFile("notesExport_" + new Date().getTime(), ".json");
            ObjectMapper mapper = new ObjectMapper();
            String contentUpdated = json = mapper.writeValueAsString((Object)notesExport);
            String fileName = "";
            Object filePath = "";
            exportResource.getAction().setJsonCreated(true);
            exportResource.getAction().setAction("UPDATING_IMAGES_URLS");
            while (contentUpdated.contains(IMAGE_URL_REPLACEMENT_PREFIX)) {
                fileName = contentUpdated.split(IMAGE_URL_REPLACEMENT_PREFIX)[1].split(IMAGE_URL_REPLACEMENT_SUFFIX)[0];
                filePath = System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + fileName;
                files.add(new File((String)filePath));
                contentUpdated = contentUpdated.replace(IMAGE_URL_REPLACEMENT_PREFIX + fileName + IMAGE_URL_REPLACEMENT_SUFFIX, "");
            }
            exportResource = this.notesExportService.getExportRessourceById(exportId);
            if (exportResource.getStatus().equals(ExportStatus.CANCELLED.name())) {
                for (File file : files) {
                    ExportThread.cleanUp(file);
                }
                this.notesExportService.removeExportResource(exportId);
                return;
            }
            exportResource.getAction().setImageUrlsUpdated(true);
            try (BufferedWriter bw = new BufferedWriter(new FileWriter(temp));){
                bw.write(json);
            }
            files.add(temp);
            exportResource = this.notesExportService.getExportRessourceById(exportId);
            if (exportResource.getStatus().equals(ExportStatus.CANCELLED.name())) {
                for (File file : files) {
                    ExportThread.cleanUp(file);
                }
                this.notesExportService.removeExportResource(exportId);
                return;
            }
            exportResource.getAction().setAction("CREATING_ZIP_FILE");
            String zipName = EXPORT_ZIP_PREFIX + exportId + EXPORT_ZIP_EXTENSION;
            exportResource.setZipFile(zipFile);
            zipFile = ExportThread.zipFiles(zipName, files, this.notesExportService, exportId);
            exportResource.setZipFile(zipFile);
            exportResource = this.notesExportService.getExportRessourceById(exportId);
            if (exportResource.getStatus().equals(ExportStatus.CANCELLED.name())) {
                for (File file : files) {
                    ExportThread.cleanUp(file);
                }
                if (zipFile != null) {
                    ExportThread.cleanUp(zipFile);
                }
                this.notesExportService.removeExportResource(exportId);
                return;
            }
            String string = new SimpleDateFormat("dd_MM_yyyy").format(new Date());
            if (zipFile != null && note_ != null && note_.getWikiType().toUpperCase().equals(WikiType.GROUP.name())) {
                this.htmlUploadImageProcessor.uploadSpaceFile(zipFile.getPath(), note_.getWikiOwner(), "notesExport_" + string + EXPORT_ZIP_EXTENSION, "Documents/Notes/exports");
            }
            if (zipFile != null && note_ != null && note_.getWikiType().toUpperCase().equals(WikiType.USER.name())) {
                this.htmlUploadImageProcessor.uploadUserFile(zipFile.getPath(), note_.getWikiOwner(), "notesExport_" + string + EXPORT_ZIP_EXTENSION, "Documents/Notes/exports");
            }
            exportResource.setStatus(ExportStatus.ZIP_CREATED.name());
            exportResource.getAction().setZipCreated(true);
            exportResource.getAction().setAction("CLEANING_TEMP_FILE");
            for (File file : files) {
                ExportThread.cleanUp(file);
            }
            exportResource.getAction().setAction("EXPORT_DATA_CREATED");
        }
    }

    private List<NoteToExport> getBottomNotesToExport(List<NoteToExport> allNotesToExport, int level) {
        return allNotesToExport.stream().filter(export -> export.getAncestors().size() == level).collect(Collectors.toList());
    }

    private NoteToExport getParentOfNoteFromExistingNotes(LinkedList<String> ancestors, List<NoteToExport> exports, String[] noteIds) {
        NoteToExport parent = null;
        Iterator<String> descendingIterator = ancestors.descendingIterator();
        String parentId = null;
        boolean parentFound = false;
        while (descendingIterator.hasNext() && !parentFound) {
            String current = descendingIterator.next();
            if (!Arrays.asList(noteIds).contains(current)) continue;
            parentId = current;
            parentFound = true;
        }
        if (parentId != null) {
            String finalParentId = parentId;
            Optional<NoteToExport> parentToExport = exports.stream().filter(export -> export.getId().equals(finalParentId)).findFirst();
            if (parentToExport.isPresent()) {
                parent = parentToExport.get();
            }
        }
        return parent;
    }

    public NoteToExport getNoteToExport(NoteToExport note, int exportId) throws WikiException, IOException, InterruptedException {
        try {
            note.setContent(this.processImagesForExport(this.noteService.getNoteById(note.getId())));
        }
        catch (Exception e) {
            log.warn("Cannot process images for note {}", new Object[]{note.getId()});
        }
        try {
            note.setContent(this.processNotesLinkForExport(note));
        }
        catch (Exception e) {
            log.warn("Cannot process notes link for note {}", new Object[]{note.getId()});
        }
        ExportResource exportResource = this.notesExportService.getExportRessourceById(exportId);
        if (exportResource != null) {
            exportResource.setExportedNotesCount(exportResource.getExportedNotesCount() + 1);
            if (exportResource.getStatus().equals(ExportStatus.CANCELLED.name())) {
                return null;
            }
        }
        List<NoteToExport> children = this.noteService.getChildrenNoteOf(note);
        for (NoteToExport child : children) {
            child.setParent(note);
        }
        note.setChildren(children);
        note.setParent(this.noteService.getParentNoteOf(note));
        for (NoteToExport child : children) {
            this.getNoteToExport(child, exportId);
        }
        return note;
    }

    public String processNotesLinkForExport(NoteToExport note) throws WikiException {
        String content = note.getContent();
        String noteLinkprefix = "class=\"noteLink\" href=\"";
        String contentUpdated = content;
        HashMap<String, String> urlToReplaces = new HashMap<String, String>();
        while (contentUpdated.contains("noteLink")) {
            String checkContent = contentUpdated;
            String noteId = contentUpdated.split(noteLinkprefix)[1].split("\"")[0];
            Page linkedNote = null;
            try {
                linkedNote = this.noteService.getNoteById(noteId);
            }
            catch (NumberFormatException e) {
                Page note_ = this.noteService.getNoteById(note.getId());
                linkedNote = this.noteService.getNoteOfNoteBookByName(note_.getWikiType(), note_.getWikiOwner(), noteId);
            }
            if (linkedNote != null) {
                String noteParams = IMAGE_URL_REPLACEMENT_PREFIX + linkedNote.getWikiType() + "-////-" + linkedNote.getWikiOwner() + "-////-" + linkedNote.getName() + IMAGE_URL_REPLACEMENT_SUFFIX;
                urlToReplaces.put(noteLinkprefix + linkedNote.getId() + "\"", noteLinkprefix + noteParams + "\"");
            }
            if (!(contentUpdated = contentUpdated.replace(noteLinkprefix + noteId + "\"", "")).equals(checkContent)) continue;
            break;
        }
        if (!urlToReplaces.isEmpty()) {
            content = this.replaceUrl(content, urlToReplaces);
        }
        return content;
    }

    public List<File> getFilesfromContent(NoteToExport note, List<File> files) throws WikiException {
        String contentUpdated = note.getContent();
        String fileName = "";
        Object filePath = "";
        while (contentUpdated.contains(IMAGE_URL_REPLACEMENT_PREFIX)) {
            fileName = contentUpdated.split(IMAGE_URL_REPLACEMENT_PREFIX)[1].split(IMAGE_URL_REPLACEMENT_SUFFIX)[0];
            filePath = System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + fileName;
            files.add(new File((String)filePath));
            contentUpdated = contentUpdated.replace(IMAGE_URL_REPLACEMENT_PREFIX + fileName + IMAGE_URL_REPLACEMENT_SUFFIX, "");
        }
        List<NoteToExport> children = this.noteService.getChildrenNoteOf(note);
        for (NoteToExport child : children) {
            this.getFilesfromContent(child, files);
        }
        return files;
    }

    public String processImagesForExport(Page note) throws WikiException, IOException {
        String content = note.getContent();
        String restUploadUrl = "/portal/rest/wiki/attachments/";
        HashMap<String, String> urlToReplaces = new HashMap<String, String>();
        while (content.contains(restUploadUrl)) {
            String checkContent = content;
            Object urlToReplace = content.split(restUploadUrl)[1].split("\"")[0];
            String attachmentId = StringUtils.substringAfterLast((String)(urlToReplace = restUploadUrl + (String)urlToReplace), (String)"/");
            Attachment attachment = this.wikiService.getAttachmentOfPageByName(attachmentId, note, true);
            if (attachment != null && attachment.getContent() != null) {
                ByteArrayInputStream bis = new ByteArrayInputStream(attachment.getContent());
                File tempFile = new File(System.getProperty(TEMP_DIRECTORY_PATH) + File.separator + attachmentId);
                Files.copy(bis, tempFile.toPath(), StandardCopyOption.REPLACE_EXISTING);
                urlToReplaces.put((String)urlToReplace, IMAGE_URL_REPLACEMENT_PREFIX + tempFile.getName() + IMAGE_URL_REPLACEMENT_SUFFIX);
            }
            if (!(content = content.replace((CharSequence)urlToReplace, "")).equals(checkContent)) continue;
            break;
        }
        if (!urlToReplaces.isEmpty()) {
            content = this.replaceUrl(note.getContent(), urlToReplaces);
        }
        return this.htmlUploadImageProcessor.processImagesForExport(content);
    }

    private void replaceIncludedPages(Page note, Wiki wiki) throws WikiException {
        String content;
        Page note_ = this.noteService.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), note.getName());
        if (note_ != null && (content = note_.getContent()).contains("class=\"noteLink\" href=\"//-")) {
            while (content.contains("class=\"noteLink\" href=\"//-")) {
                String linkedParams = content.split("class=\"noteLink\" href=\"//-")[1].split("-//\"")[0];
                String NoteName = linkedParams.split("-////-")[2];
                Page linkedNote = null;
                linkedNote = this.noteService.getNoteOfNoteBookByName(wiki.getType(), wiki.getOwner(), NoteName);
                content = linkedNote != null ? content.replace("\"noteLink\" href=\"//-" + linkedParams + IMAGE_URL_REPLACEMENT_SUFFIX, "\"noteLink\" href=\"" + linkedNote.getId()) : content.replace("\"noteLink\" href=\"//-" + linkedParams + IMAGE_URL_REPLACEMENT_SUFFIX, "\"noteLink\" href=\"" + NoteName);
                if (!content.equals(note_.getContent())) continue;
                break;
            }
            if (!content.equals(note_.getContent())) {
                note_.setContent(content);
                this.noteService.updateNote(note_);
            }
        }
        if (note.getChildren() != null) {
            for (Page child : note.getChildren()) {
                this.replaceIncludedPages(child, wiki);
            }
        }
    }

    private String replaceUrl(String body, Map<String, String> urlToReplaces) {
        for (String url : urlToReplaces.keySet()) {
            while (body.contains(url)) {
                body = body.replace(url, urlToReplaces.get(url));
            }
        }
        return body;
    }

    private LinkedList<String> getNoteAncestorsIds(String noteId) throws WikiException {
        return this.getNoteAncestorsIds(null, noteId);
    }

    private LinkedList<String> getNoteAncestorsIds(LinkedList<String> ancestorsIds, String noteId) throws WikiException {
        if (ancestorsIds == null) {
            ancestorsIds = new LinkedList();
        }
        if (noteId == null) {
            return ancestorsIds;
        }
        Page note = this.noteService.getNoteById(noteId);
        String parentId = note.getParentPageId();
        if (parentId != null) {
            ancestorsIds.push(parentId);
            this.getNoteAncestorsIds(ancestorsIds, parentId);
        }
        return ancestorsIds;
    }
}

