/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.handler;

import io.meeds.notes.service.TermsAndConditionsService;
import jakarta.annotation.PostConstruct;
import java.net.URLEncoder;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.List;
import org.exoplatform.container.PortalContainer;
import org.exoplatform.portal.config.UserPortalConfigService;
import org.exoplatform.web.ControllerContext;
import org.exoplatform.web.WebAppController;
import org.exoplatform.web.WebRequestHandler;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.stereotype.Component;

@Component
public class TermsAndConditionsHandler
extends WebRequestHandler {
    public static final String PAGE_URI = "terms-and-conditions";
    private final UserPortalConfigService userPortalConfigService;
    private final TermsAndConditionsService termsAndConditionsService;
    private final WebAppController webAppController;
    @Value(value="#{'${io.meeds.termsAndConditions.excludedUris:}'.split(',')}")
    private List<String> excludedUris = new ArrayList<String>();

    @Autowired
    public TermsAndConditionsHandler(UserPortalConfigService userPortalConfigService, TermsAndConditionsService termsAndConditionsService, WebAppController webAppController) {
        this.userPortalConfigService = userPortalConfigService;
        this.termsAndConditionsService = termsAndConditionsService;
        this.webAppController = webAppController;
    }

    @PostConstruct
    public void init() {
        this.webAppController.register((WebRequestHandler)this);
    }

    public String getHandlerName() {
        return PAGE_URI;
    }

    protected boolean getRequiresLifeCycle() {
        return true;
    }

    public boolean execute(ControllerContext controllerContext) throws Exception {
        String username = controllerContext.getRequest().getRemoteUser();
        String requestURI = controllerContext.getRequest().getRequestURI();
        if (username == null || this.isExcludedUri(requestURI)) {
            return false;
        }
        String language = controllerContext.getRequest().getLocale().getLanguage();
        boolean hasAcceptedTerms = this.termsAndConditionsService.isTermsAcceptedForUser(username, language);
        if (hasAcceptedTerms && this.isTermsPage(requestURI) && controllerContext.getRequest().getQueryString() == null) {
            this.redirectToUserSettings(controllerContext);
            return true;
        }
        if (!hasAcceptedTerms && !this.isTermsPage(requestURI)) {
            this.redirectToTermsPage(controllerContext, requestURI, username);
            return true;
        }
        return false;
    }

    private void redirectToUserSettings(ControllerContext ctx) throws Exception {
        String target = String.format("%s/%s/settings#terms-and-conditions", ctx.getRequest().getContextPath(), this.userPortalConfigService.getMetaPortal());
        ctx.getResponse().sendRedirect(target);
    }

    private void redirectToTermsPage(ControllerContext ctx, String requestURI, String username) throws Exception {
        String queryString = ctx.getRequest().getQueryString();
        if (queryString != null) {
            requestURI = (String)requestURI + "?" + queryString;
        }
        String basePortalPath = "/" + PortalContainer.getCurrentPortalContainerName() + "/";
        String contextPath = ctx.getRequest().getContextPath();
        String metaPortal = this.userPortalConfigService.getMetaPortal();
        String redirectUrl = ((String)requestURI).equals(basePortalPath) ? String.format("%s/%s/settings#terms-and-conditions?redirect=%s", contextPath, metaPortal, this.userPortalConfigService.getDefaultPath(username)) : String.format("%s/%s/terms-and-conditions?redirect=%s", contextPath, metaPortal, URLEncoder.encode((String)requestURI, StandardCharsets.UTF_8));
        ctx.getResponse().sendRedirect(redirectUrl);
    }

    private boolean isTermsPage(String uri) {
        return uri.contains(PAGE_URI);
    }

    private boolean isExcludedUri(String uri) {
        return this.excludedUris.stream().anyMatch(uri::contains);
    }
}

