/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.dao;

import jakarta.persistence.NoResultException;
import jakarta.persistence.Query;
import jakarta.persistence.TypedQuery;
import java.util.Collections;
import java.util.List;
import org.exoplatform.wiki.jpa.dao.WikiBaseDAO;
import org.exoplatform.wiki.jpa.entity.PageVersionEntity;

public class PageVersionDAO
extends WikiBaseDAO<PageVersionEntity, Long> {
    public Long getLastversionNumberOfPage(Long pageId) {
        Query query = this.getEntityManager().createNamedQuery("wikiPageVersion.getLastversionNumberOfPage").setParameter("pageId", (Object)pageId);
        try {
            return (Long)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public PageVersionEntity getPageversionByPageIdAndVersion(Long pageId, Long versionNumber) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPageVersion.getPageversionByPageIdAndVersion", PageVersionEntity.class).setParameter("pageId", (Object)pageId).setParameter("versionNumber", (Object)versionNumber);
        try {
            return (PageVersionEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<PageVersionEntity> findAllVersionsBySyntax(String syntax, int offset, int limit) {
        return this.getEntityManager().createNamedQuery("wikiPageVersion.getAllPagesVersionsBySyntax").setParameter("syntax", (Object)syntax).setFirstResult(offset).setMaxResults(limit).getResultList();
    }

    public Long countPagesVersionsBySyntax(String syntax) {
        return (Long)this.getEntityManager().createNamedQuery("wikiPageVersion.countAllPagesVersionsBySyntax").setParameter("syntax", (Object)syntax).getSingleResult();
    }

    public List<PageVersionEntity> findPageVersionsByPageIdAndLang(Long pageId, String lang) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPageVersion.getPageVersionsByPageIdAndLang", PageVersionEntity.class).setParameter("pageId", (Object)pageId).setParameter("lang", (Object)lang);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }

    public PageVersionEntity findLatestVersionByPageIdAndLang(Long pageId, String lang) {
        TypedQuery query = this.getEntityManager().createNamedQuery("wikiPageVersion.getLatestPageVersionsByPageIdAndLang", PageVersionEntity.class).setParameter("pageId", (Object)pageId).setParameter("lang", (Object)lang);
        query.setMaxResults(1);
        try {
            return (PageVersionEntity)query.getSingleResult();
        }
        catch (NoResultException e) {
            return null;
        }
    }

    public List<String> findPageAvailableTranslationLanguages(Long pageId) {
        Query query = this.getEntityManager().createNamedQuery("wikiPageVersion.getPageAvailableTranslationLanguages").setParameter("pageId", (Object)pageId);
        try {
            return query.getResultList();
        }
        catch (NoResultException e) {
            return Collections.emptyList();
        }
    }
}

