/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.jpa.entity;

import jakarta.persistence.Column;
import jakarta.persistence.Entity;
import jakarta.persistence.GeneratedValue;
import jakarta.persistence.GenerationType;
import jakarta.persistence.Id;
import jakarta.persistence.JoinColumn;
import jakarta.persistence.NamedQueries;
import jakarta.persistence.NamedQuery;
import jakarta.persistence.OneToOne;
import jakarta.persistence.SequenceGenerator;
import jakarta.persistence.Table;
import org.exoplatform.wiki.jpa.entity.PageEntity;

@Entity(name="WikiWikiEntity")
@Table(name="WIKI_WIKIS")
@NamedQueries(value={@NamedQuery(name="wiki.getAllIds", query="SELECT w.id FROM WikiWikiEntity w ORDER BY w.id"), @NamedQuery(name="wiki.getWikisByType", query="SELECT w FROM WikiWikiEntity w WHERE w.type = :type"), @NamedQuery(name="wiki.getWikiByTypeAndOwner", query="SELECT w FROM WikiWikiEntity w WHERE w.type = :type AND w.owner = :owner")})
public class WikiEntity {
    @Id
    @Column(name="WIKI_ID")
    @SequenceGenerator(name="SEQ_WIKI_WIKIS_WIKI_ID", sequenceName="SEQ_WIKI_WIKIS_WIKI_ID", allocationSize=1)
    @GeneratedValue(strategy=GenerationType.AUTO, generator="SEQ_WIKI_WIKIS_WIKI_ID")
    private long id;
    @Column(name="NAME")
    private String name;
    @Column(name="OWNER")
    private String owner;
    @Column(name="TYPE")
    private String type;
    @OneToOne
    @JoinColumn(name="WIKI_HOME")
    private PageEntity wikiHome;
    @Column(name="SYNTAX")
    private String syntax;
    @Column(name="ALLOW_MULTI_SYNTAX")
    private boolean allowMultipleSyntax;

    public long getId() {
        return this.id;
    }

    public String getName() {
        return this.name;
    }

    public WikiEntity setName(String name) {
        this.name = name;
        return this;
    }

    public String getOwner() {
        return this.owner;
    }

    public WikiEntity setOwner(String owner) {
        this.owner = owner;
        return this;
    }

    public String getType() {
        return this.type;
    }

    public WikiEntity setType(String type) {
        this.type = type;
        return this;
    }

    public PageEntity getWikiHome() {
        return this.wikiHome;
    }

    public WikiEntity setWikiHome(PageEntity wikiHome) {
        this.wikiHome = wikiHome;
        return this;
    }

    public String getSyntax() {
        return this.syntax;
    }

    public void setSyntax(String syntax) {
        this.syntax = syntax;
    }

    public boolean isAllowMultipleSyntax() {
        return this.allowMultipleSyntax;
    }

    public void setAllowMultipleSyntax(boolean allowMultipleSyntax) {
        this.allowMultipleSyntax = allowMultipleSyntax;
    }
}

