/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.plugin;

import io.meeds.portal.permlink.model.PermanentLinkObject;
import io.meeds.portal.permlink.plugin.PermanentLinkPlugin;
import io.meeds.portal.permlink.service.PermanentLinkService;
import jakarta.annotation.PostConstruct;
import org.apache.commons.lang3.StringUtils;
import org.exoplatform.commons.exception.ObjectNotFoundException;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.security.Identity;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.WikiType;
import org.exoplatform.wiki.service.NoteService;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class NotePermanentLinkPlugin
implements PermanentLinkPlugin {
    public static final String OBJECT_TYPE = "notes";
    public static final String URL_FORMAT = "/portal/s/%s/notes/%s";
    @Autowired
    private NoteService noteService;
    @Autowired
    private UserACL userAcl;
    @Autowired
    private SpaceService spaceService;
    @Autowired
    private PermanentLinkService permanentLinkService;

    @PostConstruct
    public void init() {
        this.permanentLinkService.addPlugin((PermanentLinkPlugin)this);
    }

    public String getObjectType() {
        return OBJECT_TYPE;
    }

    public boolean canAccess(PermanentLinkObject object, Identity identity) throws ObjectNotFoundException {
        return this.userAcl.hasAccessPermission(OBJECT_TYPE, object.getObjectId(), identity);
    }

    public String getDirectAccessUrl(PermanentLinkObject object) throws ObjectNotFoundException {
        Page note = this.noteService.getNoteById(object.getObjectId());
        if (note == null) {
            throw new ObjectNotFoundException(String.format("Note with id %s not found", object.getObjectId()));
        }
        if (!StringUtils.equalsIgnoreCase((CharSequence)WikiType.GROUP.name(), (CharSequence)note.getWikiType())) {
            throw new ObjectNotFoundException(String.format("Note with id %s isn't of type 'group'", object.getObjectId()));
        }
        Space space = this.spaceService.getSpaceByGroupId(note.getWikiOwner());
        if (space == null) {
            throw new ObjectNotFoundException(String.format("Note with id %s associated space wasn't found", object.getObjectId()));
        }
        return String.format(URL_FORMAT, space.getId(), object.getObjectId());
    }
}

