/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.tree;

import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import lombok.Generated;
import org.exoplatform.services.security.Identity;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.tree.PageTreeNode;
import org.exoplatform.wiki.tree.TreeNode;
import org.exoplatform.wiki.tree.TreeNodeType;
import org.exoplatform.wiki.tree.WikiHomeTreeNode;
import org.exoplatform.wiki.tree.utils.TreeUtils;

public class JsonNodeData {
    protected String name;
    protected String noteId;
    protected String path;
    protected String currentPath;
    protected boolean hasChild;
    protected TreeNodeType nodeType;
    protected boolean isDraftPage = false;
    protected boolean disabled = false;
    protected boolean isLastNode;
    protected boolean isSelectable;
    protected boolean isRestricted = false;
    protected boolean isExpanded = false;
    protected boolean isSelected = false;
    protected String excerpt = "";
    public static final String CURRENT_PATH = "currentPath";
    private List<JsonNodeData> children;
    private String parentPageId;
    private String targetPageId;
    private Boolean hasDraftDescendant;
    private String url;
    private String lang;

    public JsonNodeData(TreeNode treeNode, boolean isLastNode, boolean isSelectable, String currentPath, String excerpt, Map<String, Object> context, Identity identity, Locale locale) throws Exception {
        this.name = treeNode.getName();
        this.noteId = treeNode.getId();
        if (treeNode instanceof WikiHomeTreeNode) {
            this.noteId = ((WikiHomeTreeNode)treeNode).getWikiHome().getId();
        }
        if (treeNode.getPath() != null) {
            this.path = URLEncoder.encode(treeNode.getPath(), "utf-8");
        }
        if (currentPath != null) {
            this.currentPath = URLEncoder.encode(currentPath, "utf-8");
        }
        this.hasChild = treeNode.isHasChild();
        this.nodeType = treeNode.getNodeType();
        this.isLastNode = isLastNode;
        this.isSelectable = isSelectable;
        this.excerpt = excerpt;
        this.children = TreeUtils.tranformToJson(treeNode, context, identity, locale);
        this.isSelected = treeNode.isSelected();
        this.isRestricted = treeNode.isRetricted;
        if (this.children != null && !this.children.isEmpty()) {
            this.isExpanded = true;
        }
        if (treeNode.getNodeType().equals((Object)TreeNodeType.PAGE)) {
            boolean withDrafts;
            Page page = ((PageTreeNode)treeNode).getPage();
            this.isDraftPage = page.isDraftPage();
            this.parentPageId = page.getParentPageId();
            this.url = page.getUrl();
            this.lang = page.getLang();
            boolean bl = withDrafts = context.containsKey("withDrafts") && (Boolean)context.get("withDrafts") != false;
            if (withDrafts) {
                boolean bl2 = this.disabled = !this.isDraftPage;
            }
            if (this.isDraftPage) {
                this.targetPageId = ((DraftPage)page).getTargetPageId();
            }
        } else if (treeNode.getNodeType().equals((Object)TreeNodeType.WIKIHOME)) {
            this.url = ((WikiHomeTreeNode)treeNode).getWikiHome().getUrl();
        }
    }

    public Boolean isHasDraftDescendant() {
        return this.hasDraftDescendant;
    }

    public void addChildren(List<JsonNodeData> children) {
        if (this.children == null) {
            this.children = new ArrayList<JsonNodeData>();
        }
        this.children.addAll(children);
    }

    @Generated
    public String getName() {
        return this.name;
    }

    @Generated
    public String getNoteId() {
        return this.noteId;
    }

    @Generated
    public String getPath() {
        return this.path;
    }

    @Generated
    public String getCurrentPath() {
        return this.currentPath;
    }

    @Generated
    public boolean isHasChild() {
        return this.hasChild;
    }

    @Generated
    public TreeNodeType getNodeType() {
        return this.nodeType;
    }

    @Generated
    public boolean isDraftPage() {
        return this.isDraftPage;
    }

    @Generated
    public boolean isDisabled() {
        return this.disabled;
    }

    @Generated
    public boolean isLastNode() {
        return this.isLastNode;
    }

    @Generated
    public boolean isSelectable() {
        return this.isSelectable;
    }

    @Generated
    public boolean isRestricted() {
        return this.isRestricted;
    }

    @Generated
    public boolean isExpanded() {
        return this.isExpanded;
    }

    @Generated
    public boolean isSelected() {
        return this.isSelected;
    }

    @Generated
    public String getExcerpt() {
        return this.excerpt;
    }

    @Generated
    public List<JsonNodeData> getChildren() {
        return this.children;
    }

    @Generated
    public String getParentPageId() {
        return this.parentPageId;
    }

    @Generated
    public String getTargetPageId() {
        return this.targetPageId;
    }

    @Generated
    public Boolean getHasDraftDescendant() {
        return this.hasDraftDescendant;
    }

    @Generated
    public String getUrl() {
        return this.url;
    }

    @Generated
    public String getLang() {
        return this.lang;
    }

    @Generated
    public void setName(String name) {
        this.name = name;
    }

    @Generated
    public void setNoteId(String noteId) {
        this.noteId = noteId;
    }

    @Generated
    public void setPath(String path) {
        this.path = path;
    }

    @Generated
    public void setCurrentPath(String currentPath) {
        this.currentPath = currentPath;
    }

    @Generated
    public void setHasChild(boolean hasChild) {
        this.hasChild = hasChild;
    }

    @Generated
    public void setNodeType(TreeNodeType nodeType) {
        this.nodeType = nodeType;
    }

    @Generated
    public void setDraftPage(boolean isDraftPage) {
        this.isDraftPage = isDraftPage;
    }

    @Generated
    public void setDisabled(boolean disabled) {
        this.disabled = disabled;
    }

    @Generated
    public void setLastNode(boolean isLastNode) {
        this.isLastNode = isLastNode;
    }

    @Generated
    public void setSelectable(boolean isSelectable) {
        this.isSelectable = isSelectable;
    }

    @Generated
    public void setRestricted(boolean isRestricted) {
        this.isRestricted = isRestricted;
    }

    @Generated
    public void setExpanded(boolean isExpanded) {
        this.isExpanded = isExpanded;
    }

    @Generated
    public void setSelected(boolean isSelected) {
        this.isSelected = isSelected;
    }

    @Generated
    public void setExcerpt(String excerpt) {
        this.excerpt = excerpt;
    }

    @Generated
    public void setChildren(List<JsonNodeData> children) {
        this.children = children;
    }

    @Generated
    public void setParentPageId(String parentPageId) {
        this.parentPageId = parentPageId;
    }

    @Generated
    public void setTargetPageId(String targetPageId) {
        this.targetPageId = targetPageId;
    }

    @Generated
    public void setHasDraftDescendant(Boolean hasDraftDescendant) {
        this.hasDraftDescendant = hasDraftDescendant;
    }

    @Generated
    public void setUrl(String url) {
        this.url = url;
    }

    @Generated
    public void setLang(String lang) {
        this.lang = lang;
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof JsonNodeData)) {
            return false;
        }
        JsonNodeData other = (JsonNodeData)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isHasChild() != other.isHasChild()) {
            return false;
        }
        if (this.isDraftPage() != other.isDraftPage()) {
            return false;
        }
        if (this.isDisabled() != other.isDisabled()) {
            return false;
        }
        if (this.isLastNode() != other.isLastNode()) {
            return false;
        }
        if (this.isSelectable() != other.isSelectable()) {
            return false;
        }
        if (this.isRestricted() != other.isRestricted()) {
            return false;
        }
        if (this.isExpanded() != other.isExpanded()) {
            return false;
        }
        if (this.isSelected() != other.isSelected()) {
            return false;
        }
        Boolean this$hasDraftDescendant = this.getHasDraftDescendant();
        Boolean other$hasDraftDescendant = other.getHasDraftDescendant();
        if (this$hasDraftDescendant == null ? other$hasDraftDescendant != null : !((Object)this$hasDraftDescendant).equals(other$hasDraftDescendant)) {
            return false;
        }
        String this$name = this.getName();
        String other$name = other.getName();
        if (this$name == null ? other$name != null : !this$name.equals(other$name)) {
            return false;
        }
        String this$noteId = this.getNoteId();
        String other$noteId = other.getNoteId();
        if (this$noteId == null ? other$noteId != null : !this$noteId.equals(other$noteId)) {
            return false;
        }
        String this$path = this.getPath();
        String other$path = other.getPath();
        if (this$path == null ? other$path != null : !this$path.equals(other$path)) {
            return false;
        }
        String this$currentPath = this.getCurrentPath();
        String other$currentPath = other.getCurrentPath();
        if (this$currentPath == null ? other$currentPath != null : !this$currentPath.equals(other$currentPath)) {
            return false;
        }
        TreeNodeType this$nodeType = this.getNodeType();
        TreeNodeType other$nodeType = other.getNodeType();
        if (this$nodeType == null ? other$nodeType != null : !((Object)((Object)this$nodeType)).equals((Object)other$nodeType)) {
            return false;
        }
        String this$excerpt = this.getExcerpt();
        String other$excerpt = other.getExcerpt();
        if (this$excerpt == null ? other$excerpt != null : !this$excerpt.equals(other$excerpt)) {
            return false;
        }
        List<JsonNodeData> this$children = this.getChildren();
        List<JsonNodeData> other$children = other.getChildren();
        if (this$children == null ? other$children != null : !((Object)this$children).equals(other$children)) {
            return false;
        }
        String this$parentPageId = this.getParentPageId();
        String other$parentPageId = other.getParentPageId();
        if (this$parentPageId == null ? other$parentPageId != null : !this$parentPageId.equals(other$parentPageId)) {
            return false;
        }
        String this$targetPageId = this.getTargetPageId();
        String other$targetPageId = other.getTargetPageId();
        if (this$targetPageId == null ? other$targetPageId != null : !this$targetPageId.equals(other$targetPageId)) {
            return false;
        }
        String this$url = this.getUrl();
        String other$url = other.getUrl();
        if (this$url == null ? other$url != null : !this$url.equals(other$url)) {
            return false;
        }
        String this$lang = this.getLang();
        String other$lang = other.getLang();
        return !(this$lang == null ? other$lang != null : !this$lang.equals(other$lang));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof JsonNodeData;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isHasChild() ? 79 : 97);
        result = result * 59 + (this.isDraftPage() ? 79 : 97);
        result = result * 59 + (this.isDisabled() ? 79 : 97);
        result = result * 59 + (this.isLastNode() ? 79 : 97);
        result = result * 59 + (this.isSelectable() ? 79 : 97);
        result = result * 59 + (this.isRestricted() ? 79 : 97);
        result = result * 59 + (this.isExpanded() ? 79 : 97);
        result = result * 59 + (this.isSelected() ? 79 : 97);
        Boolean $hasDraftDescendant = this.getHasDraftDescendant();
        result = result * 59 + ($hasDraftDescendant == null ? 43 : ((Object)$hasDraftDescendant).hashCode());
        String $name = this.getName();
        result = result * 59 + ($name == null ? 43 : $name.hashCode());
        String $noteId = this.getNoteId();
        result = result * 59 + ($noteId == null ? 43 : $noteId.hashCode());
        String $path = this.getPath();
        result = result * 59 + ($path == null ? 43 : $path.hashCode());
        String $currentPath = this.getCurrentPath();
        result = result * 59 + ($currentPath == null ? 43 : $currentPath.hashCode());
        TreeNodeType $nodeType = this.getNodeType();
        result = result * 59 + ($nodeType == null ? 43 : ((Object)((Object)$nodeType)).hashCode());
        String $excerpt = this.getExcerpt();
        result = result * 59 + ($excerpt == null ? 43 : $excerpt.hashCode());
        List<JsonNodeData> $children = this.getChildren();
        result = result * 59 + ($children == null ? 43 : ((Object)$children).hashCode());
        String $parentPageId = this.getParentPageId();
        result = result * 59 + ($parentPageId == null ? 43 : $parentPageId.hashCode());
        String $targetPageId = this.getTargetPageId();
        result = result * 59 + ($targetPageId == null ? 43 : $targetPageId.hashCode());
        String $url = this.getUrl();
        result = result * 59 + ($url == null ? 43 : $url.hashCode());
        String $lang = this.getLang();
        result = result * 59 + ($lang == null ? 43 : $lang.hashCode());
        return result;
    }

    @Generated
    public String toString() {
        return "JsonNodeData(name=" + this.getName() + ", noteId=" + this.getNoteId() + ", path=" + this.getPath() + ", currentPath=" + this.getCurrentPath() + ", hasChild=" + this.isHasChild() + ", nodeType=" + String.valueOf((Object)this.getNodeType()) + ", isDraftPage=" + this.isDraftPage() + ", disabled=" + this.isDisabled() + ", isLastNode=" + this.isLastNode() + ", isSelectable=" + this.isSelectable() + ", isRestricted=" + this.isRestricted() + ", isExpanded=" + this.isExpanded() + ", isSelected=" + this.isSelected() + ", excerpt=" + this.getExcerpt() + ", children=" + String.valueOf(this.getChildren()) + ", parentPageId=" + this.getParentPageId() + ", targetPageId=" + this.getTargetPageId() + ", hasDraftDescendant=" + this.getHasDraftDescendant() + ", url=" + this.getUrl() + ", lang=" + this.getLang() + ")";
    }
}

