/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.rest;

import io.meeds.notes.rest.NotePageViewRest;
import io.meeds.notes.service.NotePageViewService;
import io.meeds.social.cms.service.CMSService;
import io.meeds.social.cms.service.CMSServiceImpl;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import javax.ws.rs.core.MultivaluedMap;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.container.ExoContainer;
import org.exoplatform.container.ExoContainerContext;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.portal.mop.page.PageContext;
import org.exoplatform.portal.mop.page.PageKey;
import org.exoplatform.portal.mop.page.PageState;
import org.exoplatform.portal.mop.service.LayoutService;
import org.exoplatform.services.rest.impl.ContainerResponse;
import org.exoplatform.services.rest.impl.MultivaluedMapImpl;
import org.exoplatform.services.security.ConversationState;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.rest.api.RestUtils;
import org.exoplatform.social.service.test.AbstractResourceTest;
import org.exoplatform.wiki.model.Page;
import org.mockito.MockedStatic;
import org.mockito.Mockito;

public class NotePageViewRestTest
extends AbstractResourceTest {
    private static final String BASE_URL = "/notes/view";
    private static MockedStatic<RestUtils> REST_UTILS;
    protected static final Random RANDOM;
    private static final long USER_IDENTITY_ID = 5L;
    private static final String USERS_GROUP = "*:/platform/users";
    private static final String ADMINISTRATORS_GROUP = "*:/platform/administrators";
    private static final String USERNAME = "testUser";
    private CMSService cmsService;
    private LayoutService layoutService;
    private IdentityRegistry identityRegistry;

    protected void setUp() throws Exception {
        super.setUp();
        this.cmsService = (CMSService)this.getContainer().getComponentInstanceOfType(CMSServiceImpl.class);
        this.layoutService = (LayoutService)this.getContainer().getComponentInstanceOfType(LayoutService.class);
        this.identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        NotePageViewService notePageViewService = (NotePageViewService)this.getContainer().getComponentInstanceOfType(NotePageViewService.class);
        this.registry(new NotePageViewRest(notePageViewService));
        ExoContainerContext.setCurrentContainer((ExoContainer)this.getContainer());
        this.restartTransaction();
        this.begin();
        REST_UTILS = Mockito.mockStatic(RestUtils.class);
    }

    protected void tearDown() throws Exception {
        try {
            this.removeResource(NotePageViewRest.class);
            this.end();
            super.tearDown();
        }
        finally {
            REST_UTILS.close();
        }
    }

    public void testGetNotePageWithAnonim() throws ObjectAlreadyExistsException {
        this.resetRestUtils();
        NotePageViewRestTest.assertNull((Object)this.getNotePage("notExistingPage", null));
        String pageNoteName = "pageNoteName" + RANDOM.nextLong();
        String pageContent = "pageContent" + RANDOM.nextLong();
        String pageReference = this.createPage("pageName" + RANDOM.nextLong(), "Everyone", ADMINISTRATORS_GROUP);
        this.cmsService.saveSettingName("notePage", pageNoteName, pageReference, 0L, 5L);
        Page notePage = this.getNotePage(pageNoteName, null);
        NotePageViewRestTest.assertNull((Object)notePage);
        NotePageViewRestTest.assertEquals((int)403, (int)this.saveNotePage(pageNoteName, pageContent, null).getStatus());
        this.resetRestUtils();
        this.registerInternalUser(USERNAME);
        NotePageViewRestTest.assertEquals((int)401, (int)this.saveNotePage(pageNoteName, pageContent, null).getStatus());
        NotePageViewRestTest.assertEquals((int)404, (int)this.saveNotePage(pageNoteName + "22", pageContent, null).getStatus());
        this.registerAdministratorUser(USERNAME);
        NotePageViewRestTest.assertEquals((int)204, (int)this.saveNotePage(pageNoteName, pageContent, null).getStatus());
        this.restartTransaction();
        this.registerInternalUser(USERNAME);
        notePage = this.getNotePage(pageNoteName, null);
        NotePageViewRestTest.assertNotNull((Object)notePage);
        NotePageViewRestTest.assertEquals((String)pageContent, (String)notePage.getContent());
    }

    public void testGetNotePageWithAuthenticated() throws ObjectAlreadyExistsException {
        String pageNoteName = "pageNoteName" + RANDOM.nextLong();
        String pageContent = "pageContent" + RANDOM.nextLong();
        String pageReference = this.createPage("pageName" + RANDOM.nextLong(), USERS_GROUP, ADMINISTRATORS_GROUP);
        this.cmsService.saveSettingName("notePage", pageNoteName, pageReference, 0L, 5L);
        this.resetRestUtils();
        NotePageViewRestTest.assertEquals((int)401, (int)this.getNotePageResponse(pageNoteName, null).getStatus());
        this.registerInternalUser(USERNAME);
        Page notePage = this.getNotePage(pageNoteName, null);
        NotePageViewRestTest.assertNull((Object)notePage);
        this.resetRestUtils();
        NotePageViewRestTest.assertEquals((int)404, (int)this.saveNotePage(pageNoteName + "22", pageContent, null).getStatus());
        NotePageViewRestTest.assertEquals((int)401, (int)this.saveNotePage(pageNoteName, pageContent, null).getStatus());
        this.registerInternalUser(USERNAME);
        NotePageViewRestTest.assertEquals((int)401, (int)this.saveNotePage(pageNoteName, pageContent, null).getStatus());
        this.registerAdministratorUser(USERNAME);
        this.saveNotePage(pageNoteName, pageContent, null);
        this.resetRestUtils();
        NotePageViewRestTest.assertEquals((int)401, (int)this.getNotePageResponse(pageNoteName, null).getStatus());
        this.registerInternalUser(USERNAME);
        notePage = this.getNotePage(pageNoteName, null);
        NotePageViewRestTest.assertNotNull((Object)notePage);
        NotePageViewRestTest.assertEquals((String)pageContent, (String)notePage.getContent());
        ContainerResponse response = this.getNotePageResponse(pageNoteName, null);
        String eTagValue = this.getETagValue(response);
        response = this.getNotePageWithETag(pageNoteName, null, eTagValue);
        NotePageViewRestTest.assertEquals((int)304, (int)response.getStatus());
        this.registerAdministratorUser(USERNAME);
        this.saveNotePage(pageNoteName, pageContent, null);
        this.registerInternalUser(USERNAME);
        response = this.getNotePageWithETag(pageNoteName, null, eTagValue);
        NotePageViewRestTest.assertEquals((int)200, (int)response.getStatus());
    }

    private String createPage(String pageName, String accessPermission, String editPermission) {
        String siteType = "portal";
        String siteName = "classic";
        if (this.layoutService.getPortalConfig(siteName) == null) {
            PortalConfig portal = new PortalConfig();
            portal.setType(siteType);
            portal.setName(siteName);
            portal.setLocale("en");
            portal.setLabel("Test");
            portal.setDescription("Test");
            portal.setAccessPermissions(new String[]{"Everyone"});
            this.layoutService.create(portal);
        }
        PageKey pageKey = new PageKey(siteType, siteName, pageName);
        PageState pageState = new PageState(pageName, null, false, null, Collections.singletonList(accessPermission), editPermission);
        this.layoutService.save(new PageContext(pageKey, pageState));
        return pageKey.format();
    }

    private String getUrl(String name, String lang) {
        return "/notes/view/" + name + "?lang=" + (lang == null ? "en" : lang);
    }

    private String getUrl(String name) {
        return "/notes/view/" + name;
    }

    private Page getNotePage(String name, String lang) {
        try {
            return (Page)this.getNotePageResponse(name, lang).getEntity();
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private ContainerResponse getNotePageResponse(String name, String lang) {
        try {
            return this.getResponse("GET", this.getUrl(name, lang), null);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private ContainerResponse getNotePageWithETag(String name, String lang, String eTagValue) {
        try {
            MultivaluedMapImpl h = new MultivaluedMapImpl();
            h.putSingle((Object)"If-None-Match", (Object)eTagValue);
            return this.service("GET", this.getUrl(name, lang), "", (MultivaluedMap)h, new byte[0]);
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private String getETagValue(ContainerResponse responseWithEtag) {
        List eTag = (List)responseWithEtag.getHttpHeaders().get((Object)"Etag");
        NotePageViewRestTest.assertNotNull((Object)eTag);
        NotePageViewRestTest.assertEquals((int)1, (int)eTag.size());
        return eTag.get(0).toString();
    }

    private ContainerResponse saveNotePage(String name, String content, String lang) {
        try {
            String urlParam = "content=" + content + "&lang=" + (lang == null ? "en" : lang);
            MultivaluedMapImpl h = new MultivaluedMapImpl();
            h.putSingle((Object)"content-type", (Object)"application/x-www-form-urlencoded");
            h.putSingle((Object)"content-length", (Object)("" + urlParam.length()));
            return this.service("PUT", this.getUrl(name), "", (MultivaluedMap)h, urlParam.getBytes());
        }
        catch (Exception e) {
            throw new IllegalStateException(e);
        }
    }

    private Identity registerAdministratorUser(String user) {
        Identity identity = new Identity(user, Arrays.asList(MembershipEntry.parse((String)ADMINISTRATORS_GROUP), MembershipEntry.parse((String)USERS_GROUP)));
        this.identityRegistry.register(identity);
        ConversationState.setCurrent((ConversationState)new ConversationState(identity));
        this.resetRestUtils();
        REST_UTILS.when(RestUtils::getCurrentUser).thenReturn((Object)USERNAME);
        REST_UTILS.when(RestUtils::getCurrentUserAclIdentity).thenReturn((Object)identity);
        return identity;
    }

    private Identity registerInternalUser(String username) {
        Identity identity = new Identity(username, Arrays.asList(MembershipEntry.parse((String)USERS_GROUP)));
        this.identityRegistry.register(identity);
        ConversationState.setCurrent((ConversationState)new ConversationState(identity));
        this.resetRestUtils();
        REST_UTILS.when(RestUtils::getCurrentUser).thenReturn((Object)USERNAME);
        REST_UTILS.when(RestUtils::getCurrentUserAclIdentity).thenReturn((Object)identity);
        return identity;
    }

    private void resetRestUtils() {
        REST_UTILS.reset();
        REST_UTILS.when(RestUtils::getBaseRestUrl).thenReturn((Object)"");
    }

    static {
        RANDOM = new Random();
    }
}

