/*
 * Decompiled with CFR 0.152.
 */
package org.exoplatform.wiki.service;

import java.io.File;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.io.FileUtils;
import org.exoplatform.commons.ObjectAlreadyExistsException;
import org.exoplatform.portal.config.model.PortalConfig;
import org.exoplatform.services.security.Identity;
import org.exoplatform.services.security.IdentityConstants;
import org.exoplatform.services.security.IdentityRegistry;
import org.exoplatform.services.security.MembershipEntry;
import org.exoplatform.social.core.jpa.test.AbstractCoreTest;
import org.exoplatform.wiki.WikiException;
import org.exoplatform.wiki.jpa.BaseTest;
import org.exoplatform.wiki.jpa.JPADataStorage;
import org.exoplatform.wiki.model.DraftPage;
import org.exoplatform.wiki.model.NoteToExport;
import org.exoplatform.wiki.model.Page;
import org.exoplatform.wiki.model.PageHistory;
import org.exoplatform.wiki.model.Permission;
import org.exoplatform.wiki.model.PermissionEntry;
import org.exoplatform.wiki.model.PermissionType;
import org.exoplatform.wiki.model.Wiki;
import org.exoplatform.wiki.service.BreadcrumbData;
import org.exoplatform.wiki.service.IDType;
import org.exoplatform.wiki.service.NoteService;
import org.exoplatform.wiki.service.NotesExportService;
import org.exoplatform.wiki.service.PageUpdateType;
import org.exoplatform.wiki.service.WikiPageParams;
import org.exoplatform.wiki.service.WikiService;
import org.junit.Assert;

public class TestNoteService
extends BaseTest {
    private WikiService wService;
    private NoteService noteService;
    private NotesExportService notesExportService;

    public TestNoteService() {
        this.setForceContainerReload(true);
    }

    @Override
    public void setUp() throws Exception {
        super.setUp();
        this.wService = (WikiService)this.getContainer().getComponentInstanceOfType(WikiService.class);
        this.noteService = (NoteService)this.getContainer().getComponentInstanceOfType(NoteService.class);
        this.notesExportService = (NotesExportService)this.getContainer().getComponentInstanceOfType(NotesExportService.class);
        this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
    }

    public void testGetGroupPageById() throws WikiException, IllegalAccessException {
        Wiki wiki = this.getOrCreateWiki(this.wService, PortalConfig.GROUP_TYPE, "/platform/users");
        Identity root = new Identity("root");
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.GROUP_TYPE, "platform/users", "Home"));
        Page notePage = this.noteService.createNote(wiki, "Home", new Page("testGetGroupPageById-101", "testGetGroupPageById-101"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.GROUP_TYPE, "platform/users", notePage.getName()));
        TestNoteService.assertNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.GROUP_TYPE, "unknown", "Home"));
    }

    public void testGetUserPageById() throws WikiException, IllegalAccessException {
        Wiki wiki = this.getOrCreateWiki(this.wService, PortalConfig.USER_TYPE, "john");
        Identity john = new Identity("john");
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "john", "Home"));
        Page notePage = this.noteService.createNote(wiki, "Home", new Page("testGetUserPageById-101", "testGetUserPageById-101"), john);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "john", notePage.getName()));
        TestNoteService.assertNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "unknown", "Home"));
    }

    public void testCreatePageAndSubNote() throws WikiException, IllegalAccessException {
        Wiki wiki = new Wiki(PortalConfig.PORTAL_TYPE, "classic");
        Identity root = new Identity("root");
        Page parentNotePage = this.noteService.createNote(wiki, "Home", new Page("parentPage_", "parentPage_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", parentNotePage.getName(), root));
        Page childNotePage = this.noteService.createNote(wiki, parentNotePage.getName(), new Page("childPage_", "childPage_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", childNotePage.getName(), root));
    }

    public void testGetBreadcumb() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
        Page breadcrumb1NotPage = this.noteService.createNote(portalWiki, "Home", new Page("Breadcrumb1_", "Breadcrumb1_"), root);
        Page breadcrumb2NotPage = this.noteService.createNote(portalWiki, breadcrumb1NotPage.getName(), new Page("Breadcrumb2_", "Breadcrumb2_"), root);
        Page breadcrumb3NotPage = this.noteService.createNote(portalWiki, breadcrumb2NotPage.getName(), new Page("Breadcrumb3_", "Breadcrumb3_"), root);
        List breadCumbs = this.noteService.getBreadCrumb(PortalConfig.PORTAL_TYPE, "classic", breadcrumb3NotPage.getName(), false);
        TestNoteService.assertEquals((int)4, (int)breadCumbs.size());
        TestNoteService.assertEquals((String)"Home", (String)((BreadcrumbData)breadCumbs.get(0)).getId());
        TestNoteService.assertEquals((String)breadcrumb1NotPage.getName(), (String)((BreadcrumbData)breadCumbs.get(1)).getId());
        TestNoteService.assertEquals((String)breadcrumb2NotPage.getName(), (String)((BreadcrumbData)breadCumbs.get(2)).getId());
        TestNoteService.assertEquals((String)breadcrumb3NotPage.getName(), (String)((BreadcrumbData)breadCumbs.get(3)).getId());
    }

    public void testGetBreadcumbWithLanguage() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("Breadcumb1", "Breadcumb1"), root);
        Page note2 = this.noteService.createNote(portalWiki, note1.getName(), new Page("Breadcumb2", "Breadcumb2"), root);
        Page note3 = this.noteService.createNote(portalWiki, note2.getName(), new Page("Breadcumb3", "Breadcumb3"), root);
        note1.setLang("fr");
        note1.setTitle("Breadcumb1_fr");
        this.noteService.createVersionOfNote(note1, "root");
        note2.setLang("fr");
        note2.setTitle("Breadcumb2_fr");
        this.noteService.createVersionOfNote(note2, "root");
        note3.setLang("fr");
        note3.setTitle("Breadcumb3_fr");
        this.noteService.createVersionOfNote(note3, "root");
        List breadCumbs = this.noteService.getBreadCrumb(PortalConfig.PORTAL_TYPE, "classic", note3.getName(), false);
        TestNoteService.assertEquals((int)4, (int)breadCumbs.size());
        TestNoteService.assertEquals((String)"Home", (String)((BreadcrumbData)breadCumbs.get(0)).getId());
        TestNoteService.assertEquals((String)"Breadcumb1", (String)((BreadcrumbData)breadCumbs.get(1)).getTitle());
        TestNoteService.assertEquals((String)"Breadcumb2", (String)((BreadcrumbData)breadCumbs.get(2)).getTitle());
        TestNoteService.assertEquals((String)"Breadcumb3", (String)((BreadcrumbData)breadCumbs.get(3)).getTitle());
        breadCumbs = this.noteService.getBreadCrumb(PortalConfig.PORTAL_TYPE, "classic", note3.getName(), "fr", root, false);
        TestNoteService.assertEquals((int)4, (int)breadCumbs.size());
        TestNoteService.assertEquals((String)"Home", (String)((BreadcrumbData)breadCumbs.get(0)).getId());
        TestNoteService.assertEquals((String)"Breadcumb1_fr", (String)((BreadcrumbData)breadCumbs.get(1)).getTitle());
        TestNoteService.assertEquals((String)"Breadcumb2_fr", (String)((BreadcrumbData)breadCumbs.get(2)).getTitle());
        TestNoteService.assertEquals((String)"Breadcumb3_fr", (String)((BreadcrumbData)breadCumbs.get(3)).getTitle());
    }

    public void testMoveNote() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
        Page oldParentNotePage = this.noteService.createNote(portalWiki, "Home", new Page("oldParent_", "oldParent_"), root);
        Page childNotePage = this.noteService.createNote(portalWiki, oldParentNotePage.getName(), new Page("child_", "child_"), root);
        Page newsParentNotPage = this.noteService.createNote(portalWiki, "Home", new Page("newParent_", "newParent_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", oldParentNotePage.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", childNotePage.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", newsParentNotPage.getName()));
        WikiPageParams currentLocationParams = new WikiPageParams();
        WikiPageParams newLocationParams = new WikiPageParams();
        currentLocationParams.setPageName(childNotePage.getName());
        currentLocationParams.setType(PortalConfig.PORTAL_TYPE);
        currentLocationParams.setOwner("classic");
        newLocationParams.setPageName(newsParentNotPage.getName());
        newLocationParams.setType(PortalConfig.PORTAL_TYPE);
        newLocationParams.setOwner("classic");
        TestNoteService.assertTrue((boolean)this.noteService.moveNote(currentLocationParams, newLocationParams, root));
        Wiki userWiki = this.getOrCreateWiki(this.wService, PortalConfig.USER_TYPE, "root");
        Page acmeNotePage = this.noteService.createNote(userWiki, "Home", new Page("acmePage_", "acmePage_"), root);
        Page classicNotePage = this.noteService.createNote(portalWiki, "Home", new Page("classicPage_", "classicPage_"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "root", acmeNotePage.getName(), root));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", classicNotePage.getName(), root));
        currentLocationParams.setPageName(acmeNotePage.getName());
        currentLocationParams.setType(PortalConfig.USER_TYPE);
        currentLocationParams.setOwner("root");
        newLocationParams.setPageName(classicNotePage.getName());
        newLocationParams.setType(PortalConfig.PORTAL_TYPE);
        newLocationParams.setOwner("classic");
        TestNoteService.assertTrue((boolean)this.noteService.moveNote(currentLocationParams, newLocationParams, root));
        Wiki demoWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "root");
        Page toMovedNotePage = this.noteService.createNote(demoWiki, "Home", new Page("toMovedPage_", "toMovedPage_"), root);
        Page privateNotePage = this.noteService.createNote(userWiki, "Home", new Page("privatePage_", "privatePage_"), root);
        HashMap<String, String[]> permissionMap = new HashMap<String, String[]>();
        permissionMap.put("any", new String[]{PermissionType.VIEWPAGE.toString(), PermissionType.EDITPAGE.toString()});
        ArrayList<PermissionEntry> permissionEntries = new ArrayList<PermissionEntry>();
        PermissionEntry permissionEntry = new PermissionEntry(IdentityConstants.ANY.toString(), "", IDType.USER, new Permission[]{new Permission(PermissionType.VIEWPAGE, true), new Permission(PermissionType.EDITPAGE, true)});
        permissionEntries.add(permissionEntry);
        privateNotePage.setPermissions(permissionEntries);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "root", toMovedNotePage.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.USER_TYPE, "root", privateNotePage.getName()));
        currentLocationParams.setPageName(toMovedNotePage.getName());
        currentLocationParams.setType(PortalConfig.PORTAL_TYPE);
        currentLocationParams.setOwner("root");
        newLocationParams.setPageName(privateNotePage.getName());
        newLocationParams.setType(PortalConfig.USER_TYPE);
        newLocationParams.setOwner("root");
    }

    public void testDeleteNote() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
        Page notePage1 = this.noteService.createNote(portalWiki, "Home", new Page("deletePage_", "deletePage_"), root);
        TestNoteService.assertTrue((boolean)this.noteService.deleteNote(PortalConfig.PORTAL_TYPE, "classic", notePage1.getName()));
        Page notePage2 = this.noteService.createNote(portalWiki, "Home", new Page("deletePage_", "deletePage_"), root);
        TestNoteService.assertTrue((boolean)this.noteService.deleteNote(PortalConfig.PORTAL_TYPE, "classic", notePage2.getName()));
        TestNoteService.assertNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", notePage2.getName()));
        TestNoteService.assertFalse((boolean)this.noteService.deleteNote(PortalConfig.PORTAL_TYPE, "classic", "Home"));
    }

    public void testRenameNote() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
        Page currentNotePage = this.noteService.createNote(portalWiki, "Home", new Page("currentPage_", "currentPage_"), root);
        TestNoteService.assertTrue((boolean)this.noteService.renameNote(PortalConfig.PORTAL_TYPE, "classic", currentNotePage.getName(), "renamedPage_", "renamedPage_"));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", "renamedPage_"));
    }

    public void testRenamePageToExistingNote() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic");
        Page currentNotePage = this.noteService.createNote(portalWiki, "Home", new Page("currentPage_", "currentPage_"), root);
        Page currentNotePage2 = this.noteService.createNote(portalWiki, "Home", new Page("currentPage2_", "currentPage2_"), root);
        try {
            this.noteService.renameNote(PortalConfig.PORTAL_TYPE, "classic", currentNotePage.getName(), currentNotePage2.getName(), "renamedPage2_");
            TestNoteService.fail((String)("Renaming page currentPage to the existing page " + currentNotePage2.getName() + " should throw an exception"));
        }
        catch (WikiException e) {
            TestNoteService.assertEquals((String)("Note portal:classic:" + currentNotePage2.getName() + " already exists, cannot rename it."), (String)e.getMessage());
        }
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", currentNotePage.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "classic", currentNotePage2.getName()));
    }

    public void testHasPermisionOnSystemPage() throws WikiException, IllegalAccessException, ObjectAlreadyExistsException {
        JPADataStorage storage = (JPADataStorage)this.getContainer().getComponentInstanceOfType(JPADataStorage.class);
        Wiki wiki = new Wiki();
        wiki.setType("portal");
        wiki.setOwner("testHasPermisionOnSystemPage");
        wiki = storage.createWiki(wiki);
        IdentityRegistry identityRegistry = (IdentityRegistry)this.getContainer().getComponentInstanceOfType(IdentityRegistry.class);
        Identity adminAclIdentity = new Identity("admin", Arrays.asList(new MembershipEntry("/platform/users", "*"), new MembershipEntry("/platform/administrators", "*")));
        identityRegistry.register(adminAclIdentity);
        Identity userAclIdentity = new Identity("user", Arrays.asList(new MembershipEntry("/platform/users", "*")));
        identityRegistry.register(userAclIdentity);
        Page noPermissionPage = new Page();
        noPermissionPage.setWikiId(wiki.getId());
        noPermissionPage.setWikiType(wiki.getType());
        noPermissionPage.setWikiOwner(wiki.getOwner());
        noPermissionPage.setName("page1");
        noPermissionPage.setTitle("Page 1");
        noPermissionPage.setPermissions(new ArrayList());
        noPermissionPage = storage.createPage(wiki, wiki.getWikiHome(), noPermissionPage);
        Page systemPermissionPage = new Page();
        systemPermissionPage.setWikiId(wiki.getId());
        systemPermissionPage.setWikiType(wiki.getType());
        systemPermissionPage.setWikiOwner(wiki.getOwner());
        systemPermissionPage.setName("page1");
        systemPermissionPage.setTitle("Page 1");
        systemPermissionPage.setOwner(IdentityConstants.SYSTEM);
        systemPermissionPage.setPermissions(new ArrayList());
        Page storedSystemPermissionPage = storage.createPage(wiki, wiki.getWikiHome(), systemPermissionPage);
        TestNoteService.assertTrue((boolean)this.noteService.hasPermissionOnPage(noPermissionPage, PermissionType.VIEWPAGE, adminAclIdentity));
        TestNoteService.assertFalse((boolean)this.noteService.hasPermissionOnPage(storedSystemPermissionPage, PermissionType.VIEWPAGE, adminAclIdentity));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteById(storedSystemPermissionPage.getId(), adminAclIdentity));
        Assert.assertThrows(IllegalAccessException.class, () -> this.noteService.getNoteById(storedSystemPermissionPage.getId(), userAclIdentity));
    }

    public void testUpdateNote() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "classic").getWikiHome();
        Page page = new Page("new page_", "new page_");
        page.setContent("Page content");
        page = this.noteService.createNote(new Wiki(PortalConfig.PORTAL_TYPE, "classic"), "Home", page, root);
        TestNoteService.assertNotNull((Object)page);
        TestNoteService.assertEquals((String)"Page content", (String)page.getContent());
        TestNoteService.assertEquals((String)"new page_", (String)page.getTitle());
        page.setContent("Page content updated_");
        this.noteService.updateNote(page, PageUpdateType.EDIT_PAGE_CONTENT, root);
        TestNoteService.assertNotNull((Object)page);
        TestNoteService.assertEquals((String)"Page content updated_", (String)page.getContent());
        page.setTitle("new page updated_");
        this.noteService.updateNote(page, PageUpdateType.EDIT_PAGE_CONTENT, root);
        TestNoteService.assertNotNull((Object)page);
        TestNoteService.assertEquals((String)"new page updated_", (String)page.getTitle());
    }

    public void testDraftPage() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        DraftPage draftOfNewPage = new DraftPage();
        draftOfNewPage.setTitle("Draft page");
        draftOfNewPage.setContent("Draft page content");
        long now = new Date().getTime();
        draftOfNewPage = this.noteService.createDraftForNewPage(new DraftPage(), now);
        TestNoteService.assertNotNull((Object)draftOfNewPage);
        String draftNameForNewPage = draftOfNewPage.getName();
        TestNoteService.assertTrue((boolean)draftOfNewPage.isNewPage());
        TestNoteService.assertTrue((boolean)draftOfNewPage.isDraftPage());
        TestNoteService.assertEquals((String)("Untitled_" + this.getDraftNameSuffix(now)), (String)draftNameForNewPage);
        String pageName = "new page 10";
        Page targetPage = new Page(pageName, pageName);
        targetPage.setContent("Page content");
        Wiki userWiki = this.getOrCreateWiki(this.wService, PortalConfig.USER_TYPE, "root");
        targetPage = this.noteService.createNote(userWiki, "Home", new Page("TestPage", "TestPage"), root);
        DraftPage draftPageTosave = new DraftPage();
        String draftTitle = targetPage.getTitle() + "_draft";
        String draftContent = targetPage.getContent() + "_draft";
        draftPageTosave.setTitle(draftTitle);
        draftPageTosave.setContent(draftContent);
        String draftName = targetPage.getName() + "_" + this.getDraftNameSuffix(now);
        DraftPage draftOfExistingPage = this.noteService.createDraftForExistPage(draftPageTosave, targetPage, null, now, root.getUserId());
        TestNoteService.assertNotNull((Object)draftOfExistingPage);
        TestNoteService.assertFalse((boolean)draftOfExistingPage.isNewPage());
        TestNoteService.assertEquals((String)draftOfExistingPage.getName(), (String)draftName);
        TestNoteService.assertEquals((String)targetPage.getId(), (String)draftOfExistingPage.getTargetPageId());
        TestNoteService.assertEquals((String)"1", (String)draftOfExistingPage.getTargetPageRevision());
        draftOfNewPage.setTitle("Draft page updated");
        draftOfNewPage.setContent("Draft page content updated");
        DraftPage updatedDraftOfNewPage = this.noteService.updateDraftForNewPage(draftOfNewPage, now);
        TestNoteService.assertNotNull((Object)updatedDraftOfNewPage);
        TestNoteService.assertEquals((String)updatedDraftOfNewPage.getTitle(), (String)draftOfNewPage.getTitle());
        TestNoteService.assertEquals((String)updatedDraftOfNewPage.getContent(), (String)draftOfNewPage.getContent());
        TestNoteService.assertTrue((boolean)updatedDraftOfNewPage.isNewPage());
        TestNoteService.assertTrue((boolean)updatedDraftOfNewPage.isDraftPage());
        draftOfExistingPage.setTitle("Draft of page");
        draftOfExistingPage.setContent("Draft of page updated");
        DraftPage updatedDraftOfExistingPage = this.noteService.updateDraftForExistPage(draftOfExistingPage, targetPage, null, now, root.getUserId());
        TestNoteService.assertNotNull((Object)updatedDraftOfExistingPage);
        TestNoteService.assertEquals((String)updatedDraftOfExistingPage.getTitle(), (String)draftOfExistingPage.getTitle());
        TestNoteService.assertEquals((String)updatedDraftOfExistingPage.getContent(), (String)draftOfExistingPage.getContent());
        TestNoteService.assertFalse((boolean)updatedDraftOfExistingPage.isNewPage());
        TestNoteService.assertTrue((boolean)updatedDraftOfExistingPage.isDraftPage());
    }

    private String getDraftNameSuffix(long clientTime) {
        return new SimpleDateFormat("yyyyMMddHHmmssSSS").format(new Date(clientTime));
    }

    public void testGEtNoteById() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("exported1", "exported1"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal", note1.getName()));
        Page note = this.noteService.getNoteById(note1.getId(), root, "");
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertEquals((String)note.getName(), (String)note1.getName());
        TestNoteService.assertFalse((boolean)note.isDeleted());
        this.noteService.deleteNote(note.getWikiType(), note.getWikiOwner(), note.getName());
        Page deletedNote = this.noteService.getNoteById(note1.getId(), root, "");
        TestNoteService.assertNotNull((Object)deletedNote);
        TestNoteService.assertTrue((boolean)deletedNote.isDeleted());
    }

    public void testGetNoteByIdAndLang() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("testPage", "testPage"), root);
        note1.setLang("en");
        this.noteService.createVersionOfNote(note1, "root");
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal", note1.getName()));
        Page note = this.noteService.getNoteByIdAndLang(Long.valueOf(note1.getId()), root, "", "en");
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertEquals((String)note.getName(), (String)note1.getName());
        TestNoteService.assertFalse((boolean)note.isDeleted());
        this.noteService.deleteNote(note.getWikiType(), note.getWikiOwner(), note.getName());
        Page deletedNote = this.noteService.getNoteById(note1.getId(), root, "");
        TestNoteService.assertNotNull((Object)deletedNote);
        TestNoteService.assertTrue((boolean)deletedNote.isDeleted());
    }

    public void testGetPageAvailableTranslationLanguages() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testLang", "testLang"), root);
        note.setLang("ar");
        this.noteService.createVersionOfNote(note, "root");
        this.noteService.createVersionOfNote(note, "root");
        note.setLang("en");
        this.noteService.createVersionOfNote(note, "root");
        note.setLang("fr");
        this.noteService.createVersionOfNote(note, "root");
        List langs = this.noteService.getPageAvailableTranslationLanguages(Long.valueOf(note.getId()), false);
        TestNoteService.assertNotNull((Object)langs);
        TestNoteService.assertEquals((int)3, (int)langs.size());
    }

    public void testGetVersionsHistoryOfNoteByLang() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testVersionHistory", "testVersionHistory"), root);
        List pageHistories = this.noteService.getVersionsHistoryOfNoteByLang(note, "root", null);
        TestNoteService.assertEquals((int)1, (int)pageHistories.size());
        TestNoteService.assertNull((Object)((PageHistory)pageHistories.get(0)).getLang());
        note.setLang("ar");
        this.noteService.createVersionOfNote(note, "root");
        pageHistories = this.noteService.getVersionsHistoryOfNoteByLang(note, "root", "ar");
        TestNoteService.assertEquals((int)1, (int)pageHistories.size());
        TestNoteService.assertNotNull((Object)((PageHistory)pageHistories.get(0)).getLang());
        TestNoteService.assertEquals((String)"ar", (String)((PageHistory)pageHistories.get(0)).getLang());
        pageHistories = this.noteService.getVersionsHistoryOfNoteByLang(note, "root", "en");
        TestNoteService.assertEquals((int)0, (int)pageHistories.size());
    }

    public void testGetLatestDraftPageByUserAndTargetPageAndLang() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testLatestDraft", "testLatestDraft"), root);
        DraftPage draftPage = new DraftPage();
        draftPage.setTitle("test draft");
        draftPage.setContent(note.getContent());
        draftPage.setName("test draft");
        draftPage.setTargetPageId(note.getId());
        this.noteService.createDraftForExistPage(draftPage, note, null, new Date().getTime(), "root");
        DraftPage latestDraft = this.noteService.getLatestDraftPageByTargetPageAndLang(Long.valueOf(note.getId()), null);
        TestNoteService.assertNotNull((Object)latestDraft);
    }

    public void testGetNoteOfNoteBookByName() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("test1", "test1"), root);
        TestNoteService.assertNotNull((Object)note1);
    }

    public void testExportNotes() throws Exception {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "exportPortal");
        Page page1 = new Page("exported1", "exported1");
        page1.setContent("<figure class=\"image\"><img src=\"/portal/rest/wiki/attachments/group/space//spaces/base_de_connaissances/page/4.01-_Profil_et_param\u00e8tres/Navigation param\u00e8tres.png\"></figure>");
        Page note1 = this.noteService.createNote(portalWiki, "Home", page1, root);
        Page page2 = new Page("exported2", "exported2");
        page2.setContent("<a class=\"noteLink\" href=\"exported1\" target=\"_blank\">R\u00e8gles de r\u00e9daction des tutoriels </a>");
        Page note2 = this.noteService.createNote(portalWiki, "Home", page2, root);
        Page page3 = new Page("exported3", "exported3");
        page3.setContent("<a class=\"noteLink\" href=\"" + note2.getId() + "\">Home</a>");
        Page note3 = this.noteService.createNote(portalWiki, "Home", page3, root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "exportPortal", note1.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "exportPortal", note2.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "exportPortal", note3.getName()));
        String[] notes = new String[]{note1.getId(), note2.getId(), note3.getId()};
        this.notesExportService.startExportNotes(200231, notes, true, root);
        boolean exportDone = false;
        while (!exportDone) {
            if (!this.notesExportService.getStatus(200231).getStatus().equals("ZIP_CREATED")) continue;
            exportDone = true;
        }
        byte[] exportedNotes = this.notesExportService.getExportedNotes(200231);
        TestNoteService.assertNotNull((Object)exportedNotes);
    }

    public void testImportNotes() throws Exception {
        Identity user = new Identity("user");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "importPortal");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported1", "to_be_imported1"), user);
        Page note2 = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported2", "to_be_imported2"), user);
        Page note3 = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported3", "to_be_imported3"), user);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "importPortal", note1.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "importPortal", note2.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "importPortal", note3.getName()));
        String[] notes = new String[]{note1.getId(), note2.getId(), note3.getId()};
        File zipFile = File.createTempFile("notesExport", ".zip");
        this.notesExportService.startExportNotes(200231, notes, true, user);
        boolean exportDone = false;
        while (!exportDone) {
            if (!this.notesExportService.getStatus(200231).getStatus().equals("ZIP_CREATED")) continue;
            exportDone = true;
        }
        byte[] exportedNotes = this.notesExportService.getExportedNotes(200231);
        TestNoteService.assertNotNull((Object)exportedNotes);
        FileUtils.writeByteArrayToFile((File)zipFile, (byte[])exportedNotes);
        Wiki userWiki = this.getOrCreateWiki(this.wService, PortalConfig.USER_TYPE, "root");
        int childern = this.noteService.getChildrenNoteOf(userWiki.getWikiHome(), false, false).size();
        this.noteService.importNotes(zipFile.getPath(), userWiki.getWikiHome(), "update", user);
        TestNoteService.assertTrue((boolean)zipFile.delete());
        TestNoteService.assertEquals((int)this.noteService.getChildrenNoteOf(userWiki.getWikiHome(), false, false).size(), (int)(childern + 3));
    }

    public void testGetNotesOfWiki() throws WikiException, IllegalAccessException {
        Identity user = new Identity("user");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal1");
        Page toBeImported1NotPage = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported1", "to_be_imported1"), user);
        Page toBeImported2NotPage = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported2", "to_be_imported2"), user);
        Page toBeImported3NotPage = this.noteService.createNote(portalWiki, "Home", new Page("to_be_imported3", "to_be_imported3"), user);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal1", toBeImported1NotPage.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal1", toBeImported2NotPage.getName()));
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal1", toBeImported3NotPage.getName()));
        List pages = this.noteService.getNotesOfWiki(portalWiki.getType(), portalWiki.getOwner());
        TestNoteService.assertEquals((int)pages.size(), (int)4);
    }

    public void testDeleteNote1() throws WikiException, IllegalAccessException {
        Identity user = new Identity("user");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal2");
        Page notePage = this.noteService.createNote(portalWiki, "Home", new Page("note1", "note1"), user);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal2", notePage.getName()));
        this.noteService.deleteNote(PortalConfig.PORTAL_TYPE, "testPortal2", notePage.getName(), user);
        TestNoteService.assertNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal2", notePage.getName()));
    }

    public void testDeleteVersionsByNoteIdAndLang() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note1 = this.noteService.createNote(portalWiki, "Home", new Page("testPage1", "testPage1"), root);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(PortalConfig.PORTAL_TYPE, "testPortal", note1.getName()));
        note1 = this.noteService.getNoteById(note1.getId());
        note1.setLang("en");
        note1.setTitle("englishTitle");
        this.noteService.createVersionOfNote(note1, "root");
        note1.setLang("fr");
        note1.setTitle("frenchTitle");
        this.noteService.createVersionOfNote(note1, "root");
        this.noteService.deleteVersionsByNoteIdAndLang(Long.valueOf(note1.getId()), "en");
        Page note = this.noteService.getNoteByIdAndLang(Long.valueOf(note1.getId()), root, "", "en");
        TestNoteService.assertEquals((String)note.getTitle(), (String)"testPage1");
        note = this.noteService.getNoteByIdAndLang(Long.valueOf(note1.getId()), root, "", "fr");
        TestNoteService.assertNotNull((Object)note);
        TestNoteService.assertEquals((String)note.getTitle(), (String)"frenchTitle");
        this.noteService.deleteVersionsByNoteIdAndLang(Long.valueOf(note.getId()), "fr");
        note = this.noteService.getNoteByIdAndLang(Long.valueOf(note1.getId()), root, "", "fr");
        TestNoteService.assertEquals((String)note.getTitle(), (String)"testPage1");
        this.noteService.deleteNote(note1.getWikiType(), note1.getWikiOwner(), note1.getName());
        Page deletedNote = this.noteService.getNoteById(note1.getId(), root, "");
        TestNoteService.assertNotNull((Object)deletedNote);
        TestNoteService.assertTrue((boolean)deletedNote.isDeleted());
    }

    public void testGetChildrenNoteOf() throws WikiException, IllegalAccessException {
        Identity user = new Identity("user");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "importPortal");
        this.noteService.createNote(portalWiki, "Home", new Page("imported1", "imported1"), user);
        this.noteService.createNote(portalWiki, "Home", new Page("imported2", "imported2"), user);
        Page home = portalWiki.getWikiHome();
        int childern = this.noteService.getChildrenNoteOf(home, false, false).size();
        NoteToExport note = new NoteToExport();
        note.setId(home.getId());
        note.setName(home.getName());
        note.setTitle(home.getTitle());
        note.setWikiId(home.getWikiId());
        note.setWikiOwner(home.getWikiOwner());
        note.setWikiType(home.getWikiType());
        int eXportCildren = this.noteService.getChildrenNoteOf(note).size();
        TestNoteService.assertEquals((int)eXportCildren, (int)childern);
    }

    public void testRemoveDraftOfNote() throws WikiException, IllegalAccessException {
        Identity root = new Identity("root");
        this.startSessionAs("root");
        long now = new Date().getTime();
        String pageName = "new page 10";
        Page targetPage = new Page(pageName, pageName);
        targetPage.setContent("Page content");
        Wiki userWiki = this.getOrCreateWiki(this.wService, PortalConfig.USER_TYPE, "root");
        targetPage = this.noteService.createNote(userWiki, "Home", new Page("TestPage1", "TestPage1"), root);
        DraftPage draftPageTosave = new DraftPage();
        String draftTitle = targetPage.getTitle() + "_draft";
        String draftContent = targetPage.getContent() + "_draft";
        draftPageTosave.setTitle(draftTitle);
        draftPageTosave.setContent(draftContent);
        draftPageTosave.setLang("fr");
        String draftName = targetPage.getName() + "_" + this.getDraftNameSuffix(now);
        DraftPage draftOfExistingPage = this.noteService.createDraftForExistPage(draftPageTosave, targetPage, null, now, root.getUserId());
        TestNoteService.assertNotNull((Object)draftOfExistingPage);
        TestNoteService.assertFalse((boolean)draftOfExistingPage.isNewPage());
        TestNoteService.assertEquals((String)draftOfExistingPage.getName(), (String)draftName);
        TestNoteService.assertEquals((String)targetPage.getId(), (String)draftOfExistingPage.getTargetPageId());
        TestNoteService.assertEquals((String)"1", (String)draftOfExistingPage.getTargetPageRevision());
        DraftPage draft = this.noteService.getLatestDraftOfPage(targetPage);
        TestNoteService.assertEquals((String)draft.getId(), (String)draftOfExistingPage.getId());
        WikiPageParams noteParams = new WikiPageParams(targetPage.getWikiType(), targetPage.getWikiOwner(), targetPage.getName());
        this.noteService.removeDraftOfNote(noteParams, "en");
        draft = this.noteService.getLatestDraftOfPage(targetPage);
        TestNoteService.assertEquals((String)draft.getId(), (String)draftOfExistingPage.getId());
        this.noteService.removeDraftOfNote(noteParams, "fr");
        draft = this.noteService.getLatestDraftOfPage(targetPage);
        TestNoteService.assertNull((Object)draft);
    }

    public void testGetNoteOfNoteBookByNameWithLangMetadata() throws WikiException, IllegalAccessException {
        Identity user = new Identity("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testNoteLangMetadata", "testNoteLangMetadata"), user);
        TestNoteService.assertNotNull((Object)this.noteService.getNoteOfNoteBookByName(note.getWikiType(), note.getWikiOwner(), note.getName(), "en", user));
    }

    public void testGetPublishedVersionByPageIdAndLang() throws WikiException, IllegalAccessException {
        Identity user = new Identity("user");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.PORTAL_TYPE, "testPortal");
        Page note = this.noteService.createNote(portalWiki, "Home", new Page("testNotee", "testNotee"), user);
        TestNoteService.assertNull((Object)this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(note.getId()), "en"));
        note.setLang("en");
        note.setTitle("english title");
        note.setContent("english content");
        this.noteService.createVersionOfNote(note, user.getUserId());
        TestNoteService.assertNotNull((Object)this.noteService.getPublishedVersionByPageIdAndLang(Long.valueOf(note.getId()), "en"));
    }

    public void testRemoveOrphanDraftPagesByParentPage() throws Exception {
        this.startSessionAs("root");
        Wiki portalWiki = this.getOrCreateWiki(this.wService, PortalConfig.GROUP_TYPE, "/platform/users");
        Page homePage = this.noteService.getNoteById(portalWiki.getWikiHome().getId());
        DraftPage draft = new DraftPage();
        draft.setParentPageId(homePage.getId());
        draft.setTargetPageId(null);
        draft = this.noteService.createDraftForNewPage(draft, new Date().getTime());
        TestNoteService.assertNotNull((Object)draft);
        this.noteService.removeOrphanDraftPagesByParentPage(Long.parseLong(homePage.getId()));
        AbstractCoreTest.persist();
        TestNoteService.assertNull((Object)this.noteService.getDraftNoteById(draft.getId(), "root"));
    }
}

