/*
 * Decompiled with CFR 0.152.
 */
package io.meeds.notes.listener;

import io.meeds.notes.listener.NotesMetadataListener;
import java.util.Set;
import org.exoplatform.portal.config.UserACL;
import org.exoplatform.services.listener.Event;
import org.exoplatform.social.core.identity.model.Identity;
import org.exoplatform.social.core.manager.IdentityManager;
import org.exoplatform.social.core.space.model.Space;
import org.exoplatform.social.core.space.spi.SpaceService;
import org.exoplatform.social.metadata.tag.TagService;
import org.exoplatform.social.metadata.tag.model.TagObject;
import org.exoplatform.wiki.model.Page;
import org.junit.Before;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.mockito.Mock;
import org.mockito.Mockito;
import org.mockito.junit.MockitoJUnitRunner;
import org.mockito.verification.VerificationMode;

@RunWith(value=MockitoJUnitRunner.class)
public class NotesMetadataListenerTest {
    private NotesMetadataListener notesMetadataListener;
    @Mock
    private TagService tagService;
    @Mock
    private IdentityManager identityManager;
    @Mock
    private SpaceService spaceService;
    @Mock
    private UserACL userACL;

    @Before
    public void setUp() throws Exception {
        this.notesMetadataListener = new NotesMetadataListener(this.identityManager, this.spaceService, this.tagService, this.userACL);
    }

    @Test
    public void onEvent() {
        Identity identity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.userACL.getSuperUser()).thenReturn((Object)"user");
        Mockito.when((Object)this.identityManager.getOrCreateUserIdentity("user")).thenReturn((Object)identity);
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        Identity spaceidentity = (Identity)Mockito.mock(Identity.class);
        Mockito.when((Object)this.identityManager.getOrCreateSpaceIdentity("space")).thenReturn((Object)spaceidentity);
        Mockito.when((Object)spaceidentity.getId()).thenReturn((Object)"2");
        Mockito.when((Object)identity.getId()).thenReturn((Object)"1");
        Space space = new Space();
        space.setPrettyName("space");
        Mockito.when((Object)this.spaceService.getSpaceByGroupId("/spaces/space")).thenReturn((Object)space);
        Page note = new Page();
        note.setId("1");
        note.setWikiOwner("/spaces/space");
        note.setContent("test ><a class=\"metadata-tag\">#testTag</a></span>");
        Event event = new Event("note.posted", (Object)"user", (Object)note);
        this.notesMetadataListener.onEvent(event);
        Set tagNames = this.tagService.detectTagNames(note.getContent());
        ((TagService)Mockito.verify((Object)this.tagService, (VerificationMode)Mockito.times((int)1))).saveTags(new TagObject("notes", note.getId(), note.getParentPageId()), tagNames, 2L, 1L);
        Mockito.clearInvocations((Object[])new TagService[]{this.tagService});
        event = new Event("note.updated", null, (Object)note);
        this.notesMetadataListener.onEvent(event);
        ((TagService)Mockito.verify((Object)this.tagService, (VerificationMode)Mockito.times((int)1))).saveTags(new TagObject("notes", note.getId(), note.getParentPageId()), tagNames, 2L, 1L);
    }
}

